package com.zatackcoder.androidanimations;

import androidx.appcompat.app.AppCompatActivity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;

public class MainActivity extends AppCompatActivity {

    ImageView imageView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        imageView = findViewById(R.id.imageView);
    }

    public  void handleClick(View view) {
        switch (view.getId()) {
            case R.id.fadeOut : imageView.animate().alpha(0.0f).setDuration(300);
                break;
            case R.id.fadeIn : imageView.animate().alpha(1.0f).setDuration(300);
                break;
            case R.id.fadeInOut :
                imageView.animate().alpha(0.0f).setDuration(400).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        imageView.animate().alpha(1.0f).setDuration(400);
                        imageView.animate().setListener(null);
                    }
                });
                break;
            case R.id.slideDown : imageView.animate().translationY(imageView.getHeight()).setDuration(300);
                break;
            case R.id.slideUp : imageView.animate().translationY(0).setDuration(300);
                break;
            case R.id.slideUpDown :
                imageView.animate().translationY(imageView.getHeight()).setDuration(300).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        imageView.animate().translationY(0).setDuration(300);
                        imageView.animate().setListener(null);
                    }
                });
                break;
            case R.id.slideLeft : imageView.animate().translationX(-imageView.getWidth()).setDuration(300);
                break;
            case R.id.slideRight : imageView.animate().translationX(0).setDuration(300);
                break;
            case R.id.slideLeftRight :
                imageView.animate().translationX(-imageView.getWidth()).setDuration(300).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        imageView.animate().translationX(0).setDuration(300);
                        imageView.animate().setListener(null);
                    }
                });
                break;
            case R.id.rotateLeft : imageView.animate().rotation(-90).setDuration(300);
                break;
            case R.id.rotateRight : imageView.animate().rotation(0).setDuration(300);
                break;
            case R.id.rotateLeftRight :
                imageView.animate().rotation(-90).setDuration(300).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        imageView.animate().rotation(0).setDuration(300);
                        imageView.animate().setListener(null);
                    }
                });
                break;
            case R.id.scaleDown :
                imageView.animate().scaleX(0f).scaleY(0f).setDuration(300);
                break;
            case R.id.scaleUp :
                imageView.animate().scaleX(1).scaleY(1f).setDuration(300);
                break;
            case R.id.scaleUpDown :
                imageView.animate().scaleX(0f).scaleY(0f).setDuration(300).setListener(new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        imageView.animate().scaleX(1).scaleY(1).setDuration(300);
                        imageView.animate().setListener(null);
                    }
                });
                break;
        }
    }
}
