<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Products List - Ajax Pagination</title>
        <style>
            .card {
                box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
                max-width: 300px;
                margin: auto;
                text-align: center;
                font-family: arial;
                list-style: none;
                float: left;
                margin: 10px;
            }

            .price {
                color: grey;
                font-size: 22px;
            }

            .card button {
                border: none;
                outline: 0;
                padding: 12px;
                color: white;
                background-color: #000;
                text-align: center;
                cursor: pointer;
                width: 100%;
                font-size: 18px;
            }

            .card button:hover {
                opacity: 0.7;
            }

            /* Pagination links */
            .pagination a {
                color: black;
                float: left;
                padding: 8px 16px;
                text-decoration: none;
                transition: background-color .3s;
            }

            /* Style the active/current link */
            .pagination a.active {
                background-color: dodgerblue;
                color: white;
            }

            /* Add a grey background color on mouse-over */
            .pagination a:hover:not(.active) {background-color: #ddd;} 
        </style>
    </head>
    <body>
        <h1>
            Products
            <input type="text" id="search" placeholder="Press Enter After Typing Your Query" style="float: right;"/>
        </h1>
        <ul id="products-list">
            
        </ul>
        <div style="clear: both;"></div>
        <div class="pagination" style="margin-left: 35px; margin-top: 10px;">
            
        </div>

        <script src="https://code.jquery.com/jquery-3.5.0.min.js" integrity="sha256-xNzN2a4ltkB44Mc/Jz3pT4iU1cmeR0FkXs4pru/JxaQ=" crossorigin="anonymous"></script>
        <script>
            $("#search").keypress(function(event){
                if(event.keyCode == "13") { 
                    load(1);
                } 
            });
            $(".pagination").on("click", "a", function () {
                load($(this).attr("page"));
            });

            function load(page) {
                var data = new FormData();
                data.append("s", $("#search").val());

                $.ajax({
                    type: 'POST',
                    url: "requests.php?action=get-products&paged=" + page,
                    data: data,
                    contentType: false,
                    processData: false,

                }).done(function (data) {
                    if (data.code === '0') {
                        $('#products-list').find('.card').remove();
                        for (var i = 0; i < data.products.length; i++) {
                            var template = $('#product-template').text();
                            var imgsrc = data.products[i].photo ? data.products[i].photo : "http://placehold.it/220x220";
                            template = template.replace('%%imgsrc%%', imgsrc);
                            template = template.replace('%%alt%%', data.products[i].name);
                            template = template.replace('%%name%%', data.products[i].name.substring(0, 25));
                            template = template.replace('%%price%%', data.products[i].price);
                            $('#products-list').append(template);
                        }
                        
                        var pages = '<a href="javascript:;" page="' + (parseInt(data.page) - 1) + '">&laquo;</a>';
                        for (var i = 1; i <= data.pages; i++) {
                            pages += '<a href="javascript:;" page="' + i + '" class="' + (data.page == i ? 'active' : '') + '">' + i + '</a>';
                        }
                        pages += '<a href="javascript:;" page="' + (parseInt(data.page) + 1) + '">&raquo;</a>';
                        $(".pagination").html(pages);

                    }
                }).fail(function (data) {
                    //any message
                });
            }
            //load first page
            load(1);
        </script>
        <!-- product template -->
        <script type="text/html" id="product-template">
            <li class="card">
                <img src="%%imgsrc%%" alt="%%alt%%" style="width:100%">
                <h1>%%name%%</h1>
                <p class="price">₹%%price%%</p>
                <p><button>Add to Cart</button></p>
            </li>
        </script>
    </body>
</html>
