<?php

include_once 'config.php';

if (!isset($_REQUEST['action'])) {
    echo "Please provide action parameter";
    die();
}

$action = trim($_REQUEST['action']);

if ($action == "get-products") {
    $response['code'] = '0';
    $filters['query'] = isset($_REQUEST['s']) ? filter_var(trim($_REQUEST['s']), FILTER_SANITIZE_STRING) : "";

    /* pagination logic start */
    $items_count = count(getProducts(array('id'), $filters, 0, -1));
    $items_per_page = isset($_REQUEST['per_page']) ? $_REQUEST['per_page'] : 5;
    $items_per_page = $items_per_page > 50 ? 50 : $items_per_page;
    $max_pages = intval($items_count / $items_per_page + 1);
    $current_page = !isset($_REQUEST['paged']) || intval($_REQUEST['paged']) < 1 ? 1 : filter_var(trim($_REQUEST['paged']), FILTER_SANITIZE_NUMBER_INT);
    $current_page = $current_page > $max_pages ? $max_pages : $current_page;
    $offset = $items_per_page * $current_page - $items_per_page;
    /* pagination logic end */

    $order_by = (isset($_REQUEST['order_by']) && in_array(trim($_REQUEST['order_by']), array("id", "name", "price"))) ? trim($_REQUEST['order_by']) : 'id';
    $order = (isset($_REQUEST['order']) && in_array(trim($_REQUEST['order']), array("ASC", "DESC"))) ? trim($_REQUEST['order']) : 'DESC';
    
    $response['products'] = getProducts(array(), $filters, $offset, $items_per_page, $order_by, $order);
    $response['page'] = $current_page;
    $response['pages'] = $max_pages;
    $response['msg'] = "success";
    
    header("Content-Type:application/json");
    echo json_encode($response);
    exit();
}

