<?php

// load GCS library
require __DIR__ . '/vendor/autoload.php';

use Google\Cloud\Storage\StorageClient;

function uploadFile($bucketName, $fileContent, $cloudPath, $makePublic = false) {
    $storage = new StorageClient();
    
    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);
    
    // upload/replace file 
    $object = $bucket->upload(
            $fileContent,
            ['name' => $cloudPath]
            // if $cloudPath is existed then will be overwrite without confirmation
            // NOTE: 
            // a. do not put prefix '/', '/' is a separate folder name  !!
    );
    
    // is it succeed ?
    if($object != null) {
        if($makePublic) {
            $object->update(['acl' => []], ['predefinedAcl' => 'PUBLICREAD']);
        }
        return true;
    }
    return false;
}

function getFileInfo($bucketName, $cloudPath) {
    $storage = new StorageClient();
    
    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);
    $object = $bucket->object($cloudPath);
    return $object->info();
}

function getFiles($bucketName, $directory = null) {
    $storage = new StorageClient();
    
    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);
    
    if ($directory == null) {
        // list all files
        $objects = $bucket->objects();
    } else {
        // list all files within a directory (sub-directory)
        $options = array('prefix' => $directory);
        $objects = $bucket->objects($options);
    }

    return $objects;
}

function deleteFile($bucketName, $objectName, $options = []) {
    $storage = new StorageClient();
    
    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);
    try {
        $object = $bucket->object($objectName);
        $object->delete();
    } catch (Exception $exc) {
        //exception handling
    }
}