<?php
require_once 'config.php';

if (!getenv('BUCKET_NAME')) {
    die('Set BUCKET_NAME environment variables');
}

$bucketName = getenv('BUCKET_NAME');
if (isset($_REQUEST['delete']) && isset($_REQUEST['name'])) {
    $fileName = urldecode($_REQUEST['name']);
    deleteFile($bucketName, $fileName);
    //header("Location: /");
    echo '<script>window.location.href = "/"</script>';
    exit();
}

$objects = getFiles($bucketName);
?>
<html>
    <head>
        <title>Objects in Bucket</title>
    </head>
    <body>
        <h1>Objects in Bucket</h1>
        <form id="fileUploadForm" method="post" enctype="multipart/form-data">
            <input type="file" name="file"/>
            <input type="submit" name="upload" value="Upload"/>
            <span id="uploadingmsg"></span>
            <hr/>
        </form>
        <table border="1" style="width: 100%;">
            <thead>
                <tr>
                    <td>Object</td>
                    <td>Action</td>
                </tr>
            </thead>
            <tbody id="objects">
                <?php foreach ($objects as $o) {
                    $oinfo = $o->info();
                    ?>
                <tr>
                    <td><a href="https://storage.googleapis.com/<?= $oinfo['bucket'] ?>/<?= $oinfo['name'] ?>"><?= $o->name() ?></a></td>
                    <td><a href="/?delete=1&name=<?= urlencode($o->name()) ?>">Delete</a></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <script src="https://code.jquery.com/jquery-3.5.1.min.js" integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0=" crossorigin="anonymous"></script>
        <script>
            $("#fileUploadForm").submit(function (e) {
                e.preventDefault();
                var action = "requests.php?action=upload";
                $("#uploadingmsg").html("Uploading...");
                var data = new FormData(e.target);
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data, 
                    /*THIS MUST BE DONE FOR FILE UPLOADING*/
                    contentType: false,
                    processData: false,
                }).done(function (response) {
                    $("#uploadingmsg").html(response.msg);
                    //https://storage.googleapis.com/[BUCKET_NAME]/[OBJECT_NAME]
                    if (response.code == '200') {
                        window.location.reload();
                    }
                }).fail(function (data) {
                    //any message
                });
            });
        </script>
    </body>
</html>