<?php

define("DATABASE_NAME", "applications");//database name
define("T_INSTALLATIONS", "installations");//table name

function getConnection() {
    $servername = "localhost"; //database host
    $username = "root"; // database username
    $password = ""; //database password
    // Create connection
    $conn = new mysqli($servername, $username, $password, DATABASE_NAME);
    // Check connection
    if (mysqli_connect_error()) {
        die("Database connection failed: " . mysqli_connect_error());
    } else {
        return $conn;
    }
}

function isInsallationDataExists($data) {
    $conn = getConnection();

    $application = mysqli_real_escape_string($conn, trim($data['application']));
    $client_addr = mysqli_real_escape_string($conn, trim($data['client_addr']));
    $client_mac = mysqli_real_escape_string($conn, trim($data['client_mac']));

    if($client_mac <> "") {
        $result = $conn->query("SELECT id FROM " . T_INSTALLATIONS . " WHERE client_mac = '{$client_mac}' AND application = '{$application}'");
        return ($result->num_rows > 0 ? true : false);
    }
    
    $results = $conn->query("SELECT id FROM " . T_INSTALLATIONS . " WHERE client_addr = '{$client_addr}' AND application = '{$application}'");
    if ($results->num_rows > 0) {
        return true;
    }
    return false;
}

function addInstallationData($data) {
    $conn = getConnection();

    $application = mysqli_real_escape_string($conn, trim($data['application']));
    $client_name = mysqli_real_escape_string($conn, trim($data['client_name']));
    $client_addr = mysqli_real_escape_string($conn, trim($data['client_addr']));
    $client_mac = mysqli_real_escape_string($conn, trim($data['client_mac']));
    $last_used = mysqli_real_escape_string($conn, trim($data['last_used']));
    $status = mysqli_real_escape_string($conn, trim($data['status']));

    if ($application == '' || $client_name == '' || $client_addr == '' || isInsallationDataExists($data)) {
        return;
    }

    return $conn->query("INSERT INTO " . T_INSTALLATIONS . " (application, client_name, client_addr, client_mac, last_used, status) VALUES('{$application}', '{$client_name}', '{$client_addr}', '{$client_mac}', '{$last_used}', '{$status}')");
}

function updateInstallationData($data) {
    $conn = getConnection();

    $application = mysqli_real_escape_string($conn, trim($data['application']));
    $client_addr = mysqli_real_escape_string($conn, trim($data['client_addr']));
    $client_mac = mysqli_real_escape_string($conn, trim($data['client_mac']));
    $last_used = mysqli_real_escape_string($conn, trim($data['last_used']));
    $status = mysqli_real_escape_string($conn, trim($data['status']));

    if($client_mac <> "") {
        return $conn->query("UPDATE " . T_INSTALLATIONS . " SET last_used = '{$last_used}', status = '{$status}' WHERE client_mac = '{$client_mac}' AND application = '{$application}'");
    }
    return $conn->query("UPDATE " . T_INSTALLATIONS . " SET last_used = '{$last_used}', status = '{$status}' WHERE client_addr = '{$client_addr}' AND application = '{$application}'");
}

function getInstallationsData($columns = array(), $filters = array(), $limit = -1, $offset = 0, $order_by = 'id', $order = 'ASC') {
    $conn = getConnection();

    $data = array();
    $sql = "SELECT * FROM " . T_INSTALLATIONS . " WHERE 1";
    if (!empty($columns) && is_array($columns)) {
        $sql = "SELECT `" . implode("`,`", $columns) . "` FROM " . T_INSTALLATIONS . " WHERE 1";
    }
    if (isset($filters['application']) && trim($filters['application']) <> "") {
        $application = mysqli_real_escape_string($conn, $filters['application']);
        $sql .= " AND application LIKE '%{$application}%'";
    }
    if (isset($filters['client_name']) && trim($filters['client_name']) <> "") {
        $client_name = mysqli_real_escape_string($conn, $filters['client_name']);
        $sql .= " AND client_name = '{$client_name}'";
    }
    if (isset($filters['client_addr']) && trim($filters['client_addr']) <> "") {
        $client_addr = mysqli_real_escape_string($conn, $filters['client_addr']);
        $sql .= " AND client_addr = '{$client_addr}'";
    }
    if (isset($filters['client_mac']) && trim($filters['client_mac']) <> "") {
        $client_mac = mysqli_real_escape_string($conn, $filters['client_mac']);
        $sql .= " AND client_mac = '{$client_mac}'";
    }
    if (isset($filters['status']) && trim($filters['status']) <> "") {
        $status = mysqli_real_escape_string($conn, $filters['status']);
        $sql .= " AND status = '{$status}'";
    }
    if (isset($filters['q']) && trim($filters['q']) <> "") {
        $q = mysqli_real_escape_string($conn, $filters['q']);
        $sql .= " AND (application LIKE '%{$q}%' OR client_name LIKE '%{$q}%' OR client_addr LIKE '%{$q}%')";
    }
    $sql .= " ORDER BY {$order_by} {$order}";
    if ($limit != -1 && is_numeric($offset) && is_numeric($limit)) {
        $sql .= " LIMIT {$offset}, {$limit}";
    }
    $results = $conn->query($sql);
    while ($row = $results->fetch_assoc()) {
        $data[] = $row;
    }
    return $data;
}

function getInstallationData($id) {
    $conn = getConnection();
    $data = null;
    
    $id = mysqli_real_escape_string($conn, trim($id));
    $results = $conn->query("SELECT * FROM " . T_INSTALLATIONS . " WHERE id = '{$id}'");
    while ($row = $results->fetch_assoc()) {
        $data = $row;
    }
    return $data;
}
