<?php

require 'config.php';

if (isset($_REQUEST['application']) && isset($_REQUEST['client_name']) && isset($_REQUEST['client_addr'])) {
    $data['application'] = filter_var(trim($_REQUEST['application']), FILTER_SANITIZE_STRING);
    $data['client_name'] = filter_var(trim($_REQUEST['client_name']), FILTER_SANITIZE_STRING);
    $data['client_addr'] = filter_var(trim($_REQUEST['client_addr']), FILTER_SANITIZE_STRING);
    $data['client_mac'] = isset($_REQUEST['client_mac']) ? filter_var(trim($_REQUEST['client_mac']), FILTER_SANITIZE_STRING) : "";
    $data['last_used'] = date("Y-m-d H:i:s");
    $data['status'] = isset($_REQUEST['status']) ? filter_var(trim($_REQUEST['status']), FILTER_SANITIZE_STRING) : "active";

    if (isInsallationDataExists($data)) {
        $filters = array("client_addr" => $data['client_addr']);
        if ($data['client_mac'] <> "") {
            $filters = array("client_mac" => $data['client_mac']);
        }
        $datas = getInstallationsData(array("status"), $filters);
        foreach ($datas as $d) {
            $status = $d['status'];
        }
        if(in_array($status, array("suspended", "deleted"))) {
            $data['status'] = $status;
        }
        updateInstallationData($data);
    } else {
        $status = $data['status'];
        addInstallationData($data);
    }

    echo $status;
}