<?php include_once 'config.php'; ?>
<?php
if(isset($_REQUEST['action']) && isset($_REQUEST['id']) && trim($_REQUEST['id']) <> "") {
    $data = getInstallationData(filter_var(trim($_REQUEST['id']), FILTER_SANITIZE_NUMBER_INT));
    if(trim($_REQUEST['action']) == "suspend") { 
        $data['status'] = "suspend";
    } else if(trim($_REQUEST['action']) == "delete") {
        $data['status'] = "delete";
    } else if(trim($_REQUEST['action']) == "activate") {
        $data['status'] = "active";
    }
    if(updateInstallationData($data)) {
        header("location: index.php?msg=Updated Successfully");
        exit();
    }
}
$installations = getInstallationsData();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Application Installations</title>
    </head>
    <body>
        <h2>Application Installations</h2>
        <?= isset($_GET['msg']) ? '<p>' . $_GET['msg'] . '</p>' : '' ?>
        <table border="1" width="100%">
            <thead>
                <tr>
                    <td>Id</td>
                    <td>Application</td>
                    <td>Client Name</td>
                    <td>Client Addr</td>
                    <td>Client MAC</td>
                    <td>Last Used</td>
                    <td>Status</td>
                    <td>Action</td>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($installations as $i) { ?>
                <tr>
                    <td><?= $i['id'] ?></td>
                    <td><?= $i['application'] ?></td>
                    <td><?= $i['client_name'] ?></td>
                    <td><?= $i['client_addr'] ?></td>
                    <td><?= $i['client_mac'] ?></td>
                    <td><?= $i['last_used'] ?></td>
                    <td><?= $i['status'] ?></td>
                    <td>
                        <a href="index.php?action=activate&id=<?= $i['id'] ?>">Activate</a>
                        <a href="index.php?action=suspend&id=<?= $i['id'] ?>" onclick="return confirm('Sure? You want to suspend.')">Suspend</a>
                        <a href="index.php?action=delete&id=<?= $i['id'] ?>" style="color:red;" onclick="return confirm('Sure? You want to terminate.')">Terminate</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </body>
</html>
