/*
 * Decompiled with CFR 0.152.
 */
package browser;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;
import javax.swing.JOptionPane;

public class BrowserController
implements Initializable {
    @FXML
    BorderPane browserBP;
    @FXML
    WebView browserWV;
    @FXML
    ImageView stopReloadIV;
    @FXML
    TextField addressBarTF;
    @FXML
    ProgressIndicator progressPI;
    @FXML
    Label statusL;

    public void initialize(URL url, ResourceBundle rb) {
        this.browserWV.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                BrowserController.this.statusL.setText("loading... " + BrowserController.this.browserWV.getEngine().getLocation());
                BrowserController.this.stopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/stoploading.png")));
                BrowserController.this.progressPI.setVisible(true);
                if (newValue == Worker.State.SUCCEEDED) {
                    BrowserController.this.addressBarTF.setText(BrowserController.this.browserWV.getEngine().getLocation());
                    BrowserController.this.statusL.setText("loaded");
                    BrowserController.this.progressPI.setVisible(false);
                    BrowserController.this.stopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/reload.png")));
                    if (BrowserController.this.browserBP.getParent() != null) {
                        TabPane tp = (TabPane)BrowserController.this.browserBP.getParent().getParent();
                        for (Tab tab : tp.getTabs()) {
                            if (tab.getContent() != BrowserController.this.browserBP) continue;
                            tab.setText(BrowserController.this.browserWV.getEngine().getTitle());
                            break;
                        }
                    }
                }
            }
        });
    }

    @FXML
    private void browserBackButtonAction(ActionEvent event) {
        if (this.browserWV.getEngine().getHistory().getCurrentIndex() <= 0) {
            return;
        }
        this.browserWV.getEngine().getHistory().go(-1);
    }

    @FXML
    private void browserForwardButtonAction(ActionEvent event) {
        if (this.browserWV.getEngine().getHistory().getCurrentIndex() + 1 >= this.browserWV.getEngine().getHistory().getEntries().size()) {
            return;
        }
        this.browserWV.getEngine().getHistory().go(1);
    }

    @FXML
    private void browserGoButtonAction(ActionEvent event) {
        String url = this.addressBarTF.getText().trim();
        if (url.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No url provided");
            return;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        this.browserWV.getEngine().load(url);
    }

    @FXML
    private void browserStopReloadButtonAction(ActionEvent event) {
        if (this.browserWV.getEngine().getLoadWorker().isRunning()) {
            this.browserWV.getEngine().getLoadWorker().cancel();
            this.statusL.setText("loaded");
            this.progressPI.setVisible(false);
            this.stopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/reload.png")));
        } else {
            this.browserWV.getEngine().reload();
            this.stopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/stoploading.png")));
        }
    }

    @FXML
    private void browserHomeButtonAction(ActionEvent event) {
        this.browserWV.getEngine().loadContent("<html><title>New Tab</title></html>");
        this.addressBarTF.setText("");
    }
}

