/*
 * Decompiled with CFR 0.152.
 */
package com.zatackcoder;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;

public class CalculatorUIController
implements Initializable {
    Double temp = 0.0;
    Double sum = 0.0;
    boolean isOperatorPressed;
    String operatorPressed = "";
    @FXML
    TextField outputTF;

    public void initialize(URL url, ResourceBundle rb) {
        this.outputTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*([\\.]\\d*)?")) {
                    CalculatorUIController.this.outputTF.setText(oldValue);
                }
            }
        });
    }

    @FXML
    private void onNumberClick(ActionEvent event) {
        if (event.getSource() instanceof Button) {
            Button btn = (Button)event.getSource();
            if (this.isOperatorPressed) {
                this.outputTF.setText(btn.getText().trim());
            } else {
                this.outputTF.setText(this.outputTF.getText().trim() + btn.getText().trim());
            }
            this.isOperatorPressed = false;
        }
    }

    @FXML
    private void onOperatorClick(ActionEvent event) {
        if (event.getSource() instanceof Button) {
            Button btn = (Button)event.getSource();
            if (!this.outputTF.getText().isEmpty()) {
                this.temp = Double.valueOf(this.outputTF.getText());
                if (btn.getText().equals("%")) {
                    this.temp = this.sum * this.temp / 100.0;
                }
                switch (this.operatorPressed) {
                    case "/": {
                        this.sum = this.sum / this.temp;
                        break;
                    }
                    case "X": {
                        this.sum = this.sum * this.temp;
                        break;
                    }
                    case "+": {
                        this.sum = this.sum + this.temp;
                        break;
                    }
                    case "-": {
                        this.sum = this.sum - this.temp;
                        break;
                    }
                    default: {
                        this.sum = this.temp;
                    }
                }
            }
            if (btn.getText().equals("=") || btn.getText().equals("%")) {
                this.outputTF.setText(String.valueOf(this.sum));
                this.operatorPressed = "";
            } else {
                this.outputTF.setText("");
                this.operatorPressed = btn.getText().trim();
            }
            this.isOperatorPressed = true;
        }
    }

    @FXML
    private void onDELClick(ActionEvent event) {
        if (this.outputTF.getText().length() > 0) {
            this.outputTF.setText(this.outputTF.getText(0, this.outputTF.getText().length() - 1));
        }
    }

    @FXML
    private void onCEClick(ActionEvent event) {
        this.outputTF.setText("");
        this.temp = 0.0;
        this.sum = 0.0;
        this.isOperatorPressed = false;
        this.operatorPressed = "";
    }
}

