<?php
define('ERROR_RESPOSE_CODE', '1');
define('SUCCESS_RESPOSE_CODE', '0');

if (isset($_REQUEST['f']) && trim($_REQUEST['f']) == 'upload-video') {
    $response = array('code' => ERROR_RESPOSE_CODE, 'msg' => "Error");
    $upload_path = 'uploads/videos/';
    if (!file_exists($upload_path)) {
        mkdir($upload_path, 0777, true);
    }
    $upload_url = $upload_path;

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        //checking the required parameters from the request 
        if (isset($_FILES['video']['name'])) {
            $fileinfo = pathinfo($_FILES['video']['name']);
            $extension = $fileinfo['extension'];
            $filename = 'video_' . date('d') . '_' . md5(time());
            $file_url = $upload_url . $filename . '.' . $extension;

            //file path to upload in the server 
            $file_path = $upload_path . $filename . '.' . $extension;
            try {
                //saving the file 
                if (move_uploaded_file($_FILES['video']['tmp_name'], $file_path)) {
                    $response['code'] = SUCCESS_RESPOSE_CODE;
                    $response['file_url'] = $file_url;
                    $response['msg'] = 'Uploaded successfully!';
                    $response['htmlmsg'] = '<div class="alert alert-success">Uploaded successfully!</div>';
                }
            } catch (Exception $e) {
                $response['code'] = ERROR_RESPOSE_CODE;
                $response['msg'] = 'Error!';
                $response['htmlmsg'] = '<div class="alert alert-danger">Error!</div>';
            }
        } else {
            $response['code'] = ERROR_RESPOSE_CODE;
            $response['msg'] = 'Please choose file!';
            $response['htmlmsg'] = '<div class="alert alert-danger">Please choose file!</div>';
        }
    }
    header("Content-Type:application/json");
    echo json_encode($response);
    exit();
}

if (isset($_REQUEST['f']) && trim($_REQUEST['f']) == 'upload-video-thumbnail-base64') {
    $response = array('code' => ERROR_RESPOSE_CODE, 'msg' => "Error");
    $upload_path = 'uploads/video-thumbnails/';
    if (!file_exists($upload_path)) {
        mkdir($upload_path, 0777, true);
    }
    $upload_url =  $upload_path;

    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $filename = 'thumbnail_' . date('d') . '_' . md5(time());
        $file_url = $upload_url . $filename . '.png';

        //file path to upload in the server 
        $file_path = $upload_path . $filename . '.png';

        //saving the file 
        $img = $_POST['imgBase64'];
        $img = str_replace('data:image/png;base64,', '', $img);
        $img = str_replace(' ', '+', $img);
        $data = base64_decode($img);
        $success = file_put_contents($file_path, $data);

        if ($success) {
            $response['code'] = SUCCESS_RESPOSE_CODE;
            $response['file_url'] = $file_url;
            $response['msg'] = 'Uploaded successfully!';
            $response['htmlmsg'] = '<div class="alert alert-success">Uploaded successfully!</div>';
        } else {
            $response['code'] = ERROR_RESPOSE_CODE;
            $response['msg'] = 'Error!';
            $response['htmlmsg'] = '<div class="alert alert-danger">Error!</div>';
        }
    }
    header("Content-Type:application/json");
    echo json_encode($response);
    exit();
}
?>

