<?php
if (isset($_POST['save'])) {
    echo '<h3>Submitted Data - You Can Process According to Your Need</h3>';
    echo '<pre>'; print_r($_POST); echo '</pre>';
}
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Capture Image From Video</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet" integrity="sha384-T8Gy5hrqNKT+hzMclPo118YTQO6cYprQmhrYwIiQ/3axmI1hQomh7Ud2hPOy8SP1" crossorigin="anonymous">
        <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
        <style>
            #videouploadinput {
                width: 40px;
                height: 40px;
                position: absolute;
                top: -8px;
                right: 21px;
                z-index: -1; 
            }
            #video {
                float: none;
                margin-top: 10px;
                min-height: 150px;
                border: solid thick aliceblue;
            }
        </style>
    </head>   
    <body>   
        <div class="container">
            <div class="panel panel-default" style="margin-top: 5%">
                <form action="" method="post">
                    <div class="panel-body">                                                               
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="name" class="control-label">Title *</label>
                                    <input type="text" class="form-control" name="title" id="title" placeholder="Video Title" required />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-9">
                                <div class="form-group">
                                    <label>Video (Click on upload icon to upload or link icon to fetch video from link)</label>
                                    <div class="pull-right">
                                        <span id="uploadingspanmsg"></span>
                                        <label class="btn-flat btn btn-sm btn-default" title="Video Link" id="videoaddlink"><i class="fa fa-link"></i></label>
                                        <label class="btn-flat btn btn-sm btn-primary" title="Upload"><i class="fa fa-upload"></i><input id="videouploadinput" type="file" accept="video/*"></label>
                                    </div>                                                
                                    <div class="" id="video" style="text-align: center;">

                                    </div>
                                    <div style="text-align: center">
                                        <a id="capturea" href="javascript:captureThumbnail()" style="display: none;">Capture Thumbnail</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <input type="hidden" name="video_link_type" id="video_link_type"/>
                                <input type="hidden" name="video_link" id="video_link"/>
                                <input type="hidden" name="video_thumbnail" id="video_thumbnail"/>
                                <div class="form-group">
                                    <label class="control-label">Video Thumbnail</label>
                                    <img id="video_thumbnail_img" src="https://placehold.it/320x180" class="img-responsive"/>
                                    <input type="text" class="form-control" name="video_duration" id="video_duration" readonly=""/>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="panel-footer">
                        <input type="submit" class="btn btn-success" id="save" name="save" value="Save"/>                                
                    </div>
                </form>
            </div>
        </div>

        <!-- REQUIRED JS SCRIPTS -->
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js" integrity="sha384-Tc5IQib027qvyjSMfHjOMaLkfuWVxZxUPnCJA7l2mCWNIpG9mGCD8wGNIcPD7Txa" crossorigin="anonymous"></script>
        <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <script>
            $("#videouploadinput").change(function (e) {
                e.preventDefault();
                var action = "requests.php?f=upload-video";
                if ($("#videouploadinput").val() === "") {
                    return;
                }
                $("#uploadingspanmsg").html("Uploading...");
                var data = new FormData();
                data.append("video", $('input[type=file]')[0].files[0]);
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data,
                    /*THIS MUST BE DONE FOR FILE UPLOADING*/
                    contentType: false,
                    processData: false,
                }).done(function (data) {
                    $("#uploadingspanmsg").html(data.msg);
                    if (data.code === '0') {
                        $("#video_link_type").val("UPLOAD");
                        $("#video_link").val(data.file_url);
                        $("#video").html('<video id="uploaded_video" controls><source src="' + data.file_url + '" type="video/mp4"></video>');
                        $("#save").attr("disabled", true);
                        var vid = document.getElementById("uploaded_video");
                        vid.onloadedmetadata = function () {
                            $("#save").attr("disabled", false);
                            var seconds = document.getElementById("uploaded_video").duration;
                            $("#video_duration").val(new Date(seconds * 1000).toISOString().substr(11, 8));
                            $("#capturea").show();
                            captureThumbnail();
                        };
                    }
                }).fail(function (data) {
                    //any message
                });

            });
            $("#videoaddlink").click(function (e) {
                var videolink = window.prompt("Please paste image link here:", "");
                if (videolink !== null && videolink !== "" && (videolink.startsWith("http://") || videolink.startsWith("https://"))) {
                    $("#video_link_type").val("LINK");
                    $("#video_link").val(videolink);
                    $("#video").html('<video id="uploaded_video" controls><source src="' + videolink + '" type="video/mp4"></video>');
                    $("#save").attr("disabled", true);
                    var vid = document.getElementById("uploaded_video");
                    vid.onloadedmetadata = function () {
                        $("#save").attr("disabled", false);
                        var seconds = document.getElementById("uploaded_video").duration;
                        $("#video_duration").val(new Date(seconds * 1000).toISOString().substr(11, 8));
                        $("#capturea").show();
                        captureThumbnail();
                    };
                }
            });

            function captureThumbnail() {
                var canvas = document.createElement('canvas');
                var video = document.getElementById('uploaded_video');
                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;

                var context = canvas.getContext('2d');
                context.drawImage(video, 0, 0, video.videoWidth, video.videoHeight);
                var imgsrc = canvas.toDataURL("image/png");
                $("#video_thumbnail_img").attr("src", imgsrc);

                var dataURL = canvas.toDataURL();
                $.ajax({
                    type: "POST",
                    url: "requests.php?f=upload-video-thumbnail-base64",
                    data: {
                        imgBase64: dataURL
                    }
                }).done(function (data) {
                    if (data.code === '0') {
                        $("#video_thumbnail").val(data.file_url);
                    }
                });
            }
        </script>
    </body>
</html>