package com.zatackcoder.clarionremotejm8201;

import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;

import android.hardware.ConsumerIrManager;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    Integer frequency = 33000;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }


    @RequiresApi(api = Build.VERSION_CODES.KITKAT)
    public void handleClick(View view) {
        ConsumerIrManager consumerIrManager = (ConsumerIrManager) getSystemService(CONSUMER_IR_SERVICE);
        if(!consumerIrManager.hasIrEmitter()) {
            Toast.makeText(getApplicationContext(), "IR Emitter Not Found in Your Device", Toast.LENGTH_LONG).show();
            return;
        }
        switch (view.getId()) {
            case R.id.powerB:
                consumerIrManager.transmit(frequency, Btn.POWER);
                break;
            case R.id.inputB:
                consumerIrManager.transmit(frequency, Btn.INPUT);
                break;
            case R.id.usbB:
                consumerIrManager.transmit(frequency, Btn.USB);
                break;
            case R.id.sdB:
                consumerIrManager.transmit(frequency, Btn.SD);
                break;
            case R.id.fmB:
                consumerIrManager.transmit(frequency, Btn.FM);
                break;
            case R.id.auxB:
                consumerIrManager.transmit(frequency, Btn.AUX);
                break;
            case R.id.trebleMinusB:
                consumerIrManager.transmit(frequency, Btn.TREBLE_MINUS);
                break;
            case R.id.treblePlusB:
                consumerIrManager.transmit(frequency, Btn.TREBLE_PLUS);
                break;
            case R.id.bassMinusB:
                consumerIrManager.transmit(frequency, Btn.BASS_MINUS);
                break;
            case R.id.bassPlusB:
                consumerIrManager.transmit(frequency, Btn.BASS_PLUS);
                break;
            case R.id.stMinusB:
                consumerIrManager.transmit(frequency, Btn.ST_MINUS);
                break;
            case R.id.stPlusB:
                consumerIrManager.transmit(frequency, Btn.ST_PLUS);
                break;
            case R.id.prevB:
                consumerIrManager.transmit(frequency, Btn.PREVIOUS);
                break;
            case R.id.volMinusB:
                consumerIrManager.transmit(frequency, Btn.VOL_MINUS);
                break;
            case R.id.nextB:
                consumerIrManager.transmit(frequency, Btn.NEXT);
                break;
            case R.id.volPlusB:
                consumerIrManager.transmit(frequency, Btn.VOL_PLUS);
                break;
            case R.id.muteB:
                consumerIrManager.transmit(frequency, Btn.MUTE);
                break;
            case R.id.ftMinusB:
                consumerIrManager.transmit(frequency, Btn.FT_MINUS);
                break;
            case R.id.ftPlusB:
                consumerIrManager.transmit(frequency, Btn.FT_PLUS);
                break;
            case R.id.num1B:
                consumerIrManager.transmit(frequency, Btn.NUM_1);
                break;
            case R.id.num2B:
                consumerIrManager.transmit(frequency, Btn.NUM_2);
                break;
            case R.id.num3B:
                consumerIrManager.transmit(frequency, Btn.NUM_3);
                break;
            case R.id.num4B:
                consumerIrManager.transmit(frequency, Btn.NUM_4);
                break;
            case R.id.num5B:
                consumerIrManager.transmit(frequency, Btn.NUM_5);
                break;
            case R.id.num6B:
                consumerIrManager.transmit(frequency, Btn.NUM_6);
                break;
            case R.id.num7B:
                consumerIrManager.transmit(frequency, Btn.NUM_7);
                break;
            case R.id.num8B:
                consumerIrManager.transmit(frequency, Btn.NUM_8);
                break;
            case R.id.num9B:
                consumerIrManager.transmit(frequency, Btn.NUM_9);
                break;
            case R.id.num0B:
                consumerIrManager.transmit(frequency, Btn.NUM_0);
                break;
            case R.id.resetB:
                consumerIrManager.transmit(frequency, Btn.RESET);
                break;
            case R.id.searchB:
                consumerIrManager.transmit(frequency, Btn.SEARCH);
                break;
        }
    }
}
