<?php include_once 'config.php'; ?>
<?php
$msg = "";
if (isset($_POST['submit'])) {
    if (!isset($_POST['token'])) {
        $msg = '<div class="alert alert-danger">Security Token Not Provided</div>';
    } else if (!isCsrfTokenValid($_POST['token'], "myform")) {
        $msg = '<div class="alert alert-danger">Security Token Invalid</div>';
    } else {
        $name = filter_var(trim($_POST['name']), FILTER_SANITIZE_STRING);
        $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
        $phone = filter_var(trim($_POST['phone']), FILTER_SANITIZE_STRING);

        //SQL Query goes here if data needs to be stored
        $msg = '<div class="alert alert-success">'
                . 'Submitted Successfully<br/>'
                . '[Name: ' . $name . ' | Email: ' . $email . ' | Phone: ' . $phone . ']'
                . '</div>';
    }
}
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>CSRF Prevention</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
    </head>
    <body>
        <div class="container" style="padding: 25px;">
            <h2 class="text-center">Contact Form</h2>
            <?= $msg ?>
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            With CSRF Token
                        </div>
                        <div class="card-body">
                            <form name="myform" method="post" action="">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control"/>
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" name="email" class="form-control"/>
                                </div>
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" name="phone" class="form-control"/>
                                </div>
                                <input type="hidden" name="token" value="<?= generateCsrfToken('myform') ?>"/>
                                <input type="submit" name="submit" value="Submit" class="btn btn-success"/>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            Without CSRF Token
                        </div>
                        <div class="card-body">
                            <form name="myform" method="post" action="">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control"/>
                                </div>
                                <div class="form-group">
                                    <label>Email</label>
                                    <input type="email" name="email" class="form-control"/>
                                </div>
                                <div class="form-group">
                                    <label>Phone</label>
                                    <input type="text" name="phone" class="form-control"/>
                                </div>
                                <input type="submit" name="submit" value="Submit" class="btn btn-success"/>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="https://code.jquery.com/jquery-3.4.1.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
    </body>
</html>
