<?php

function ipInfo($ip = NULL, $purpose = "location", $deep_detect = TRUE) {
    $output = NULL;
    if (filter_var($ip, FILTER_VALIDATE_IP) === FALSE) {
        $ip = $_SERVER["REMOTE_ADDR"];
        if ($deep_detect) {
            if (filter_var(@$_SERVER['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP))
                $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            if (filter_var(@$_SERVER['HTTP_CLIENT_IP'], FILTER_VALIDATE_IP))
                $ip = $_SERVER['HTTP_CLIENT_IP'];
        }
    }
    $purpose = str_replace(array("name", "\n", "\t", " ", "-", "_"), NULL, strtolower(trim($purpose)));
    $support = array("country", "countrycode", "state", "region", "city", "location", "address", "currencycode");
    $continents = array(
        "AF" => "Africa",
        "AN" => "Antarctica",
        "AS" => "Asia",
        "EU" => "Europe",
        "OC" => "Australia (Oceania)",
        "NA" => "North America",
        "SA" => "South America"
    );
    if (filter_var($ip, FILTER_VALIDATE_IP) && in_array($purpose, $support)) {
        $ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
        if (@strlen(trim($ipdat->geoplugin_countryCode)) == 2) {
            switch ($purpose) {
                case "location":
                    $output = array(
                        "city" => @$ipdat->geoplugin_city,
                        "state" => @$ipdat->geoplugin_regionName,
                        "country" => @$ipdat->geoplugin_countryName,
                        "country_code" => @$ipdat->geoplugin_countryCode,
                        "continent" => @$continents[strtoupper($ipdat->geoplugin_continentCode)],
                        "continent_code" => @$ipdat->geoplugin_continentCode
                    );
                    break;
                case "address":
                    $address = array($ipdat->geoplugin_countryName);
                    if (@strlen($ipdat->geoplugin_regionName) >= 1)
                        $address[] = $ipdat->geoplugin_regionName;
                    if (@strlen($ipdat->geoplugin_city) >= 1)
                        $address[] = $ipdat->geoplugin_city;
                    $output = implode(", ", array_reverse($address));
                    break;
                case "city":
                    $output = @$ipdat->geoplugin_city;
                    break;
                case "state":
                    $output = @$ipdat->geoplugin_regionName;
                    break;
                case "region":
                    $output = @$ipdat->geoplugin_regionName;
                    break;
                case "country":
                    $output = @$ipdat->geoplugin_countryName;
                    break;
                case "countrycode":
                    $output = @$ipdat->geoplugin_countryCode;
                    break;
                case "currencycode":
                    $output = @$ipdat->geoplugin_currencyCode;
                    break;
            }
        }
    }
    return $output;
}

function convert($from, $to, $amount) {
    $access_key = '2bdbac13e326ecb38bc9fecae8ac483b';//your currencylayer access_key
    $currencies = $from . "," . $to;
    $output = @json_decode(file_get_contents("http://api.currencylayer.com/live?access_key=" . $access_key . "&currencies=" . $currencies . "&format=1"), true);
    $rate = $output['quotes']['USD' . strtoupper($to)] / $output['quotes']['USD' . strtoupper($from)];
    return $rate * $amount;
}

//Usage
echo "<br/>Fixed Conversion<br/>";
echo "1 USD = " . convert("USD", "INR", 1) . " INR<br/>";
echo "1 INR = " . convert("INR", "USD", 1) . " USD<br/>";
echo "55 INR = " . convert("INR", "USD", 55) . " USD<br/>";
echo "20 GBP = " . convert("GBP", "INR", 20) . " INR<br/>";
echo "99 INR = " . convert("INR", "GBP", 99) . " GBP<br/>";

echo "<br/>Geo Location Based Conversion<br/>";
$currency_code = ipInfo(NULL, "currencycode", TRUE);
echo "199 USD = " . convert("USD", $currency_code, 199) . " " . $currency_code . "<br/>";
echo "199 INR = " . convert("INR", $currency_code, 199) . " " . $currency_code . "<br/>";
echo "199 GBP = " . convert("GBP", $currency_code, 199) . " " . $currency_code . "<br/>";

?>
