/*
 * Decompiled with CFR 0.152.
 */
package zatackcrawler;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class Crawler {
    List<Link> links = Collections.synchronizedList(new ArrayList());
    private Thread siteCrawlerThread;
    private String crawlingUrl = "";
    private boolean crawling = false;
    private boolean crawlingFirstPage = false;
    private boolean pause = false;
    private boolean crawlWithJavascript = false;
    private int sleep = 5000;
    private int maxThreadCount = 5;
    static int threadCount = 0;
    static int i = 0;

    public void crawlSite(String url, int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
        this.crawlSite(url);
    }

    public void crawlSite(final String url1) {
        if (!this.crawling) {
            this.crawling = true;
            this.siteCrawlerThread = new Thread(){

                @Override
                public void run() {
                    Crawler.this.links = Collections.synchronizedList(new ArrayList());
                    String url = url1;
                    if (!url.startsWith("http://") && !url.startsWith("https://")) {
                        url = "http://" + url;
                    }
                    url = url.substring(0, url.indexOf("/", 8) > 0 ? url.indexOf("/", 8) : url.length());
                    Crawler.this.crawlingFirstPage = true;
                    Crawler.this.crawlPage(url);
                    i = 0;
                    while (Crawler.this.crawling) {
                        if (Crawler.this.crawlingFirstPage || Crawler.this.pause || threadCount >= Crawler.this.maxThreadCount) continue;
                        if (i >= Crawler.this.links.size()) break;
                        if (Crawler.this.links.get(i).isExternal()) {
                            ++i;
                            continue;
                        }
                        if (Crawler.this.links.get(i).isVisited() || Crawler.this.links.get(i).isExternal()) continue;
                        try {
                            Thread.sleep(Crawler.this.sleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ++threadCount;
                                if (Crawler.this.links.get(i).isVisiting()) {
                                    ++i;
                                }
                                System.out.println("I m thread no. " + threadCount + " working on link no. " + i);
                                if (i < Crawler.this.links.size()) {
                                    Crawler.this.links.get(i).visiting();
                                    if (Crawler.this.crawlPage(Crawler.this.links.get(i).getUrl())) {
                                        Crawler.this.links.get(i).setVisited(true);
                                    } else {
                                        Crawler.this.links.get(i).setBroken(true);
                                    }
                                    ++i;
                                }
                                --threadCount;
                            }
                        }).start();
                    }
                    i = 0;
                    Crawler.this.crawling = false;
                }
            };
            this.siteCrawlerThread.setDaemon(true);
            this.siteCrawlerThread.start();
        } else if (this.crawling) {
            System.out.println("Already crawling");
        }
    }

    public boolean crawlPage(String url) {
        int index;
        String url1;
        String curl = url;
        if (!curl.startsWith("http://") && !curl.startsWith("https://")) {
            curl = "http://" + curl;
        }
        url1 = url1.substring(0, (index = (url1 = curl.replaceFirst("https://", "").replaceFirst("http://", "").replaceFirst("www.", "")).lastIndexOf("/")) > 0 ? index : url1.length());
        try {
            this.crawlingUrl = curl;
            Document doc = null;
            if (this.crawlWithJavascript) {
                try {
                    WebClient webClient = new WebClient();
                    HtmlPage page = (HtmlPage)webClient.getPage(curl);
                    String pageAsXml = page.asXml();
                    doc = Jsoup.parse((String)pageAsXml);
                    webClient.closeAllWindows();
                }
                catch (FailingHttpStatusCodeException | IOException ex) {
                    System.out.println(ex);
                }
            } else {
                doc = Jsoup.connect((String)curl).userAgent("mozilla/5.0").timeout(20000).get();
            }
            Elements a = doc.getElementsByTag("a");
            for (Element element : a) {
                String href1;
                String anchorText = element.text();
                String href = element.attr("href");
                if (href.startsWith("/")) {
                    href = "http://" + url1;
                }
                if (!href.contains("/")) {
                    href = "http://" + url1 + "/" + href;
                }
                href1 = href1.substring(0, (index = (href1 = href.replaceFirst("https://", "").replaceFirst("http://", "").replaceFirst("www.", "")).indexOf("/")) > 0 ? index : href1.length());
                String rel = element.attr("rel");
                Link link = new Link(curl, anchorText, href, rel, false, false);
                if (!href1.equals(url1)) {
                    link.setExternal(true);
                }
                if (this.isMediaLink(href)) {
                    link.setVisited(true);
                    link.setMedia(true);
                }
                if (this.links.contains(link)) continue;
                this.links.add(link);
            }
        }
        catch (IOException ex) {
            if (ex instanceof UnknownHostException) {
                return false;
            }
            System.out.println(ex);
        }
        this.crawlingFirstPage = false;
        return true;
    }

    public boolean isMediaLink(String url) {
        return (url = url.toLowerCase()).endsWith(".mp3") || url.endsWith(".mp4") || url.endsWith(".mkv") || url.endsWith(".jpg") || url.endsWith(".jpeg") || url.endsWith(".gif") || url.endsWith(".png") || url.endsWith(".pdf") || url.endsWith(".txt") || url.endsWith(".doc") || url.endsWith(".docx");
    }

    public void pause() {
        this.pause = true;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void resume() {
        this.pause = false;
    }

    public void stop() {
        this.crawling = false;
    }

    public boolean isCrawling() {
        return this.crawling;
    }

    public String runningThreadCount() {
        if (threadCount < 10) {
            return "0" + (threadCount > this.maxThreadCount ? this.maxThreadCount : threadCount);
        }
        return "" + (threadCount > this.maxThreadCount ? this.maxThreadCount : threadCount);
    }

    public void setCrawlWithJavascript(boolean crawlWithJavascript) {
        this.crawlWithJavascript = crawlWithJavascript;
    }

    public void setSleepTime(int sleep) {
        this.sleep = sleep;
    }

    public void setMaxThreadCount(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount > 25 ? 25 : maxThreadCount;
    }

    public String getCrawlingUrl() {
        return this.crawlingUrl;
    }

    public void addLink(String url) {
        Link link = new Link("NA", "NA", url, "NA", true, false);
        if (!this.links.contains(link)) {
            this.links.add(link);
        }
    }

    public void addLink(Link link) {
        if (!this.links.contains(link)) {
            this.links.add(link);
        }
    }

    public List<Link> getLinks() {
        if (this.crawling) {
            try {
                System.out.println("waiting...");
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                System.out.println(ex);
            }
            this.getLinks();
        }
        return this.links;
    }

    public boolean clear() {
        this.links.clear();
        return true;
    }

    public Document getDocument(String html) {
        return Jsoup.parse((String)html);
    }

    public void parse(Link link) {
        if (!link.isParsed()) {
            try {
                Document doc = Jsoup.connect((String)link.getUrl()).userAgent("mozilla/5.0").timeout(20000).get();
                link.setHtml(doc.html());
                link.setParsed(true);
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
    }

    public static String getTitleMeta(String html) {
        String titleMeta = "";
        Document doc = Jsoup.parse((String)html);
        titleMeta = "Title: " + (doc.title().equals("") ? "Empty" : doc.title()) + "\nMeta Keyword: " + (doc.select("meta[name=keywords]").first() == null ? "Empty" : doc.select("meta[name=keywords]").first().attr("content")) + "\nMeta Description: " + (doc.select("meta[name=description]").first() == null ? "Empty" : doc.select("meta[name=description]").first().attr("content"));
        return titleMeta;
    }

    public String getTags(Link link) {
        if (!link.isParsed()) {
            return link.getHtml();
        }
        Document doc = Jsoup.parse((String)link.getHtml());
        String tagTableHtml = "<table border=1><tr style='text-align:left; background-color: silver;'><th>Tag</th><th>Content   </th><th>Length</th></tr>";
        tagTableHtml = tagTableHtml + "<tr><td>Url</td><td>" + link.getUrl() + "</td><td>" + link.getUrl().length() + "</td></tr>";
        tagTableHtml = tagTableHtml + "<tr><td>Title</td><td>" + (doc.title().equals("") ? "Empty" : doc.title()) + "</td><td>" + doc.title().length() + "</td></tr>";
        tagTableHtml = tagTableHtml + "<tr><td>Meta Keyword</td><td>" + (doc.select("meta[name=keywords]").first() == null ? "Empty</td><td>0</td></tr>" : doc.select("meta[name=keywords]").first().attr("content") + "</td><td>" + doc.select("meta[name=keywords]").first().attr("content").length() + "</td></tr>");
        tagTableHtml = tagTableHtml + "<tr><td>Meta Description</td><td>" + (doc.select("meta[name=description]").first() == null ? "Empty</td><td>0</td></tr>" : doc.select("meta[name=description]").first().attr("content") + "</td><td>" + doc.select("meta[name=description]").first().attr("content").length() + "</td></tr>");
        tagTableHtml = tagTableHtml + "<tr><td>Meta Robots</td><td>" + (doc.select("meta[name=robots]").first() == null ? "Empty</td><td>0</td></tr>" : doc.select("meta[name=robots]").first().attr("content") + "</td><td>" + doc.select("meta[name=robots]").first().attr("content").length() + "</td></tr>");
        String h1s = this.getTagsValue(doc, "h1");
        tagTableHtml = tagTableHtml + "<tr><td>H1</td><td>" + (h1s.isEmpty() ? "Empty" : h1s) + "</td><td>" + h1s.replaceAll("|", "").length() + "</td></tr>";
        String h2s = this.getTagsValue(doc, "h2");
        tagTableHtml = tagTableHtml + "<tr><td>H2</td><td>" + (h2s.isEmpty() ? "Empty" : h2s) + "</td><td>" + h2s.replaceAll("|", "").length() + "</td></tr>";
        String bs = this.getTagsValue(doc, "b, strong");
        tagTableHtml = tagTableHtml + "<tr><td>Bold/Strong</td><td>" + bs + "</td><td>" + bs.replaceAll("|", "").length() + "</td></tr>";
        String is = this.getTagsValue(doc, "i");
        tagTableHtml = tagTableHtml + "<tr><td>Italic/Em</td><td>" + is + "</td><td>" + is.replaceAll("|", "").length() + "</td></tr>";
        Elements elements = doc.getAllElements();
        String alts = "";
        for (Element element : elements) {
            alts = alts + element.attr("alt") + " | ";
        }
        if (alts.length() > 0) {
            alts = alts.substring(0, alts.lastIndexOf(" | "));
        }
        tagTableHtml = tagTableHtml + "<tr><td>Alt Text</td><td>" + alts + "</td><td>" + alts.replaceAll("|", "").length() + "</td></tr>";
        tagTableHtml = tagTableHtml + "<tr><td>Body Text</td><td>" + doc.text().substring(0, doc.text().length() < 2000 ? doc.text().length() : 2000) + "...</td><td>" + doc.text().length() + "</td></tr>";
        tagTableHtml = tagTableHtml + "</table>";
        return tagTableHtml;
    }

    public String getTagsValue(Document doc, String tag) {
        Elements elements = doc.select(tag);
        String tags = "";
        for (Element element : elements) {
            tags = tags + element.text() + " | ";
        }
        if (tags.length() == 0) {
            return tags;
        }
        return tags.substring(0, tags.lastIndexOf(" | "));
    }

    public static String getTagValue(String html, String selector, boolean innerHtml) {
        String value = "";
        Document doc = Jsoup.parse((String)html);
        Elements elements = doc.select(selector);
        for (Element element : elements) {
            if (innerHtml) {
                value = value + element.html() + "\n";
                continue;
            }
            value = value + element.text() + "\n";
        }
        return value;
    }

    public static String getTagAttribute(String html, String selector, String attr, boolean commaSeparated) {
        String attribute = "";
        Document doc = Jsoup.parse((String)html);
        Elements elements = doc.select(selector);
        for (Element element : elements) {
            if (attr.trim().equals("html")) {
                attribute = attribute + element.html() + (commaSeparated ? ", " : "\n");
                continue;
            }
            if (attr.trim().equals("text")) {
                attribute = attribute + element.text() + (commaSeparated ? ", " : "\n");
                continue;
            }
            attribute = attribute + element.attr(attr.trim()) + (commaSeparated ? ", " : "\n");
        }
        if (commaSeparated && attribute.contains(",")) {
            StringBuilder strbfr = new StringBuilder(attribute);
            strbfr.setCharAt(strbfr.lastIndexOf(","), '\n');
            attribute = strbfr.toString();
        }
        return attribute;
    }

    public static String getTagAttributes(String html, String selector, String[] attrs) {
        String attributes = "";
        Document doc = Jsoup.parse((String)html);
        Elements elements = doc.select(selector);
        for (Element element : elements) {
            for (String attr : attrs) {
                attributes = attr.trim().equals("html") ? attributes + element.html() + "," : (attr.trim().equals("text") ? attributes + element.text() + "," : attributes + element.attr(attr.trim()) + ",");
            }
            StringBuilder strbfr = new StringBuilder(attributes);
            strbfr.setCharAt(strbfr.lastIndexOf(","), '\n');
            attributes = strbfr.toString();
        }
        return attributes;
    }

    public ArrayList<String> getImageUrls(Link link) {
        Document doc;
        if (link.isParsed()) {
            doc = Jsoup.parse((String)link.getHtml());
        } else {
            try {
                doc = Jsoup.connect((String)link.getUrl()).userAgent("mozilla/5.0").timeout(20000).get();
                link.setHtml(doc.html());
                link.setParsed(true);
            }
            catch (IOException ex) {
                System.out.println(ex);
                doc = Jsoup.parse((String)"");
            }
        }
        ArrayList<String> imageUrls = new ArrayList<String>();
        Elements elements = doc.getElementsByTag("img");
        for (Element element : elements) {
            imageUrls.add(element.attr("src"));
        }
        return imageUrls;
    }

    public ArrayList<String> getAudioUrls(Link link) {
        Document doc;
        if (link.isParsed()) {
            doc = Jsoup.parse((String)link.getHtml());
        } else {
            try {
                doc = Jsoup.connect((String)link.getUrl()).userAgent("mozilla/5.0").timeout(20000).get();
                link.setHtml(doc.html());
                link.setParsed(true);
            }
            catch (IOException ex) {
                System.out.println(ex);
                doc = Jsoup.parse((String)"");
            }
        }
        ArrayList<String> audioUrls = new ArrayList<String>();
        Elements elements = doc.select("a[href$=.mp3]");
        for (Element element : elements) {
            audioUrls.add(element.attr("href"));
        }
        return audioUrls;
    }

    public ArrayList<String> getVideoUrls(Link link) {
        Document doc;
        if (link.isParsed()) {
            doc = Jsoup.parse((String)link.getHtml());
        } else {
            try {
                doc = Jsoup.connect((String)link.getUrl()).userAgent("mozilla/5.0").timeout(20000).get();
                link.setHtml(doc.html());
                link.setParsed(true);
            }
            catch (IOException ex) {
                System.out.println(ex);
                doc = Jsoup.parse((String)"");
            }
        }
        ArrayList<String> videoUrls = new ArrayList<String>();
        Elements elements = doc.select("a[href$=.mp4]");
        for (Element element : elements) {
            videoUrls.add(element.attr("href"));
        }
        return videoUrls;
    }

    public ArrayList<String> getStylesheetUrls(Link link) {
        Document doc;
        if (link.isParsed()) {
            doc = Jsoup.parse((String)link.getHtml());
        } else {
            try {
                doc = Jsoup.connect((String)link.getUrl()).userAgent("mozilla/5.0").timeout(20000).get();
                link.setParsed(true);
            }
            catch (IOException ex) {
                System.out.println(ex);
                doc = Jsoup.parse((String)"");
            }
        }
        ArrayList<String> stylesheetUrls = new ArrayList<String>();
        Elements elements = doc.getElementsByTag("link");
        for (Element element : elements) {
            if (!element.attr("rel").equalsIgnoreCase("stylesheet")) continue;
            stylesheetUrls.add(element.attr("href"));
        }
        return stylesheetUrls;
    }

    public static boolean saveFile(String source, String destination) {
        try {
            int length;
            String filename = source.substring(source.lastIndexOf("/") + 1);
            destination = destination.endsWith("/") ? destination + filename : destination + "/" + filename;
            URL url = new URL(source);
            InputStream is = url.openStream();
            FileOutputStream os = new FileOutputStream(destination);
            byte[] b = new byte[2048];
            while ((length = is.read(b)) != -1) {
                ((OutputStream)os).write(b, 0, length);
            }
            is.close();
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static class Link {
        String html;
        boolean parsed;
        String source;
        String anchorText;
        String url;
        String linkType;
        boolean external;
        boolean visiting;
        boolean visited;
        boolean broken;
        boolean media;

        public Link(String source, String anchorText, String url, String linkType, boolean external, boolean visited) {
            this.source = source;
            this.anchorText = anchorText;
            this.url = url;
            this.linkType = linkType;
            this.external = external;
            this.visited = visited;
            this.html = "Not Parsed";
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getAnchorText() {
            return this.anchorText;
        }

        public void setAnchorText(String anchorText) {
            this.anchorText = anchorText;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getLinkType() {
            return this.linkType;
        }

        public void setLinkType(String linkType) {
            this.linkType = linkType;
        }

        public boolean isExternal() {
            return this.external;
        }

        public void setExternal(boolean external) {
            this.external = external;
        }

        public boolean isVisiting() {
            return this.visiting;
        }

        public void visiting() {
            this.visiting = true;
        }

        public boolean isVisited() {
            return this.visited;
        }

        public void setVisited(boolean visited) {
            this.visited = visited;
            this.visiting = false;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public void setBroken(boolean broken) {
            this.broken = broken;
        }

        public boolean isMedia() {
            return this.media;
        }

        public void setMedia(boolean media) {
            this.media = media;
        }

        public String getHtml() {
            return this.html;
        }

        public void setHtml(String html) {
            this.html = html;
        }

        public void setParsed(boolean parsed) {
            this.parsed = parsed;
        }

        public boolean isParsed() {
            return this.parsed;
        }

        public String getFileName() {
            String fileName = "index.html";
            String[] parts = this.url.split("/");
            if (!parts[parts.length - 1].isEmpty()) {
                fileName = parts[parts.length - 1];
            }
            return fileName;
        }

        public boolean equals(Object obj) {
            if (obj == null || this == obj) {
                return true;
            }
            if (obj instanceof Link) {
                Link castedObj = (Link)obj;
                if (this.url.replaceFirst("https://", "").replaceFirst("http://", "").replaceFirst("www.", "").equals(castedObj.getUrl().replaceFirst("https://", "").replaceFirst("http://", "").replaceFirst("www.", ""))) {
                    return true;
                }
            }
            return false;
        }
    }
}

