/*
 * Decompiled with CFR 0.152.
 */
package zatackcrawler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Slider;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import zatackcrawler.Crawler;

public class CrawlerUIController
implements Initializable {
    Crawler crawler;
    int sleep;
    Thread longTaskExecuter;
    boolean busy = false;
    @FXML
    TableView<Crawler.Link> linksTV;
    @FXML
    TextField queryTF;
    @FXML
    TextField browserUrlTF;
    @FXML
    TextField filterTF;
    @FXML
    TextField findTF;
    @FXML
    TextField replaceTF;
    @FXML
    CheckBox crawlWholeSiteCB;
    @FXML
    CheckBox innerHtmlCB;
    @FXML
    CheckBox showOnlyValueCB;
    @FXML
    CheckBox commaSeparatedCB;
    @FXML
    CheckBox withJSCB;
    @FXML
    Button pauseB;
    @FXML
    TabPane outputContainerTB;
    @FXML
    Hyperlink imagesDownloadH;
    @FXML
    Hyperlink audioDownloadH;
    @FXML
    Hyperlink videoDownloadH;
    @FXML
    Hyperlink cssDownloadH;
    @FXML
    Button filterB;
    @FXML
    Button replaceB;
    @FXML
    Slider maxThreadS;
    @FXML
    Slider pauseTimeS;
    @FXML
    ProgressBar crawlerPB;
    @FXML
    ProgressIndicator browserPI;
    @FXML
    Label maxThreadL;
    @FXML
    Label sleepL;
    @FXML
    Label statusL;
    @FXML
    Label threadCountL;
    @FXML
    Label browserStatusL;
    @FXML
    WebView browserWV;
    @FXML
    ImageView browserStopReloadIV;
    @FXML
    TextArea selectorTA;
    @FXML
    TextArea sourceTA;
    @FXML
    TextArea urlsOrHtmlTA;
    @FXML
    VBox queryContainer;

    public void initialize(URL url, ResourceBundle rb) {
        this.initializeLinksTable();
        this.initializeSlider();
        this.initializeOtherControls();
        this.crawler = new Crawler();
    }

    private void initializeSlider() {
        this.maxThreadS.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                CrawlerUIController.this.maxThreadL.setText("Max Threads: " + (int)CrawlerUIController.this.maxThreadS.getValue() + ",");
                CrawlerUIController.this.crawler.setMaxThreadCount((int)CrawlerUIController.this.maxThreadS.getValue());
            }
        });
        this.pauseTimeS.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                CrawlerUIController.this.sleepL.setText("Sleep Time: " + (int)CrawlerUIController.this.pauseTimeS.getValue() + "ms");
                CrawlerUIController.this.crawler.setSleepTime((int)CrawlerUIController.this.pauseTimeS.getValue());
            }
        });
    }

    private void initializeLinksTable() {
        TableColumn sourceCol = new TableColumn("Source");
        sourceCol.setMinWidth(65.0);
        sourceCol.setCellValueFactory((Callback)new PropertyValueFactory("source"));
        TableColumn urlCol = new TableColumn("Url");
        urlCol.setMinWidth(57.0);
        urlCol.setCellValueFactory((Callback)new PropertyValueFactory("url"));
        TableColumn anchorTextCol = new TableColumn("Anchor Text");
        anchorTextCol.setMinWidth(75.0);
        anchorTextCol.setCellValueFactory((Callback)new PropertyValueFactory("anchorText"));
        TableColumn linkTypeCol = new TableColumn("Link Type");
        linkTypeCol.setMinWidth(60.0);
        linkTypeCol.setCellValueFactory((Callback)new PropertyValueFactory("linkType"));
        TableColumn externalCol = new TableColumn("External");
        externalCol.setMinWidth(50.0);
        externalCol.setCellValueFactory((Callback)new PropertyValueFactory("external"));
        TableColumn visitedCol = new TableColumn("Visited");
        visitedCol.setMinWidth(45.0);
        visitedCol.setCellValueFactory((Callback)new PropertyValueFactory("visited"));
        TableColumn brokenCol = new TableColumn("Broken");
        brokenCol.setMinWidth(45.0);
        brokenCol.setCellValueFactory((Callback)new PropertyValueFactory("broken"));
        TableColumn mediaCol = new TableColumn("Media");
        mediaCol.setMinWidth(45.0);
        mediaCol.setCellValueFactory((Callback)new PropertyValueFactory("media"));
        TableColumn parsedCol = new TableColumn("Parsed");
        mediaCol.setMinWidth(45.0);
        mediaCol.setCellValueFactory((Callback)new PropertyValueFactory("parsed"));
        this.linksTV.getColumns().clear();
        this.linksTV.getColumns().addAll((Object[])new TableColumn[]{sourceCol, urlCol, anchorTextCol, linkTypeCol, externalCol, visitedCol, brokenCol, mediaCol, parsedCol});
        this.linksTV.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.linksTV.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue ov, Object t, Object t1) {
                Crawler.Link link = (Crawler.Link)CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItem();
                if (link != null && link.isParsed()) {
                    CrawlerUIController.this.statusL.setText("Parsed");
                    if (CrawlerUIController.this.crawler != null && !CrawlerUIController.this.crawler.isCrawling()) {
                        CrawlerUIController.this.imagesDownloadH.setText(CrawlerUIController.this.crawler.getImageUrls(link).size() + " IMAGES");
                        CrawlerUIController.this.cssDownloadH.setText(CrawlerUIController.this.crawler.getStylesheetUrls(link).size() + " CSS");
                        CrawlerUIController.this.audioDownloadH.setText(CrawlerUIController.this.crawler.getAudioUrls(link).size() + " AUDIO");
                        CrawlerUIController.this.videoDownloadH.setText(CrawlerUIController.this.crawler.getVideoUrls(link).size() + " VIDEO");
                    } else {
                        JOptionPane.showMessageDialog(null, "Crawler not yet started or crawling!");
                    }
                } else {
                    CrawlerUIController.this.statusL.setText("Not Parsed");
                }
            }
        });
    }

    private void initializeOtherControls() {
        this.browserWV.getEngine().setJavaScriptEnabled(true);
        this.browserWV.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                CrawlerUIController.this.browserStatusL.setText("loading... " + CrawlerUIController.this.browserWV.getEngine().getLocation());
                CrawlerUIController.this.browserStopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/stoploading.png")));
                CrawlerUIController.this.browserPI.setVisible(true);
                if (newValue == Worker.State.SUCCEEDED) {
                    CrawlerUIController.this.browserUrlTF.setText(CrawlerUIController.this.browserWV.getEngine().getLocation());
                    CrawlerUIController.this.browserStatusL.setText("loaded");
                    CrawlerUIController.this.browserPI.setVisible(false);
                    CrawlerUIController.this.browserStopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/reload.png")));
                }
            }
        });
    }

    @FXML
    private void addToListButtonAction(ActionEvent event) {
        if (!this.urlsOrHtmlTA.getText().isEmpty()) {
            if (this.urlsOrHtmlTA.getText().contains("<") || this.urlsOrHtmlTA.getText().contains(">")) {
                JOptionPane.showMessageDialog(null, "Please enter valid urls");
                return;
            }
            for (String l : this.urlsOrHtmlTA.getText().split("\n")) {
                this.crawler.addLink(l);
            }
            this.linksTV.setItems(FXCollections.observableList(this.crawler.getLinks()));
            this.urlsOrHtmlTA.setText("");
        } else {
            JOptionPane.showMessageDialog(null, "Please enter urls");
        }
    }

    @FXML
    private void addHtmlToListButtonAction(ActionEvent event) {
        if (!this.urlsOrHtmlTA.getText().isEmpty()) {
            String html = this.urlsOrHtmlTA.getText();
            Crawler.Link link = new Crawler.Link("NA", "NA", "NA", "NA", true, true);
            link.setHtml(html);
            link.setParsed(true);
            this.crawler.addLink(link);
            this.linksTV.setItems(FXCollections.observableList(this.crawler.getLinks()));
            this.urlsOrHtmlTA.setText("");
        } else {
            JOptionPane.showMessageDialog(null, "Please enter html");
        }
    }

    @FXML
    private void crawlButtonAction(ActionEvent event) {
        this.crawler.setSleepTime((int)this.pauseTimeS.getValue());
        this.crawler.setMaxThreadCount((int)this.maxThreadS.getValue());
        this.crawler.setCrawlWithJavascript(this.withJSCB.isSelected());
        if (this.crawlWholeSiteCB.isSelected()) {
            if (!this.urlsOrHtmlTA.getText().isEmpty() && !this.busy) {
                if (this.urlsOrHtmlTA.getText().split("\n").length > 1) {
                    JOptionPane.showMessageDialog(null, "Only first url will be crawled");
                }
                this.crawler.crawlSite(this.urlsOrHtmlTA.getText().split("\n")[0]);
                new Thread(){

                    @Override
                    public void run() {
                        if (CrawlerUIController.this.crawler != null) {
                            CrawlerUIController.this.busy = true;
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.crawlerPB.setProgress(-1.0);
                                }
                            });
                            while (CrawlerUIController.this.crawler.isCrawling()) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (CrawlerUIController.this.crawler.isPause()) {
                                            CrawlerUIController.this.statusL.setText("Pause");
                                        } else {
                                            CrawlerUIController.this.statusL.setText("Crawling... " + CrawlerUIController.this.crawler.getCrawlingUrl());
                                            CrawlerUIController.this.threadCountL.setText(CrawlerUIController.this.crawler.runningThreadCount());
                                        }
                                    }
                                });
                            }
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Crawling Done");
                                    CrawlerUIController.this.crawlerPB.setProgress(1.0);
                                }
                            });
                            CrawlerUIController.this.busy = false;
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(null, "Please enter url!");
            }
        } else if (!this.urlsOrHtmlTA.getText().equals("") && !this.busy) {
            final String[] urls = this.urlsOrHtmlTA.getText().split("\n");
            new Thread(){

                @Override
                public void run() {
                    CrawlerUIController.this.busy = true;
                    for (final String url : urls) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText("Crawling " + url);
                            }
                        });
                        CrawlerUIController.this.crawler.crawlPage(url);
                    }
                    CrawlerUIController.this.busy = false;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Crawling Done");
                        }
                    });
                }
            }.start();
        } else {
            JOptionPane.showMessageDialog(null, "Multiple url text area is empty or System is busy");
        }
    }

    @FXML
    private void pauseButtonAction(ActionEvent event) {
        if (this.crawler != null && this.crawler.isCrawling()) {
            if (this.crawler.isPause()) {
                this.crawler.resume();
                this.pauseB.setText("Pause");
            } else {
                this.crawler.pause();
                this.pauseB.setText("Resume");
            }
        }
    }

    @FXML
    private void stopButtonAction(ActionEvent event) {
        if (this.crawler != null) {
            this.crawler.resume();
            this.pauseB.setText("Pause");
            this.crawler.stop();
        }
    }

    @FXML
    private void showButtonAction(ActionEvent event) {
        if (this.crawler != null && !this.crawler.isCrawling()) {
            this.linksTV.setItems(FXCollections.observableList(this.crawler.getLinks()));
        } else {
            JOptionPane.showMessageDialog(null, "Crawler is running or not started yet");
        }
    }

    @FXML
    private void saveButtonAction(ActionEvent event) {
        if (this.crawler != null && !this.crawler.isCrawling()) {
            FileChooser fileChooser = new FileChooser();
            File file = fileChooser.showSaveDialog(null);
            if (file != null) {
                PrintStream ps;
                try {
                    ps = new PrintStream(file);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "There is some problem while writing to file");
                    return;
                }
                List<Crawler.Link> links = this.crawler.getLinks();
                ps.println("<table border=\"1\">");
                ps.println("<tr><th>Source</th><th>Url</th><th>Anchor Text</th><th>Link Type</th><th>External</th><th>Visited</th><th>Broken</th><th>Media</th></tr>");
                for (int i = 0; i < links.size(); ++i) {
                    ps.println("<tr><td>" + links.get(i).getSource() + "</td><td>" + links.get(i).getUrl() + "</td><td>" + links.get(i).getAnchorText() + "</td><td>" + links.get(i).getLinkType() + "</td><td>" + links.get(i).isExternal() + "</td><td>" + links.get(i).isVisited() + "</td><td>" + links.get(i).isBroken() + "</td><td>" + links.get(i).isMedia() + "</td></tr>\n");
                }
                ps.println("</table>");
                ps.close();
                JOptionPane.showMessageDialog(null, "Files Saved!");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Crawler is running or not started yet");
        }
    }

    @FXML
    private void clearButtonAction(ActionEvent event) {
        if (this.crawler != null && !this.crawler.isCrawling()) {
            this.crawler.clear();
            this.linksTV.setItems(FXCollections.observableArrayList(this.crawler.getLinks()));
        } else {
            JOptionPane.showMessageDialog(null, "Crawler is running!");
        }
    }

    @FXML
    private void parseSelectedButtonAction(ActionEvent event) {
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    for (final Crawler.Link link : links) {
                        if (!link.isParsed() && !link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Parsed");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "Already processing");
        }
    }

    @FXML
    private void titleMetaButtonAction(ActionEvent event) {
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.sourceTA.setText("");
                        }
                    });
                    for (final Crawler.Link link : links) {
                        if (link.isParsed()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Fetching title meta of " + link.getUrl());
                                    CrawlerUIController.this.sourceTA.appendText(Crawler.getTitleMeta(link.getHtml()) + "\n");
                                }
                            });
                            continue;
                        }
                        if (!link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Fetching title meta of " + link.getUrl());
                                    CrawlerUIController.this.sourceTA.appendText(Crawler.getTitleMeta(link.getHtml()) + "\n");
                                }
                            });
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("See result in query tab");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                            CrawlerUIController.this.outputContainerTB.getSelectionModel().select(1);
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "Already processing");
        }
    }

    @FXML
    private void saveSourceButtonAction(ActionEvent event) {
        if (this.crawler != null && !this.crawler.isCrawling()) {
            ObservableList links = this.linksTV.getSelectionModel().getSelectedItems();
            final JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Select Directory");
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showSaveDialog(null) == 0) {
                new Thread((List)links){
                    final /* synthetic */ List val$links;
                    {
                        this.val$links = list;
                    }

                    @Override
                    public void run() {
                        File file = jFileChooser.getSelectedFile();
                        try {
                            for (int i = 0; i < this.val$links.size(); ++i) {
                                final Crawler.Link tmplink = (Crawler.Link)this.val$links.get(i);
                                final String fileName = file.getAbsolutePath() + "/" + tmplink.getFileName();
                                if (!tmplink.isParsed()) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            CrawlerUIController.this.statusL.setText("Parsing " + tmplink.getUrl());
                                        }
                                    });
                                    CrawlerUIController.this.crawler.parse(tmplink);
                                }
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        CrawlerUIController.this.statusL.setText("Saving " + fileName);
                                    }
                                });
                                PrintStream ps = new PrintStream(fileName);
                                ps.print(((Crawler.Link)this.val$links.get(i)).getHtml());
                                ps.close();
                            }
                        }
                        catch (FileNotFoundException ex) {
                            JOptionPane.showMessageDialog(null, "There is some problem while writing to file");
                            return;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText("Files Saved!");
                                JOptionPane.showMessageDialog(null, "Files Saved!");
                            }
                        });
                    }
                }.start();
            }
        } else {
            JOptionPane.showMessageDialog(null, "Crawler is running or not started yet");
        }
    }

    @FXML
    private void selectButtonAction(ActionEvent event) {
        if (this.selectorTA.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, "Selector area field cannot be blank");
            return;
        }
        if (this.linksTV.getSelectionModel().getSelectedItems().size() <= 0) {
            JOptionPane.showMessageDialog(null, "Please select url from table");
            return;
        }
        final String[] selectors = this.selectorTA.getText().trim().split("\n");
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.sourceTA.setText("");
                        }
                    });
                    for (final Crawler.Link link : links) {
                        if (link.isParsed()) {
                            CrawlerUIController.this.runSelectorThread(link, selectors);
                            continue;
                        }
                        if (!link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            CrawlerUIController.this.runSelectorThread(link, selectors);
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("See result in Source Tab");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                            CrawlerUIController.this.outputContainerTB.getSelectionModel().select(1);
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    private void runSelectorThread(final Crawler.Link link, final String[] selectors) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CrawlerUIController.this.statusL.setText("Fetching data from " + link.getUrl());
                if (!CrawlerUIController.this.showOnlyValueCB.isSelected()) {
                    CrawlerUIController.this.sourceTA.appendText("==========================================\n");
                    CrawlerUIController.this.sourceTA.appendText(link.getUrl() + "\n");
                    CrawlerUIController.this.sourceTA.appendText("==========================================\n");
                }
                for (String selector : selectors) {
                    if (selector.contains("=>")) {
                        selector = selector.split(Pattern.quote("=>"))[0];
                    }
                    if (selector.trim().contains("||") && selector.trim().lastIndexOf("||") < selector.length() - 1) {
                        String[] tmps = selector.trim().split(Pattern.quote("||"));
                        String tmpSelector = tmps[0];
                        String attribute = tmps[1];
                        if (attribute.contains(",")) {
                            CrawlerUIController.this.sourceTA.appendText(Crawler.getTagAttributes(link.getHtml(), tmpSelector, attribute.split(",")) + (CrawlerUIController.this.showOnlyValueCB.isSelected() ? "" : "\n"));
                            continue;
                        }
                        CrawlerUIController.this.sourceTA.appendText(Crawler.getTagAttribute(link.getHtml(), tmpSelector, attribute.trim(), CrawlerUIController.this.commaSeparatedCB.isSelected()) + (CrawlerUIController.this.showOnlyValueCB.isSelected() ? "" : "\n"));
                        continue;
                    }
                    CrawlerUIController.this.sourceTA.appendText(Crawler.getTagValue(link.getHtml(), selector.trim(), CrawlerUIController.this.innerHtmlCB.isSelected()) + (CrawlerUIController.this.showOnlyValueCB.isSelected() ? "" : "\n"));
                }
            }
        });
    }

    @FXML
    private void fillButtonAction(ActionEvent event) {
        if (this.selectorTA.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, "Selector area field cannot be blank");
            return;
        }
        if (this.linksTV.getSelectionModel().getSelectedItems().size() <= 0) {
            JOptionPane.showMessageDialog(null, "Please select url from table");
            return;
        }
        final String[] selectorsAndFillers = this.selectorTA.getText().trim().split("\n");
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    final Crawler.Link link = (Crawler.Link)CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItem();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.sourceTA.setText("");
                        }
                    });
                    if (link.isParsed()) {
                        CrawlerUIController.this.runFillerThread(link, selectorsAndFillers);
                    } else if (!link.isMedia()) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                            }
                        });
                        CrawlerUIController.this.crawler.parse(link);
                        CrawlerUIController.this.runFillerThread(link, selectorsAndFillers);
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("See result in Source Tab");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                            CrawlerUIController.this.outputContainerTB.getSelectionModel().select(0);
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    private void runFillerThread(final Crawler.Link link, final String[] selectorsAndFillers) {
        for (String tmp : selectorsAndFillers) {
            if (tmp.contains("=>")) continue;
            JOptionPane.showMessageDialog(null, "Use => for separting filling field selector");
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CrawlerUIController.this.statusL.setText("Fetching data from " + link.getUrl());
                for (String selectorAndFiller : selectorsAndFillers) {
                    String selector = selectorAndFiller.split(Pattern.quote("=>"))[0];
                    String filler = selectorAndFiller.split(Pattern.quote("=>"))[1];
                    if (!selector.trim().contains("||") || selector.trim().lastIndexOf("||") >= selector.length() - 1) continue;
                    String tmpSelector = selector.trim().split(Pattern.quote("||"))[0];
                    String attribute = selector.trim().split(Pattern.quote("||"))[1];
                    String fillerTag = filler.trim().split(Pattern.quote("["))[0];
                    String fillerName = filler.trim().split(Pattern.quote("["))[1];
                    String value = Crawler.getTagAttribute(link.getHtml(), tmpSelector, attribute.trim(), true);
                    CrawlerUIController.this.fillBrowserForm(fillerTag, fillerName, value.trim());
                }
            }
        });
    }

    @FXML
    private void saveCsvButtonAction(ActionEvent event) {
        if (this.selectorTA.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, "Selector area field cannot be blank");
            return;
        }
        if (this.linksTV.getSelectionModel().getSelectedItems().size() <= 0) {
            JOptionPane.showMessageDialog(null, "Please select url from table");
            return;
        }
        final String[] selectorsAndFillers = this.selectorTA.getText().trim().split("\n");
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    final ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Please wait saving...");
                            CrawlerUIController.this.runCsvSaveThread((ObservableList<Crawler.Link>)links, selectorsAndFillers, new FileChooser().showSaveDialog(null));
                            JOptionPane.showMessageDialog(null, "Saved successfully!");
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    private void runCsvSaveThread(final ObservableList<Crawler.Link> links, final String[] selectorsAndColumns, final File file) {
        for (String tmp : selectorsAndColumns) {
            if (tmp.contains("=>")) continue;
            JOptionPane.showMessageDialog(null, "Use => for separting column name");
            return;
        }
        if (file == null) {
            JOptionPane.showMessageDialog(null, "Please select file");
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try (PrintStream ps = new PrintStream(file);){
                    StringBuffer line = new StringBuffer("");
                    for (String selectorAndFiller : selectorsAndColumns) {
                        String column = selectorAndFiller.split(Pattern.quote("=>"))[1];
                        line = line.append("\"").append(column.trim()).append("\",");
                    }
                    line.setCharAt(line.lastIndexOf(","), '\n');
                    ps.print(line.toString());
                    for (Crawler.Link link : links) {
                        if (link.isMedia()) continue;
                        if (!link.isParsed()) {
                            CrawlerUIController.this.crawler.parse(link);
                        }
                        line = new StringBuffer("");
                        for (String selectorAndFiller : selectorsAndColumns) {
                            String selector = selectorAndFiller.split(Pattern.quote("=>"))[0];
                            if (!selector.trim().contains("||") || selector.trim().lastIndexOf("||") >= selector.length() - 1) continue;
                            String tmpSelector = selector.trim().split(Pattern.quote("||"))[0];
                            String attribute = selector.trim().split(Pattern.quote("||"))[1];
                            String value = Crawler.getTagAttribute(link.getHtml(), tmpSelector, attribute.trim(), true);
                            line = line.append("\"").append(value.trim()).append("\",");
                        }
                        line.setCharAt(line.lastIndexOf(","), '\n');
                        ps.print(line.toString());
                    }
                    ps.close();
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "File not found");
                }
            }
        });
    }

    private void fillBrowserForm(String tag, String name, String value) {
        if (tag.toLowerCase().equals("input") || !tag.toLowerCase().equals("textarea")) {
            this.browserWV.getEngine().executeScript("document.getElementsByName('" + name + "')[0].value='" + value + "';");
        }
        if (tag.toLowerCase().equals("textarea")) {
            this.browserWV.getEngine().executeScript("document.getElementsByName('" + name + "')[0].innerHTML='" + value + "';");
        }
    }

    @FXML
    private void browserBackButtonAction(ActionEvent event) {
        if (this.browserWV.getEngine().getHistory().getCurrentIndex() <= 0) {
            return;
        }
        this.browserWV.getEngine().getHistory().go(-1);
    }

    @FXML
    private void browserForwardButtonAction(ActionEvent event) {
        if (this.browserWV.getEngine().getHistory().getCurrentIndex() + 1 >= this.browserWV.getEngine().getHistory().getEntries().size()) {
            return;
        }
        this.browserWV.getEngine().getHistory().go(1);
    }

    @FXML
    private void browserGoButtonAction(ActionEvent event) {
        String url = this.browserUrlTF.getText().trim();
        if (url.isEmpty()) {
            JOptionPane.showMessageDialog(null, "No url provided");
            return;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        this.browserWV.getEngine().load(url);
        this.browserStopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/stoploading.png")));
    }

    @FXML
    private void browserStopReloadButtonAction(ActionEvent event) {
        if (this.browserWV.getEngine().getLoadWorker().isRunning()) {
            this.browserWV.getEngine().getLoadWorker().cancel();
            this.browserStatusL.setText("loaded");
            this.browserPI.setVisible(false);
            this.browserStopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/reload.png")));
        } else {
            this.browserWV.getEngine().reload();
            this.browserStopReloadIV.setImage(new Image(this.getClass().getResourceAsStream("/images/stoploading.png")));
        }
    }

    @FXML
    private void generateQueryButtonAction(ActionEvent event) {
        String query = this.queryTF.getText().trim();
        ObservableList links = this.linksTV.getSelectionModel().getSelectedItems();
        this.sourceTA.setText("");
        for (Crawler.Link link : links) {
            String generateQuery = query;
            generateQuery = generateQuery.replaceAll("#S", link.getSource());
            generateQuery = generateQuery.replaceAll("#U", link.getUrl());
            generateQuery = generateQuery.replaceAll("#AT", link.getAnchorText());
            generateQuery = generateQuery.replaceAll("#LT", link.getLinkType());
            generateQuery = generateQuery.replaceAll("#E", "" + link.isExternal());
            generateQuery = generateQuery.replaceAll("#V", "" + link.isVisited());
            generateQuery = generateQuery.replaceAll("#B", "" + link.isBroken());
            generateQuery = generateQuery.replaceAll("#M", "" + link.isMedia());
            generateQuery = generateQuery.replaceAll("#P", "" + link.isParsed());
            this.sourceTA.appendText(generateQuery);
            this.sourceTA.appendText("\n");
        }
        this.outputContainerTB.getSelectionModel().select(1);
    }

    @FXML
    private void showPreviewButtonAction(ActionEvent event) {
        Crawler.Link link = (Crawler.Link)this.linksTV.getSelectionModel().getSelectedItem();
        if (link != null && link.isParsed()) {
            this.browserWV.getEngine().loadContent(link.getHtml());
            this.outputContainerTB.getSelectionModel().select(0);
        } else {
            JOptionPane.showMessageDialog(null, "Item not selected or not parsed");
        }
    }

    @FXML
    private void showSourceButtonAction(ActionEvent event) {
        Crawler.Link link = (Crawler.Link)this.linksTV.getSelectionModel().getSelectedItem();
        if (link != null && link.isParsed()) {
            this.sourceTA.setText(link.getHtml());
            this.outputContainerTB.getSelectionModel().select(1);
        } else {
            JOptionPane.showMessageDialog(null, "Item not selected or not parsed");
        }
    }

    @FXML
    private void showTagsButtonAction(ActionEvent event) {
        Crawler.Link link = (Crawler.Link)this.linksTV.getSelectionModel().getSelectedItem();
        if (link != null && link.isParsed()) {
            this.browserWV.getEngine().loadContent(this.crawler.getTags(link));
        } else {
            JOptionPane.showMessageDialog(null, "Item not selected or not parsed");
        }
    }

    @FXML
    private void imageDownloadButtonAction(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Select Folder to Save Images");
        final File file = directoryChooser.showDialog((Window)new Stage());
        if (file == null) {
            JOptionPane.showMessageDialog(null, "Folder not selected");
            return;
        }
        System.out.println(file.getPath());
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    for (final Crawler.Link link : links) {
                        if (link.isParsed()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving image from " + link.getUrl());
                                }
                            });
                            ArrayList<String> imagelinks = CrawlerUIController.this.crawler.getImageUrls(link);
                            for (final String imagelink : imagelinks) {
                                Crawler.saveFile(imagelink, file.getPath());
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        CrawlerUIController.this.statusL.setText(imagelink + " Downloaded");
                                    }
                                });
                            }
                            continue;
                        }
                        if (!link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving image from " + link.getUrl());
                                    ArrayList<String> imagelinks = CrawlerUIController.this.crawler.getImageUrls(link);
                                    for (final String imagelink : imagelinks) {
                                        Crawler.saveFile(imagelink, file.getPath());
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                CrawlerUIController.this.statusL.setText(imagelink + " Downloaded");
                                            }
                                        });
                                    }
                                }
                            });
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Image Download Completed");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    @FXML
    private void audioDownloadButtonAction(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Select Folder to Save Images");
        final File file = directoryChooser.showDialog((Window)new Stage());
        if (file == null) {
            JOptionPane.showMessageDialog(null, "Folder not selected");
            return;
        }
        System.out.println(file.getPath());
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    for (final Crawler.Link link : links) {
                        if (link.isParsed()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving Audio from " + link.getUrl());
                                }
                            });
                            ArrayList<String> audiolinks = CrawlerUIController.this.crawler.getAudioUrls(link);
                            for (final String audiolink : audiolinks) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        CrawlerUIController.this.statusL.setText(" Downloading" + audiolink);
                                    }
                                });
                                Crawler.saveFile(audiolink, file.getPath());
                            }
                            continue;
                        }
                        if (!link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving Audio from " + link.getUrl());
                                    ArrayList<String> audiolinks = CrawlerUIController.this.crawler.getAudioUrls(link);
                                    for (final String audiolink : audiolinks) {
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                CrawlerUIController.this.statusL.setText("Downloading " + audiolink);
                                            }
                                        });
                                        Crawler.saveFile(audiolink, file.getPath());
                                    }
                                }
                            });
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Audio Download Completed");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    @FXML
    private void videoDownloadButtonAction(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Select Folder to Save Images");
        final File file = directoryChooser.showDialog((Window)new Stage());
        if (file == null) {
            JOptionPane.showMessageDialog(null, "Folder not selected");
            return;
        }
        System.out.println(file.getPath());
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    for (final Crawler.Link link : links) {
                        if (link.isParsed()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving Video from " + link.getUrl());
                                }
                            });
                            ArrayList<String> videolinks = CrawlerUIController.this.crawler.getVideoUrls(link);
                            for (final String videolink : videolinks) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        CrawlerUIController.this.statusL.setText(" Downloading" + videolink);
                                    }
                                });
                                Crawler.saveFile(videolink, file.getPath());
                            }
                            continue;
                        }
                        if (!link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving Video from " + link.getUrl());
                                    ArrayList<String> videolinks = CrawlerUIController.this.crawler.getVideoUrls(link);
                                    for (final String videolink : videolinks) {
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                CrawlerUIController.this.statusL.setText("Downloading " + videolink);
                                            }
                                        });
                                        Crawler.saveFile(videolink, file.getPath());
                                    }
                                }
                            });
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Video Download Completed");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    @FXML
    private void cssDownloadButtonAction(ActionEvent event) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle("Select Folder to Save Images");
        final File file = directoryChooser.showDialog((Window)new Stage());
        if (file == null) {
            JOptionPane.showMessageDialog(null, "Folder not selected");
            return;
        }
        if (this.longTaskExecuter == null || !this.longTaskExecuter.isAlive()) {
            Task<Void> task = new Task<Void>(){

                protected Void call() throws Exception {
                    ObservableList links = CrawlerUIController.this.linksTV.getSelectionModel().getSelectedItems();
                    for (final Crawler.Link link : links) {
                        if (link.isParsed()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving CSS from " + link.getUrl());
                                }
                            });
                            ArrayList<String> stylesheetlinks = CrawlerUIController.this.crawler.getStylesheetUrls(link);
                            for (final String stylesheetlink : stylesheetlinks) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        CrawlerUIController.this.statusL.setText(" Downloading " + stylesheetlink);
                                    }
                                });
                                Crawler.saveFile(stylesheetlink, file.getPath());
                            }
                            continue;
                        }
                        if (!link.isMedia()) {
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Parsing " + link.getUrl());
                                }
                            });
                            CrawlerUIController.this.crawler.parse(link);
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CrawlerUIController.this.statusL.setText("Saving CSS from " + link.getUrl());
                                    ArrayList<String> stylesheetlinks = CrawlerUIController.this.crawler.getStylesheetUrls(link);
                                    for (final String stylesheetlink : stylesheetlinks) {
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                CrawlerUIController.this.statusL.setText("Downloading " + stylesheetlink);
                                            }
                                        });
                                        Crawler.saveFile(stylesheetlink, file.getPath());
                                    }
                                }
                            });
                            continue;
                        }
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CrawlerUIController.this.statusL.setText(link.getUrl() + " cannot be parsed");
                            }
                        });
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CrawlerUIController.this.statusL.setText("Css Download Completed");
                            CrawlerUIController.this.linksTV.setItems(FXCollections.observableArrayList(CrawlerUIController.this.crawler.getLinks()));
                        }
                    });
                    return null;
                }
            };
            this.longTaskExecuter = new Thread((Runnable)task);
            this.longTaskExecuter.setDaemon(true);
            this.longTaskExecuter.start();
        } else {
            JOptionPane.showMessageDialog(null, "System already processing... wait!");
        }
    }

    @FXML
    private void filterButtonAction(ActionEvent event) {
        StringTokenizer st = new StringTokenizer(this.sourceTA.getText(), "\n");
        String filteredText = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.contains(this.filterTF.getText())) continue;
            filteredText = filteredText + token + "\n";
        }
        this.sourceTA.setText(filteredText);
    }

    @FXML
    private void replaceButtonAction(ActionEvent event) {
        this.sourceTA.setText(this.sourceTA.getText().replaceAll(Pattern.quote(this.findTF.getText()), this.replaceTF.getText()));
    }
}

