<!DOCTYPE html>
<html>

<head>
    <title>DataTable with Ajax Data Source</title>
    <!-- Datatable CSS -->
    <link href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
</head>

<body>
    <h1>DataTable with Ajax Data Source Example</h1>
    <!-- Table -->
    <table id="employeeTable">
        <thead>
            <tr>
                <th>Name</th>
                <th>Position</th>
                <th>Office</th>
                <th>Age</th>
                <th>Start Date</th>
                <th>Salary</th>
            </tr>
        </thead>
        <tbody>

        </tbody>
    </table>

    <!-- jQuery Library -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <!-- Datatable JS -->
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>

    <script>
        $('#employeeTable').dataTable({
            'processing': true,
            'serverSide': true,
            'serverMethod': 'post',
            "ajax": {
                "url": "get-data.php",
            },
            'columns': [{
                    data: 'name'
                },
                {
                    data: 'position'
                },
                {
                    data: 'office'
                },
                {
                    data: 'age'
                },
                {
                    data: 'start_date'
                },
                {
                    data: 'salary'
                },
            ],
            destroy: true,
        });
    </script>
</body>

</html>