/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.location.zzo;

public final class LocationRequest
extends zza
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int mVersionCode;
    int mPriority;
    long zzbjw;
    long zzbjx;
    boolean zzaVX;
    long zzbjb;
    int zzbjy;
    float zzbjz;
    long zzbjA;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzo();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mVersionCode = 1;
        this.mPriority = 102;
        this.zzbjw = 3600000L;
        this.zzbjx = 600000L;
        this.zzaVX = false;
        this.zzbjb = Long.MAX_VALUE;
        this.zzbjy = Integer.MAX_VALUE;
        this.zzbjz = 0.0f;
        this.zzbjA = 0L;
    }

    public LocationRequest setPriority(int n) {
        LocationRequest.zzkc(n);
        this.mPriority = n;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long l) {
        LocationRequest.zzU(l);
        this.zzbjw = l;
        if (!this.zzaVX) {
            this.zzbjx = (long)((double)this.zzbjw / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.zzbjw;
    }

    public LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzU(l);
        this.zzbjA = l;
        return this;
    }

    public long getMaxWaitTime() {
        long l = this.zzbjA;
        if (l < this.zzbjw) {
            l = this.zzbjw;
        }
        return l;
    }

    public LocationRequest setFastestInterval(long l) {
        LocationRequest.zzU(l);
        this.zzaVX = true;
        this.zzbjx = l;
        return this;
    }

    public long getFastestInterval() {
        return this.zzbjx;
    }

    public LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzbjb = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzbjb < 0L) {
            this.zzbjb = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long l) {
        this.zzbjb = l;
        if (this.zzbjb < 0L) {
            this.zzbjb = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.zzbjb;
    }

    public LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzbjy = n;
        return this;
    }

    public int getNumUpdates() {
        return this.zzbjy;
    }

    public LocationRequest setSmallestDisplacement(float f) {
        LocationRequest.zze(f);
        this.zzbjz = f;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.zzbjz;
    }

    private static void zzU(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    private static void zzkc(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
    }

    private static void zze(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
    }

    LocationRequest(int n, int n2, long l, long l2, boolean bl, long l3, int n3, float f, long l4) {
        this.mVersionCode = n;
        this.mPriority = n2;
        this.zzbjw = l;
        this.zzbjx = l2;
        this.zzaVX = bl;
        this.zzbjb = l3;
        this.zzbjy = n3;
        this.zzbjz = f;
        this.zzbjA = l4;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzo.zza(this, parcel, n);
    }

    public static String zzkd(int n) {
        switch (n) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.zzkd(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzbjw).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzbjx).append("ms");
        if (this.zzbjA > this.zzbjw) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzbjA).append("ms");
        }
        if (this.zzbjb != Long.MAX_VALUE) {
            long l = this.zzbjb - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzbjy != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzbjy);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return zzaa.hashCode((Object[])new Object[]{this.mPriority, this.zzbjw, this.zzbjx, this.zzaVX, this.zzbjb, this.zzbjy, Float.valueOf(this.zzbjz)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzbjw == locationRequest.zzbjw && this.zzbjx == locationRequest.zzbjx && this.zzaVX == locationRequest.zzaVX && this.zzbjb == locationRequest.zzbjb && this.zzbjy == locationRequest.zzbjy && this.zzbjz == locationRequest.zzbjz;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }
}

