/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzarz;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzi;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zza {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzi();
    private final int mVersionCode;
    private final List<zzarz> zzbjl;
    private final int zzbjm;
    private final String mTag;

    GeofencingRequest(int n, List<zzarz> list, int n2, String string) {
        this.mVersionCode = n;
        this.zzbjl = list;
        this.zzbjm = n2;
        this.mTag = string;
    }

    private GeofencingRequest(List<zzarz> list, int n, String string) {
        this(1, list, n, string);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public List<zzarz> zzHq() {
        return this.zzbjl;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzbjl);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzbjm;
    }

    public String getTag() {
        return this.mTag;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzi.zza(this, parcel, n);
    }

    public static final class Builder {
        private final List<zzarz> zzbjl = new ArrayList<zzarz>();
        private int zzbjm = 5;
        private String mTag = "";

        public Builder addGeofence(Geofence geofence) {
            zzac.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzac.zzb((boolean)(geofence instanceof zzarz), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzbjl.add((zzarz)geofence);
            return this;
        }

        public Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public Builder setInitialTrigger(int n) {
            this.zzbjm = Builder.zzjY(n);
            return this;
        }

        public static int zzjY(int n) {
            return n & 7;
        }

        public GeofencingRequest build() {
            zzac.zzb((!this.zzbjl.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzbjl, this.zzbjm, this.mTag);
        }
    }
}

