<?php
include './PushNotification.php';

if (isset($_POST['send'])) {
    $registration_ids = array();
    foreach ($_POST['registration_ids'] as $regid) {
        if (trim($regid) <> "") {
            $registration_ids[] = $regid;
        }
    }
    if (!empty($registration_ids)) {
        $target['registration_ids'] = $registration_ids;
    } else {
        $target['topic'] = trim($_POST['topic']);
    }
    $fields = array(
        'title' => isset($_POST['title']) ? trim($_POST['title']) : "",
        'body' => isset($_POST['body']) ? trim($_POST['body']) : ""
    );
    $data = array();
    foreach ($_POST['key'] as $key => $value) {
        if (trim($value) <> "") {
            $data[$value] = $_POST['value'][$key];
        }
    }
    $response = PushNotification::sendNotification($target, $fields, $data);
}
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Push Notification</title>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
    </head>
    <body>
        <h1>Send Notification</h1>
        <form method="post">
            <table>
                <tr>
                    <td style="vertical-align: top;">
                        <label>Topic</label><br/>
                        <select name="topic">
                            <option value="">-Select-</option>
                            <option value="android">Android</option>
                        </select>
                    </td>
                    <td>Or</td>
                    <td>
                        <label>Registration Ids</label>
                        <table>
                            <tbody id="registrationIds_container">
                                <tr id="regid0">
                                    <td><input type="text" name="registration_ids[]" placeholder="Registration Id"/></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td style="text-align: right"><a href="javascript:;" onclick="addRegId()">Add</a></td>
                                </tr>
                            </tfoot>
                        </table>
                    </td>
                </tr>
            </table>
            <br/><br/>

            <label>Title</label><br/>
            <input type="text" name="title"/>
            <br/><br/>
            <label>Message</label><br/>
            <textarea name="body" style="width: 490px; height: 100px;"></textarea>
            <br/><br/>
            <label>Custom Data</label><br/>
            <table>
                <tbody id="custom_data_container">
                    <tr id="data0">
                        <td><input type="text" name="key[]" placeholder="Key"/></td>
                        <td><input type="text" name="value[]" placeholder="Value"/></td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td></td>
                        <td style="text-align: right"><a href="javascript:;" onclick="addCustomData()">Add</a></td>
                    </tr>
                </tfoot>
            </table>
            <p><?= isset($response) ? $response : "" ?></p>
            <input type="submit" name="send" value="Send"/>
        </form>

        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.0/jquery.min.js" integrity="sha256-xNzN2a4ltkB44Mc/Jz3pT4iU1cmeR0FkXs4pru/JxaQ=" crossorigin="anonymous"></script>
        <script>
            function addRegId() {
                var count = $("#registrationIds_container tr").length + 1;

                var item = '<tr id="regid' + count + '">';
                item += '<td><input type="text" name="registration_ids[]" placeholder="Registration Id"/></td>';
                item += '<td><a href="javascript:void();" onclick="deleteRow(\'regid' + count + '\')" class="btn btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i></a></td>';
                item += '</tr>';

                $('#registrationIds_container').append(item);
            }
            function addCustomData() {
                var count = $("#custom_data_container tr").length + 1;

                var item = '<tr id="data' + count + '">';
                item += '<td><input type="text" name="key[]" placeholder="Key"/></td>';
                item += '<td><input type="text" name="value[]" placeholder="Value"/></td>';
                item += '<td><a href="javascript:void();" onclick="deleteRow(\'data' + count + '\')" class="btn btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i></a></td>';
                item += '</tr>';

                $('#custom_data_container').append(item);
            }

            function deleteRow(id) {
                $("#" + id).remove();
            }
        </script>
    </body>
</html>
