package com.zatackcoder.fileupload;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

public class MainActivity extends AppCompatActivity implements ActivityCompat.OnRequestPermissionsResultCallback {

    ImageView uploadedIV;
    TextView statusTV;
    Button uploadB;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        uploadedIV = (ImageView) findViewById(R.id.uploadedIV);
        statusTV = (TextView) findViewById(R.id.statusTV);
        uploadB = (Button) findViewById(R.id.uploadB);

        uploadB.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
                intent.setType("file/*");
                startActivityForResult(intent, 1);
            }
        });
        getPermissions();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if(resultCode == Activity.RESULT_OK){
            if(requestCode == 1){
                if(data == null){
                    //no data present
                    return;
                }

                String selectedFilePath = FilePath.getPath(this, data.getData());

                if(selectedFilePath != null && !selectedFilePath.equals("")){
                    new UploadFileAsyncTask(selectedFilePath).execute();
                } else{
                    Toast.makeText(this,"Cannot upload file to server",Toast.LENGTH_SHORT).show();
                }
            }
        }
    }

    class UploadFileAsyncTask extends AsyncTask<Void, Void, Void> {

        String selectedFilePath;
        String uploadedFilePath = "";
        String fileType = "";

        UploadFileAsyncTask(String selectedFilePath) {
            this.selectedFilePath = selectedFilePath;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            statusTV.setText("Uploading...");
        }

        @Override
        protected Void doInBackground(Void... voids) {
            HashMap params = new HashMap<String, String>();
            params.put("key","ABCD");
            params.put("action","upload");
            HashMap fileParams = new HashMap<String, String>();
            fileParams.put("file",selectedFilePath);

            JsonParser jsonParser = new JsonParser();
            JSONObject jsonObject = jsonParser.post("http://zatackcoder.com/demo/api/user.php", params, fileParams);
            if(jsonObject != null) {
                try {
                    JSONObject dataJson = jsonObject.getJSONObject("data");
                    uploadedFilePath = dataJson.getString("fileurl");
                    fileType = dataJson.getString("filetype");
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            statusTV.setText(uploadedFilePath);
            if(uploadedFilePath.isEmpty()) {
                statusTV.setText("Error");
            }
            switch (fileType.toLowerCase()) {
                case "txt" :
                    uploadedIV.setImageResource(R.mipmap.txt_icon);
                    break;
                case "doc" :
                    uploadedIV.setImageResource(R.mipmap.doc_icon);
                    break;
                case "jpg" :
                    uploadedIV.setImageResource(R.mipmap.jpg_icon);
                    break;
                case "gif" :
                    uploadedIV.setImageResource(R.mipmap.gif_icon);
                    break;
                default:
                    uploadedIV.setImageResource(R.mipmap.unknown_icon);
            }
        }
    }

    private void getPermissions(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if(checkSelfPermission(Manifest.permission.ACCESS_NETWORK_STATE) != PackageManager.PERMISSION_GRANTED || checkSelfPermission(Manifest.permission.INTERNET) != PackageManager.PERMISSION_GRANTED || checkSelfPermission(Manifest.permission.READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED){
                //Requesting permission.
                ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.ACCESS_NETWORK_STATE, Manifest.permission.INTERNET, Manifest.permission.READ_EXTERNAL_STORAGE}, 1);
            }
        }
    }

    @Override //Override from ActivityCompat.OnRequestPermissionsResultCallback Interface
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 1: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    // permission granted
                }
                return;
            }
        }
    }

}
