<?php
include_once 'config.php';

//uploading
if(isset($_FILES['file']) && isset($_REQUEST['path'])) {
    $fileElement = "file";
    $path = urldecode($_REQUEST['path']);
    $response = upload($fileElement, 10000, $path, "N");
    if(!$response['error']) {
        echo "success";        
    }  
    exit();
}

$dir = "files";
if(isset($_REQUEST['path'])) {
    $dir = urldecode($_REQUEST['path']);
}

//folder create
if(isset($_REQUEST['createfolder'])) {
    $foldername = trim($_REQUEST['createfolder']);    
    if(mkdir($dir."/".$foldername, 0777, true)){        
        header("location: ?path=".$dir);
    }
}

//move
if(isset($_REQUEST['move']) && isset($_REQUEST['filenames']) && isset($_REQUEST['folder'])) {
    $filenames = $_REQUEST['filenames'];
    $folder = $_REQUEST['folder'];
    $currentdir = urldecode($_REQUEST['path']);
    $flag = true;
    foreach($filenames as $filename) {               
        //echo $currentdir . "/" . $filename . "=" . $folder . "/" . $filename;
        if (!rename($currentdir . "/" . $filename, $folder . "/" . $filename)) {
            $flag = false;
            break;
        }
    }   
    if($flag) {
        echo "success";        
    }    
    exit();
}

//delete
if(isset($_REQUEST['delete']) && isset($_REQUEST['filenames'])) {
    $filenames = $_REQUEST['filenames'];    
    $currentdir = urldecode($_REQUEST['path']);
    $flag = true;
    foreach($filenames as $filename) {    
        //delete if it is directory
        if(is_dir($currentdir . "/" . $filename)) {
            rmdir($currentdir . "/" . $filename);
        }
        if (is_file($currentdir . "/" . $filename) && !unlink($currentdir . "/" . $filename)) {
            $flag = false;
            break;
        }
    }   
    if($flag) {
        echo "success";        
    }    
    exit();
}

//files and folder list
$files = scan($dir);

?>
<!DOCTYPE html>
<html>
    <head lang="en">
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <title>File Browser</title>
        <!-- Include our stylesheet -->        
        <link href='//fonts.googleapis.com/css?family=Questrial' rel='stylesheet' type='text/css'>
        <link href='//fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic' rel='stylesheet' type='text/css'>        
        <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"/>        
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
        <style>
            .selected {
                background-color: rgba(192, 192, 192, 0.6);
            }
            .file-upload {
                cursor: inherit;
                display: block;
                /*font-size: 999px;*/
                filter: alpha(opacity=0);
                min-height: 100%;
                min-width: 100%;
                opacity: 0;
                position: absolute;
                right: 0;
                text-align: right;
                top: 0;
            }
        </style>
    </head>
    <body>
        <div class="container" style="margin-top: 20px;">
            <div class="panel panel-default">
                <div class="panel-heading">
                    File Browser
                    <div class="pull-right">
                        <span id="uploading" style="display: none;">Uploading...</span>
                        <div class="btn-group">                            
                            <button class="btn btn-default btn-sm" title="Upload"><i class="fa fa-upload"></i> Upload<input type="file" class="file-upload"/></button>
                            <a href="javascript:void()" onclick="downloadSelected()" class="btn btn-sm btn-default" title="Download"><i class="fa fa-download"></i> Download</a>
                            <a href="javascript:void()" onclick="moveSelected()" class="btn btn-sm btn-default" title="Move"><i class="fa fa-arrows"></i> Move</a>
                            <a href="javascript:deleteSelected()" onclick="return confirm('are you sure, you want to delete?')" class="btn btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i> Delete</a>
                            <a href="javascript:void()" onclick="createFolder()" class="btn btn-sm btn-primary" title="Create New Folder"><i class="fa fa-folder"></i> New Folder</a>
                        </div>                    
                    </div>
                    <p style="font-size: 10px;font-weight: bold; color: black;"><?php echo $dir; ?></p>
                </div>
                <div class="panel-body">
                    <div class="btn-group">
                        <a href="javascript:void()" onclick="javascript:window.history.back()" class="btn btn-sm btn-default">Back</a>
                        <a href="javascript:void()" onclick="javascript:window.history.forward()" class="btn btn-sm btn-default">Forward</a>                       
                    </div>
                    <div class="table-responsive">                    
                        <table class="table table-condensed table-hover">
                            <thead>
                                <tr>                                    
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Size</th>                                    
                                </tr>
                            </thead>                            
                            <tbody>
                            <?php
                                foreach ($files as $file) {    
                                    $path = "?path=".urlencode($file['path']);
                                    if($file['type'] == "file") {
                                        $path = $file['path'];
                                    }                                    
                                    ?>
                                    <tr>                                        
                                        <td><a href="<?php echo $path; ?>" <?php if($file['type'] == "file") { ?> target="_blank" download <?php } ?>><?php echo $file['name']; ?></a></td>
                                        <td><?php echo $file['type']; ?></td>
                                        <td><?php if($file['type'] == "file") { echo $file['size']; } ?></td>                                        
                                    </tr>
                            <?php } ?>   
                            </tbody>                                                         
                        </table>                    
                    </div>
                </div>                       
            </div>       
        </div>        
        <!-- Include our script files -->
        <script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <script src="https://code.jquery.com/ui/1.12.0/jquery-ui.js"></script>
        <script>
            $("input[type=file]").change(function(){                    
                var action = "<?php echo basename($_SERVER['PHP_SELF']) . "?path=". urlencode($dir); ?>";
                if($(this).val() === "") {
                    return;
                }                
                $("#uploading").show();
                var data = new FormData();
                data.append("file", $('input[type=file]')[0].files[0]);                
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data,
                    /*THIS MUST BE DONE FOR FILE UPLOADING*/
                    contentType: false,
                    processData: false,
                }).done(function(data){                            
                    $("#uploading").hide(); 
                    if(data === "success") {
                        window.location.href = "?path=<?php echo $dir; ?>";
                    }                    
                }).fail(function(data){
                    //any message
                });  
            });          
            
            function createFolder() {
                var foldername = prompt("Enter Folder Name", "New Folder");
                if(foldername !== null) {
                    window.location.href = "?path=<?php echo $dir; ?>&createfolder=" + foldername;
                }
            }
            
            cntrlIsPressed = false;
            $(document).keydown(function(event){
                if(event.which=="17")
                    cntrlIsPressed = true;
            });

            $(document).keyup(function(){
                cntrlIsPressed = false;
            });
            $("table tbody tr").hover(function(){
               //$(this).addClass('active').siblings().removeClass('active');
            });
            
            $("table tbody tr").click(function(){
                if(cntrlIsPressed) {
                    $(this).addClass('selected');
                } else {
                    $(this).addClass('selected').removeClass('active').siblings().removeClass('selected');
                }               
            });

            $('.ok').on('click', function(e){
               alert($("#table tr.selected td:first").html());
               var selectedIDs = [];
               $("#table tr.selected").each(function(index, row) {
                  selectedIDs.push($(row).find("td:first").html());
               });
                
            });                       
                     
            function downloadSelected(){
                $("table tbody tr.selected").each(function () {
                    var url = $(this).find("a").attr("href");  
                    if($(this).find("td:eq(1)").html() === "file") {
                        var a = $("<a>").attr("href", url).attr("download", "").appendTo("body");
                        a[0].click();
                        a.remove();
                    }
                }); 
            }
            
            function moveSelected(){
                var action = "<?php echo basename($_SERVER['PHP_SELF']) . "?path=". urlencode($dir); ?>";
                if($("table tbody tr.selected").length <= 0) {
                    alert("Please select file/s");
                    return;
                }                
                var folder = prompt("Enter Folder Name to Move","<?php echo $dir; ?>");
                var data = new FormData();
                data.append("move", "1");
                data.append("folder", folder);
                $("table tbody tr.selected").each(function (index) {
                    var filename = $(this).find("td:eq(0)").text();  
                    data.append("filenames["+index+"]", filename);
                });                
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data,
                    /*THIS MUST BE DONE FOR FILE UPLOADING*/
                    contentType: false,
                    processData: false,
                }).done(function(data){                                                
                    if(data.trim() === "success") {
                        window.location.href = "?path=<?php echo $dir; ?>";
                    }                    
                }).fail(function(data){
                    //any message
                });  
            }
            
            function deleteSelected(){
                var action = "<?php echo basename($_SERVER['PHP_SELF']) . "?path=". urlencode($dir); ?>";
                if($("table tbody tr.selected").length <= 0) {
                    alert("Please select file/s");
                    return;
                }                                
                var data = new FormData();
                data.append("delete", "1");
                $("table tbody tr.selected").each(function (index) {
                    var filename = $(this).find("td:eq(0)").text();  
                    data.append("filenames["+index+"]", filename);
                });                
                $.ajax({
                    type: 'POST',
                    url: action,
                    data: data,
                    /*THIS MUST BE DONE FOR FILE UPLOADING*/
                    contentType: false,
                    processData: false,
                }).done(function(data){                                                
                    if(data.trim() === "success") {
                        window.location.href = "?path=<?php echo $dir; ?>";
                    }                    
                }).fail(function(data){
                    //any message
                });  
            }
        </script>
    </body>
</html>
