package com.zatackcoder.firebasedatabaseexample;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;

import java.util.HashMap;
import java.util.Map;

public class EditItemActivity extends AppCompatActivity {

    FirebaseFirestore db;
    EditText nameET;
    EditText colorET;
    EditText sizeET;
    EditText priceET;
    String documentId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_item);

        db = FirebaseFirestore.getInstance();
        Intent i = getIntent();
        documentId = i.getStringExtra("documentId");
        if(documentId == null || documentId.isEmpty()) {
            startActivity(new Intent(this, ViewItemsActivity.class));
            finish();
        }
        initControls();
    }

    private void initControls() {
        nameET = findViewById(R.id.nameET);
        colorET = findViewById(R.id.colorET);
        sizeET = findViewById(R.id.sizeET);
        priceET = findViewById(R.id.priceET);

        Button saveB = findViewById(R.id.saveB);
        saveB.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Item item = new Item(nameET.getText().toString(), colorET.getText().toString(), Integer.parseInt(sizeET.getText().toString()), Double.parseDouble(priceET.getText().toString()));
                // Update a existing document with a document ID
                db.collection("items").document(documentId)
                        .set(item)
                        .addOnSuccessListener(new OnSuccessListener<Void>() {
                            @Override
                            public void onSuccess(Void aVoid) {
                                Toast.makeText(getApplicationContext(), "Item Updated with ID: " + documentId, Toast.LENGTH_LONG).show();
                            }
                        })
                        .addOnFailureListener(new OnFailureListener() {
                            @Override
                            public void onFailure(@NonNull Exception e) {
                                Toast.makeText(getApplicationContext(), "Error Updating Item! - " + e, Toast.LENGTH_LONG).show();
                            }
                        });
            }
        });

        DocumentReference docRef = db.collection("items").document(documentId);
        docRef.get().addOnSuccessListener(new OnSuccessListener<DocumentSnapshot>() {
            @Override
            public void onSuccess(DocumentSnapshot documentSnapshot) {
                Item item = documentSnapshot.toObject(Item.class);
                nameET.setText(item.getName());
                colorET.setText(item.getColor());
                sizeET.setText(item.getSize().toString());
                priceET.setText(item.getPrice().toString());
            }
        });
    }
}
