package com.zatackcoder.firebasedatabaseexample;

public class Item {

    private String name;
    private String color;
    private Integer size;
    private Double price;

    public Item() {

    }

    public Item(String name, String color, Integer size, Double price) {
        this.name = name;
        this.color = color;
        this.size = size;
        this.price = price;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Integer getSize() {
        return size;
    }

    //customised setter to overcome deserialize object error
    //java.lang.RuntimeException: Could not deserialize object. Failed to convert a value of type java.lang.String to int
    public void setSize(Object size) {
        try {
            this.size = Integer.parseInt(size.toString());
        } catch (Exception e) {
            this.size = 0;
        }
    }

    public Double getPrice() {
        return price;
    }

    //customised setter to overcome deserialize object error
    //java.lang.RuntimeException: Could not deserialize object. Failed to convert a value of type java.lang.String to double
    public void setPrice(Object price) {
        try {
            this.price = Double.parseDouble(price.toString());
        } catch (Exception e) {
            this.price = 0.00;
        }
    }
}
