package com.zatackcoder.firebasedatabaseexample;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.firebase.ui.firestore.FirestoreRecyclerAdapter;
import com.firebase.ui.firestore.FirestoreRecyclerOptions;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;

public class ItemAdapter extends FirestoreRecyclerAdapter<Item, ItemAdapter.ItemViewHolder> {

    Context context;

    /**
     * Create a new RecyclerView adapter that listens to a Firestore Query.  See {@link
     * FirestoreRecyclerOptions} for configuration options.
     *
     * @param options
     */
    public ItemAdapter(Context context, @NonNull FirestoreRecyclerOptions<Item> options) {
        super(options);
        this.context = context;
    }

    @NonNull
    @Override
    public ItemAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item, parent, false);
        return new ItemAdapter.ItemViewHolder(view);
    }

    @Override
    protected void onBindViewHolder(@NonNull final ItemAdapter.ItemViewHolder itemViewHolder, int i, @NonNull Item item) {
        itemViewHolder.name.setText(item.getName());
        itemViewHolder.color.setText("Color: " + item.getColor());
        itemViewHolder.size.setText("Size: " + item.getSize().toString());
        itemViewHolder.price.setText("Price: " + item.getPrice().toString());

        final String documentId = getSnapshots().getSnapshot(i).getId();

        itemViewHolder.edit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent i = new Intent(context, EditItemActivity.class);
                i.putExtra("documentId", documentId);
                context.startActivity(i);
            }
        });

        itemViewHolder.delete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FirebaseFirestore db = FirebaseFirestore.getInstance();
                db.collection("items").document(documentId)
                        .delete()
                        .addOnSuccessListener(new OnSuccessListener<Void>() {
                    @Override
                    public void onSuccess(Void aVoid) {
                        Toast.makeText(context, "Item deleted successfully!", Toast.LENGTH_LONG).show();
                    }
                });
            }
        });
    }

    @Override
    public void onError(@NonNull FirebaseFirestoreException e) {
        //super.onError(e);
    }

    public static class ItemViewHolder extends RecyclerView.ViewHolder {
        View container;
        TextView name;
        TextView color;
        TextView size;
        TextView price;
        Button edit;
        Button delete;

        public ItemViewHolder(View view) {
            super(view);
            container = view;
            name = view.findViewById(R.id.name);
            color = view.findViewById(R.id.color);
            size = view.findViewById(R.id.size);
            price = view.findViewById(R.id.price);
            edit = view.findViewById(R.id.edit);
            delete = view.findViewById(R.id.delete);
        }
    }
}
