package com.zatackcoder.firebasedatabaseexample;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;

public class AddItemActivity extends AppCompatActivity {

    FirebaseFirestore db;
    EditText nameET;
    EditText colorET;
    EditText sizeET;
    EditText priceET;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_add_item);

        // Access a Cloud Firestore instance from your Activity
        db = FirebaseFirestore.getInstance();
        initControls();
    }

    private void initControls() {
        nameET = findViewById(R.id.nameET);
        colorET = findViewById(R.id.colorET);
        sizeET = findViewById(R.id.sizeET);
        priceET = findViewById(R.id.priceET);

        Button saveB = findViewById(R.id.saveB);
        saveB.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Item item = new Item(nameET.getText().toString(), colorET.getText().toString(), Integer.parseInt(sizeET.getText().toString()), Double.parseDouble(priceET.getText().toString()));

                // Add a new document with a generated ID
                db.collection("items")
                        .add(item)
                        .addOnSuccessListener(new OnSuccessListener<DocumentReference>() {
                            @Override
                            public void onSuccess(DocumentReference documentReference) {
                                nameET.setText("");
                                colorET.setText("");
                                sizeET.setText("");
                                priceET.setText("");
                                Toast.makeText(getApplicationContext(), "Item Added with ID: " + documentReference.getId(), Toast.LENGTH_LONG).show();
                            }
                        })
                        .addOnFailureListener(new OnFailureListener() {
                            @Override
                            public void onFailure(@NonNull Exception e) {
                                Toast.makeText(getApplicationContext(), "Error Adding Item! - " + e, Toast.LENGTH_LONG).show();
                            }
                        });
            }
        });
    }
}
