/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ir.server;

import android.util.Log;
import com.android.tools.ir.runtime.Paths;
import com.android.tools.ir.server.AppInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FileManager {
    static final boolean USE_EXTRACTED_RESOURCES = false;
    private static final String RESOURCE_FILE_NAME = "resources.ap_";
    private static final String RESOURCE_FOLDER_NAME = "resources";
    private static final String FILE_NAME_ACTIVE = "active";
    private static final String FOLDER_NAME_LEFT = "left";
    private static final String FOLDER_NAME_RIGHT = "right";
    private static final String RELOAD_DEX_PREFIX = "reload";
    public static final String CLASSES_DEX_SUFFIX = ".dex";
    private static boolean havePurgedTempDexFolder;

    private static File getDataFolder() {
        return new File(Paths.getDataDirectory(AppInfo.applicationId));
    }

    private static File getResourceFile(File base) {
        return new File(base, RESOURCE_FILE_NAME);
    }

    private static File getTempDexFileFolder(File base) {
        return new File(base, "dex-temp");
    }

    public static File getNativeLibraryFolder() {
        return new File(Paths.getMainApkDataDirectory(AppInfo.applicationId), "lib");
    }

    public static File getReadFolder() {
        String name = FileManager.leftIsActive() ? FOLDER_NAME_LEFT : FOLDER_NAME_RIGHT;
        return new File(FileManager.getDataFolder(), name);
    }

    public static void swapFolders() {
        FileManager.setLeftActive(!FileManager.leftIsActive());
    }

    public static File getWriteFolder(boolean wipe) {
        String name = FileManager.leftIsActive() ? FOLDER_NAME_RIGHT : FOLDER_NAME_LEFT;
        File folder = new File(FileManager.getDataFolder(), name);
        if (wipe && folder.exists()) {
            FileManager.delete(folder);
            boolean mkdirs = folder.mkdirs();
            if (!mkdirs) {
                Log.e((String)"InstantRun", (String)("Failed to create folder " + folder));
            }
        }
        return folder;
    }

    private static void delete(File file) {
        boolean deleted;
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                FileManager.delete(child);
            }
        }
        if (!(deleted = file.delete())) {
            Log.e((String)"InstantRun", (String)("Failed to delete file " + file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean leftIsActive() {
        boolean bl;
        File folder = FileManager.getDataFolder();
        File pointer = new File(folder, FILE_NAME_ACTIVE);
        if (!pointer.exists()) {
            return true;
        }
        BufferedReader reader = new BufferedReader(new FileReader(pointer));
        try {
            String line = reader.readLine();
            bl = FOLDER_NAME_LEFT.equals(line);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ignore) {
                return true;
            }
        }
        reader.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLeftActive(boolean active) {
        File folder = FileManager.getDataFolder();
        File pointer = new File(folder, FILE_NAME_ACTIVE);
        if (pointer.exists()) {
            boolean deleted = pointer.delete();
            if (!deleted) {
                Log.e((String)"InstantRun", (String)("Failed to delete file " + pointer));
            }
        } else if (!folder.exists()) {
            boolean create = folder.mkdirs();
            if (!create) {
                Log.e((String)"InstantRun", (String)("Failed to create directory " + folder));
            }
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pointer), "UTF-8"));
            try {
                writer.write(active ? FOLDER_NAME_LEFT : FOLDER_NAME_RIGHT);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File getExternalResourceFile() {
        File file = FileManager.getResourceFile(FileManager.getReadFolder());
        if (!file.exists()) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)"Cannot find external resources, not patching them in");
            }
            return null;
        }
        return file;
    }

    public static File getTempDexFile() {
        File dataFolder = FileManager.getDataFolder();
        File dexFolder = FileManager.getTempDexFileFolder(dataFolder);
        if (!dexFolder.exists()) {
            boolean created = dexFolder.mkdirs();
            if (!created) {
                Log.e((String)"InstantRun", (String)("Failed to create directory " + dexFolder));
                return null;
            }
            havePurgedTempDexFolder = true;
        } else if (!havePurgedTempDexFolder) {
            FileManager.purgeTempDexFiles(dataFolder);
        }
        File[] files = dexFolder.listFiles();
        int max = -1;
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith(RELOAD_DEX_PREFIX) || !name.endsWith(CLASSES_DEX_SUFFIX)) continue;
                String middle = name.substring(RELOAD_DEX_PREFIX.length(), name.length() - CLASSES_DEX_SUFFIX.length());
                try {
                    int version = Integer.decode(middle);
                    if (version <= max) continue;
                    max = version;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String fileName = String.format("%s0x%04x%s", RELOAD_DEX_PREFIX, max + 1, CLASSES_DEX_SUFFIX);
        File file = new File(dexFolder, fileName);
        if (Log.isLoggable((String)"InstantRun", (int)2)) {
            Log.v((String)"InstantRun", (String)("Writing new dex file: " + file));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeRawBytes(File destination, byte[] bytes) {
        boolean bl;
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destination));
        try {
            output.write(bytes);
            output.flush();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Log.wtf((String)"InstantRun", (String)("Failed to write file, clean project and rebuild " + destination), (Throwable)ioe);
                throw new RuntimeException(String.format("InstantRun could not write file %1$s, clean project and rebuild ", destination));
            }
        }
        output.close();
        return bl;
    }

    public static boolean extractZip(File destination, byte[] zipBytes) {
        Log.wtf((String)"InstantRun", (String)"");
        return false;
    }

    public static void startUpdate() {
        FileManager.getWriteFolder(true);
    }

    public static void finishUpdate(boolean wroteResources) {
        if (wroteResources) {
            FileManager.swapFolders();
        }
    }

    public static void writeAaptResources(String relativePath, byte[] bytes) {
        boolean created;
        File resourceFile = FileManager.getResourceFile(FileManager.getWriteFolder(false));
        File file = resourceFile;
        File folder = file.getParentFile();
        if (!folder.isDirectory() && !(created = folder.mkdirs())) {
            if (Log.isLoggable((String)"InstantRun", (int)2)) {
                Log.v((String)"InstantRun", (String)("Cannot create local resource file directory " + folder));
            }
            return;
        }
        if (relativePath.equals(RESOURCE_FILE_NAME)) {
            FileManager.writeRawBytes(file, bytes);
        } else {
            FileManager.writeRawBytes(file, bytes);
        }
    }

    public static String writeTempDexFile(byte[] bytes) {
        File file = FileManager.getTempDexFile();
        if (file != null) {
            FileManager.writeRawBytes(file, bytes);
            return file.getPath();
        }
        Log.e((String)"InstantRun", (String)"No file to write temp dex content to");
        return null;
    }

    public static void purgeTempDexFiles(File dataFolder) {
        havePurgedTempDexFolder = true;
        File dexFolder = FileManager.getTempDexFileFolder(dataFolder);
        if (!dexFolder.isDirectory()) {
            return;
        }
        File[] files = dexFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            boolean deleted;
            if (!file.getPath().endsWith(CLASSES_DEX_SUFFIX) || (deleted = file.delete())) continue;
            Log.e((String)"InstantRun", (String)("Could not delete temp dex file " + file));
        }
    }

    public static long getFileSize(String path) {
        return -1L;
    }

    public static byte[] getCheckSum(String path) {
        return null;
    }

    public static byte[] getCheckSum(File file) {
        return null;
    }
}

