/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sound {
    private AudioFormat format;
    private byte[] samples;

    public Sound(URL filename) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(filename);
            this.format = stream.getFormat();
            this.samples = this.getSamples(stream);
        }
        catch (UnsupportedAudioFileException ex) {
            System.out.println(ex);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public byte[] getSamples() {
        return this.samples;
    }

    private byte[] getSamples(AudioInputStream audioStream) {
        int length = (int)(audioStream.getFrameLength() * (long)this.format.getFrameSize());
        byte[] samples = new byte[length];
        DataInputStream is = new DataInputStream(audioStream);
        try {
            is.readFully(samples);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        return samples;
    }

    public void play(InputStream source) {
        SourceDataLine line;
        int bufferSize = this.format.getFrameSize() * Math.round(this.format.getSampleRate() / 10.0f);
        byte[] buffer = new byte[bufferSize];
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(this.format, bufferSize);
        }
        catch (LineUnavailableException ex) {
            System.out.println(ex);
            return;
        }
        line.start();
        try {
            int numBytesRead = 0;
            while (numBytesRead != -1) {
                numBytesRead = source.read(buffer, 0, buffer.length);
                if (numBytesRead == -1) continue;
                line.write(buffer, 0, numBytesRead);
            }
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
        line.drain();
        line.close();
    }
}

