/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Sound;
import game.Tile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MainFrame
extends JFrame
implements ActionListener {
    Tile[] tiles = new Tile[36];
    ImageIcon[] icons = new ImageIcon[18];
    int status;
    int score;
    Tile predict1;
    Tile predict2;
    private boolean won;
    private boolean helping;
    private JLabel close;
    private JPanel controlPanel;
    private JPanel gamePanel;
    private JLabel help;
    private JButton load;
    private JButton play;
    private JTextField title;
    private JPanel titlePanel;

    public MainFrame() {
        this.initComponents();
        this.initIcons();
        this.initGame();
    }

    private void initGame() {
        this.score = 0;
        int x = 0;
        for (int i = 0; i < this.tiles.length; ++i) {
            this.tiles[i] = new Tile(this.icons[x], new ImageIcon(this.getClass().getResource("/images/logo.png")));
            this.tiles[i].addActionListener(this);
            this.gamePanel.add(this.tiles[i]);
            if ((i + 1) % 2 != 0) continue;
            ++x;
        }
        this.title.setText("Score: " + this.score);
        this.shuffle();
    }

    private void initIcons() {
        for (int i = 0; i < this.icons.length; ++i) {
            Image img = new ImageIcon(this.getClass().getResource("/images/img" + i + ".png")).getImage();
            this.icons[i] = this.createIcon(img);
        }
    }

    private ImageIcon createIcon(Image img) {
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        bi.createGraphics().drawImage(img, 0, 0, null);
        img = bi.getScaledInstance(80, 80, 1);
        return new ImageIcon(img);
    }

    private void showHelp() {
        if (this.tiles[0] != null) {
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i].isNoIcon()) continue;
                this.tiles[i].showTile();
                this.tiles[i].removeActionListener(this);
            }
            this.score -= 50;
            this.title.setText("Score: " + this.score);
        }
    }

    private void hideHelp() {
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i].isNoIcon()) continue;
            this.tiles[i].hideTile();
            this.tiles[i].addActionListener(this);
        }
    }

    private void check() {
        if (this.predict1 != this.predict2 && this.predict1.getImage() == this.predict2.getImage()) {
            new Thread(){

                @Override
                public void run() {
                    Sound sound = null;
                    try {
                        sound = new Sound(this.getClass().getResource("/sounds/guess.wav"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ByteArrayInputStream stream = new ByteArrayInputStream(sound.getSamples());
                    sound.play(stream);
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        try {
                            MainFrame.this.predict1.hideTile();
                            MainFrame.this.predict2.hideTile();
                            Thread.sleep(100L);
                            MainFrame.this.predict1.showTile();
                            MainFrame.this.predict2.showTile();
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            System.out.println(ex);
                        }
                    }
                    MainFrame.this.predict1.setNoIcon();
                    MainFrame.this.predict2.setNoIcon();
                    for (i = 0; i < MainFrame.this.tiles.length; ++i) {
                        if (!MainFrame.this.tiles[i].isNoIcon()) {
                            MainFrame.this.won = false;
                            break;
                        }
                        MainFrame.this.won = true;
                    }
                    if (MainFrame.this.won) {
                        if (MainFrame.this.score > 0) {
                            new Thread(){

                                @Override
                                public void run() {
                                    Sound sound = null;
                                    try {
                                        sound = new Sound(this.getClass().getResource("/sounds/won.wav"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ByteArrayInputStream stream = new ByteArrayInputStream(sound.getSamples());
                                    sound.play(stream);
                                }
                            }.start();
                            JOptionPane.showMessageDialog(MainFrame.this.gamePanel, "You Won! Your Score is " + MainFrame.this.score);
                        } else {
                            new Thread(){

                                @Override
                                public void run() {
                                    Sound sound = null;
                                    try {
                                        sound = new Sound(this.getClass().getResource("/sounds/loose.wav"));
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ByteArrayInputStream stream = new ByteArrayInputStream(sound.getSamples());
                                    sound.play(stream);
                                }
                            }.start();
                            JOptionPane.showMessageDialog(MainFrame.this.gamePanel, "You Loose! Your Score is " + MainFrame.this.score);
                        }
                        MainFrame.this.initGame();
                    }
                }
            }.start();
            this.predict1.removeActionListener(this);
            this.predict2.removeActionListener(this);
            this.score += 100;
            this.title.setText("Score: " + this.score);
        } else {
            this.predict1.hideTile();
            this.predict2.hideTile();
            this.score -= 10;
            this.title.setText("Score: " + this.score);
        }
    }

    private void shuffle() {
        this.gamePanel.removeAll();
        ArrayList<Integer> al = new ArrayList<Integer>();
        int i = 0;
        while (i < 36) {
            int x = (int)(Math.random() * 36.0);
            if (al.contains(x)) continue;
            al.add(x);
            ++i;
        }
        for (i = 0; i < 36; ++i) {
            this.gamePanel.add(this.tiles[(Integer)al.get(i)]);
            this.tiles[(Integer)al.get(i)].hideTile();
        }
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.title = new JTextField();
        this.close = new JLabel();
        this.help = new JLabel();
        this.gamePanel = new JPanel();
        this.controlPanel = new JPanel();
        this.play = new JButton();
        this.load = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Matching Game");
        this.setBackground(new Color(204, 204, 255));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/images/logo.png")).getImage());
        this.setLocationByPlatform(true);
        this.setName("MainFrame");
        this.setUndecorated(true);
        this.titlePanel.setBackground(new Color(153, 0, 153));
        this.titlePanel.setPreferredSize(new Dimension(300, 25));
        this.titlePanel.setLayout(new BorderLayout());
        this.title.setEditable(false);
        this.title.setBackground(new Color(153, 153, 255));
        this.title.setFont(new Font("Tahoma", 1, 11));
        this.title.setForeground(new Color(255, 255, 255));
        this.title.setHorizontalAlignment(0);
        this.title.setText("Score: ");
        this.title.setToolTipText("After Clicking mouse here use arrow keys to move");
        this.title.setBorder(null);
        this.title.setCursor(new Cursor(13));
        this.title.setSelectionColor(new Color(153, 153, 255));
        this.title.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                MainFrame.this.titleMouseDragged(evt);
            }
        });
        this.title.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainFrame.this.titleKeyPressed(evt);
            }
        });
        this.titlePanel.add((Component)this.title, "Center");
        this.close.setBackground(new Color(0, 153, 153));
        this.close.setFont(new Font("Tahoma", 1, 14));
        this.close.setForeground(new Color(255, 255, 255));
        this.close.setHorizontalAlignment(0);
        this.close.setText("X");
        this.close.setToolTipText("Close");
        this.close.setCursor(new Cursor(12));
        this.close.setPreferredSize(new Dimension(25, 25));
        this.close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.closeMouseClicked(evt);
            }
        });
        this.titlePanel.add((Component)this.close, "After");
        this.help.setFont(new Font("Tahoma", 1, 18));
        this.help.setForeground(new Color(255, 255, 255));
        this.help.setHorizontalAlignment(0);
        this.help.setText("?");
        this.help.setToolTipText("Right click to hide controls and Left click to see Images");
        this.help.setCursor(new Cursor(12));
        this.help.setPreferredSize(new Dimension(25, 25));
        this.help.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.helpMouseClicked(evt);
            }
        });
        this.titlePanel.add((Component)this.help, "Before");
        this.getContentPane().add((Component)this.titlePanel, "North");
        this.gamePanel.setBackground(new Color(153, 0, 153));
        this.gamePanel.setPreferredSize(new Dimension(630, 630));
        this.gamePanel.setLayout(new GridLayout(6, 6, 5, 5));
        this.getContentPane().add((Component)this.gamePanel, "Center");
        this.controlPanel.setBackground(new Color(153, 153, 255));
        this.controlPanel.setPreferredSize(new Dimension(300, 40));
        this.controlPanel.setLayout(new GridLayout(1, 2));
        this.play.setBackground(new Color(153, 0, 153));
        this.play.setFont(new Font("Tahoma", 0, 18));
        this.play.setForeground(new Color(153, 153, 255));
        this.play.setText("PLAY");
        this.play.setToolTipText("Play new Game");
        this.play.setCursor(new Cursor(12));
        this.play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.playActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.play);
        this.load.setBackground(new Color(153, 0, 153));
        this.load.setFont(new Font("Tahoma", 0, 18));
        this.load.setForeground(new Color(153, 153, 255));
        this.load.setText("LOAD");
        this.load.setToolTipText("Load your favourite images");
        this.load.setCursor(new Cursor(12));
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.loadActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.load);
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.pack();
    }

    private void closeMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.dispose();
        }
    }

    private void helpMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && !this.helping) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        MainFrame.this.helping = true;
                        MainFrame.this.showHelp();
                        Thread.sleep(10000L);
                        MainFrame.this.hideHelp();
                        MainFrame.this.helping = false;
                    }
                    catch (InterruptedException ex) {
                        System.out.println(ex);
                    }
                }
            }.start();
        }
        if (evt.getButton() == 3) {
            if (this.controlPanel.isVisible()) {
                this.setSize(600, 625);
                this.controlPanel.setVisible(false);
            } else {
                this.setSize(600, 665);
                this.controlPanel.setVisible(true);
            }
        }
    }

    private void titleKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 37) {
            this.setLocation(this.getX() - 5, this.getY());
        }
        if (evt.getKeyCode() == 39) {
            this.setLocation(this.getX() + 5, this.getY());
        }
        if (evt.getKeyCode() == 38) {
            this.setLocation(this.getX(), this.getY() - 5);
        }
        if (evt.getKeyCode() == 40) {
            this.setLocation(this.getX(), this.getY() + 5);
        }
    }

    private void loadActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int response = chooser.showOpenDialog(this.predict1);
        if (response == 0) {
            File[] file = chooser.getSelectedFiles();
            if (file.length >= 18) {
                for (int i = 0; i < 18; ++i) {
                    this.icons[i] = this.createIcon(new ImageIcon(file[i].toString()).getImage());
                }
                this.initGame();
            } else {
                JOptionPane.showMessageDialog(this.gamePanel, "Please select 18 Files !");
            }
        }
    }

    private void playActionPerformed(ActionEvent evt) {
        this.initGame();
    }

    private void titleMouseDragged(MouseEvent evt) {
        this.setLocation(evt.getXOnScreen() - 300, evt.getYOnScreen());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.status == 0) {
            this.predict1 = (Tile)e.getSource();
            this.predict1.showTile();
            ++this.status;
        } else if (this.status == 1) {
            ++this.status;
            this.predict2 = (Tile)e.getSource();
            new Thread(){

                @Override
                public void run() {
                    try {
                        MainFrame.this.predict2.showTile();
                        Thread.sleep(500L);
                        MainFrame.this.check();
                        Thread.sleep(600L);
                        MainFrame.this.status = 0;
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
            }.start();
        }
    }
}

