/*
 * Decompiled with CFR 0.152.
 */
package passwordlocker;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import passwordlocker.Control;
import passwordlocker.Log;
import passwordlocker.MainForm;
import passwordlocker.NewUserForm;
import passwordlocker.User;

public class LoginForm
extends JFrame
implements ActionListener,
MouseListener {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton loginB;
    private JLabel newUserL;
    private JPasswordField passwordPF;
    private JTextField usernameTF;

    public LoginForm() {
        this.initComponents();
        this.loginB.addActionListener(this);
        this.newUserL.addMouseListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.usernameTF = new JTextField();
        this.jLabel2 = new JLabel();
        this.passwordPF = new JPasswordField();
        this.loginB = new JButton();
        this.newUserL = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("PasswordLocker Login");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/passwordlocker.png")).getImage());
        this.setResizable(false);
        this.jLabel1.setText("Username:");
        this.jLabel2.setText("Password:");
        this.loginB.setText("Unlock");
        this.newUserL.setForeground(new Color(51, 51, 255));
        this.newUserL.setText("New User");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.newUserL).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.loginB)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameTF, -2, 173, -2).addComponent(this.passwordPF, -2, 173, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.usernameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.passwordPF, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newUserL).addComponent(this.loginB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String user = this.usernameTF.getText();
        String pass = this.passwordPF.getText();
        int i = 0;
        ArrayList<User> users = Control.getUsers();
        if (i < users.size()) {
            if (users.get(i).getUsername().equals(user.trim()) && users.get(i).getPassword().equals(pass.trim())) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                String date = cal.get(5) + " " + cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + cal.get(1);
                String time = cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
                Control.addLog(new Log(user, date, time, "Login"));
                String lld = users.get(i).getLastLoginDate();
                String llt = users.get(i).getLastLoginTime();
                Control.updateUser(new User(users.get(i).getName(), users.get(i).getUsername(), users.get(i).getPassword(), date, time, users.get(i).getFilePath()));
                this.dispose();
                new MainForm(users.get(i), lld, llt).setVisible(true);
                return;
            }
            JOptionPane.showMessageDialog(this, "Username or Password is incorrect!");
            return;
        }
        JOptionPane.showMessageDialog(this, "No User created yet!");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NewUserForm().setVisible(true);
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

