/*
 * Decompiled with CFR 0.152.
 */
package passwordlocker;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import passwordlocker.Control;
import passwordlocker.Log;
import passwordlocker.LogForm;
import passwordlocker.MyPassword;
import passwordlocker.Settings;
import passwordlocker.User;

public class MainForm
extends JFrame
implements ActionListener,
ListSelectionListener {
    User user;
    Calendar cal = Calendar.getInstance();
    ArrayList<MyPassword> mypasswords;
    private JButton addNewPassB;
    private JPanel bottomContainer;
    private JLabel cdL;
    private JTextField createDateTimeTF;
    private JLabel ctL;
    private JButton deletePassB;
    private JList descriptionList;
    private JTextField descriptionTF;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JScrollPane jScrollPane2;
    private JTextField lastUpdateDateTimeTF;
    private JLabel lldL;
    private JLabel lltL;
    private JPanel mainContainer;
    private JLabel nameL;
    private JPasswordField passwordF;
    private JButton settingsB;
    private JButton showPasswordB;
    private JTextField showPasswordTF;
    private JPanel topContainer;
    private JButton updatePassB;
    private JTextField usernameTF;
    private JButton viewLogB;

    public MainForm(User user, String lld, String llt) {
        this.initComponents();
        this.user = user;
        this.lldL.setText(lld);
        this.lltL.setText(llt);
        this.nameL.setText(user.getName());
        this.refreshDescriptionList();
        this.addListeners();
        this.startTimer();
        this.descriptionList.setSelectedIndex(0);
    }

    final void refreshDescriptionList() {
        this.mypasswords = Control.getMyPasswords(this.user.getFilePath());
        String[] descriptions = new String[this.mypasswords.size()];
        for (int i = 0; i < this.mypasswords.size(); ++i) {
            descriptions[i] = new String();
            descriptions[i] = this.mypasswords.get(i).getDescription();
        }
        this.descriptionList.removeAll();
        this.descriptionList.setListData(descriptions);
    }

    final void addListeners() {
        this.viewLogB.addActionListener(this);
        this.addNewPassB.addActionListener(this);
        this.deletePassB.addActionListener(this);
        this.updatePassB.addActionListener(this);
        this.showPasswordB.addActionListener(this);
        this.descriptionList.addListSelectionListener(this);
        this.settingsB.addActionListener(this);
    }

    final void startTimer() {
        new Thread(){

            @Override
            public void run() {
                while (this.isAlive()) {
                    MainForm.this.cal.setTimeInMillis(System.currentTimeMillis());
                    String date = MainForm.this.cal.get(5) + " " + MainForm.this.cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + MainForm.this.cal.get(1);
                    String time = MainForm.this.cal.get(11) + ":" + MainForm.this.cal.get(12) + ":" + MainForm.this.cal.get(13);
                    MainForm.this.cdL.setText(date);
                    MainForm.this.ctL.setText(time);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }.start();
    }

    private void initComponents() {
        this.mainContainer = new JPanel();
        this.bottomContainer = new JPanel();
        this.showPasswordTF = new JTextField();
        this.showPasswordB = new JButton();
        this.jLabel5 = new JLabel();
        this.updatePassB = new JButton();
        this.jLabel1 = new JLabel();
        this.addNewPassB = new JButton();
        this.passwordF = new JPasswordField();
        this.usernameTF = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionList = new JList();
        this.jLabel3 = new JLabel();
        this.deletePassB = new JButton();
        this.jLabel2 = new JLabel();
        this.descriptionTF = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.createDateTimeTF = new JTextField();
        this.lastUpdateDateTimeTF = new JTextField();
        this.topContainer = new JPanel();
        this.lltL = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel8 = new JLabel();
        this.ctL = new JLabel();
        this.cdL = new JLabel();
        this.nameL = new JLabel();
        this.lldL = new JLabel();
        this.jLabel6 = new JLabel();
        this.viewLogB = new JButton();
        this.settingsB = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("Password Locker");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/passwordlocker.png")).getImage());
        this.setResizable(false);
        this.bottomContainer.setBackground(new Color(255, 255, 255));
        this.showPasswordTF.setEditable(false);
        this.showPasswordB.setText("Show Passwod");
        this.jLabel5.setText("Show Password:");
        this.updatePassB.setText("Update");
        this.updatePassB.setToolTipText("Update Selected Description");
        this.jLabel1.setText("Descriptions:");
        this.jLabel1.setToolTipText("Select Below Description to know password");
        this.addNewPassB.setText("Add New");
        this.jScrollPane2.setViewportView(this.descriptionList);
        this.jLabel3.setText("Password:");
        this.deletePassB.setText("Delete");
        this.deletePassB.setToolTipText("Delete Selected Description");
        this.jLabel2.setText("Username:");
        this.jLabel4.setText("Description:");
        this.jLabel13.setText("Create Date/Time:");
        this.jLabel14.setText("Last Update Date/Time:");
        this.createDateTimeTF.setEditable(false);
        this.lastUpdateDateTimeTF.setEditable(false);
        GroupLayout bottomContainerLayout = new GroupLayout(this.bottomContainer);
        this.bottomContainer.setLayout(bottomContainerLayout);
        bottomContainerLayout.setHorizontalGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomContainerLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addGroup(bottomContainerLayout.createSequentialGroup().addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomContainerLayout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 252, -2).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel13).addComponent(this.jLabel14))).addGroup(bottomContainerLayout.createSequentialGroup().addComponent(this.addNewPassB).addGap(18, 18, 18).addComponent(this.deletePassB).addGap(18, 18, 18).addComponent(this.updatePassB))).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionTF, -2, 200, -2).addComponent(this.usernameTF, -2, 150, -2).addComponent(this.passwordF, -2, 150, -2).addComponent(this.showPasswordB).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lastUpdateDateTimeTF, GroupLayout.Alignment.LEADING, -1, 150, Short.MAX_VALUE).addComponent(this.createDateTimeTF, GroupLayout.Alignment.LEADING).addComponent(this.showPasswordTF, GroupLayout.Alignment.LEADING))))).addContainerGap(16, Short.MAX_VALUE)));
        bottomContainerLayout.setVerticalGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomContainerLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomContainerLayout.createSequentialGroup().addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.descriptionTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.usernameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.passwordF, -2, -1, -2)).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showPasswordTF, -2, -1, -2).addComponent(this.jLabel5)).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.createDateTimeTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.lastUpdateDateTimeTF, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.showPasswordB)).addComponent(this.jScrollPane2, -2, 278, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(bottomContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addNewPassB).addComponent(this.deletePassB).addComponent(this.updatePassB)).addContainerGap()));
        this.topContainer.setBackground(new Color(153, 0, 255));
        this.lltL.setFont(new Font("Tahoma", 1, 11));
        this.lltL.setText("10:12");
        this.lltL.setToolTipText("Last login time");
        this.jLabel11.setText("Welcome,");
        this.jLabel8.setText("Your last login:");
        this.ctL.setFont(new Font("Tahoma", 2, 11));
        this.ctL.setText("14:11:22");
        this.cdL.setFont(new Font("Tahoma", 2, 11));
        this.cdL.setText("12 Dec, 2013");
        this.nameL.setFont(new Font("Tahoma", 1, 11));
        this.nameL.setText("Rajesh Kumar");
        this.lldL.setFont(new Font("Tahoma", 1, 11));
        this.lldL.setText("11 Dec, 2013");
        this.lldL.setToolTipText("Last login date");
        this.jLabel6.setText("Current Login:");
        this.viewLogB.setBackground(new Color(0, 102, 102));
        this.viewLogB.setFont(new Font("Tahoma", 1, 11));
        this.viewLogB.setForeground(new Color(204, 204, 255));
        this.viewLogB.setText("View Log");
        this.viewLogB.setBorder(null);
        this.viewLogB.setContentAreaFilled(false);
        this.viewLogB.setCursor(new Cursor(12));
        this.settingsB.setBackground(new Color(0, 102, 102));
        this.settingsB.setFont(new Font("Tahoma", 1, 11));
        this.settingsB.setForeground(new Color(204, 204, 255));
        this.settingsB.setText("Settings");
        this.settingsB.setToolTipText("Show Settings");
        this.settingsB.setContentAreaFilled(false);
        GroupLayout topContainerLayout = new GroupLayout(this.topContainer);
        this.topContainer.setLayout(topContainerLayout);
        topContainerLayout.setHorizontalGroup(topContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topContainerLayout.createSequentialGroup().addContainerGap().addGroup(topContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topContainerLayout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.nameL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cdL, -2, 74, -2)).addGroup(topContainerLayout.createSequentialGroup().addComponent(this.jLabel8).addGap(14, 14, 14).addComponent(this.lldL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lltL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.settingsB))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(topContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ctL, -2, 52, -2).addComponent(this.viewLogB)).addGap(21, 21, 21)));
        topContainerLayout.setVerticalGroup(topContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topContainerLayout.createSequentialGroup().addContainerGap().addGroup(topContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cdL).addComponent(this.ctL).addComponent(this.jLabel11).addComponent(this.nameL).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(topContainerLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.lldL).addComponent(this.lltL).addComponent(this.viewLogB).addComponent(this.settingsB)).addContainerGap()));
        GroupLayout mainContainerLayout = new GroupLayout(this.mainContainer);
        this.mainContainer.setLayout(mainContainerLayout);
        mainContainerLayout.setHorizontalGroup(mainContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainContainerLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(mainContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bottomContainer, -1, -1, Short.MAX_VALUE).addComponent(this.topContainer, -1, -1, Short.MAX_VALUE))));
        mainContainerLayout.setVerticalGroup(mainContainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainContainerLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.topContainer, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.bottomContainer, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.mainContainer, -2, -1, -2).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainContainer, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String time;
        String date;
        String desc;
        if (e.getSource() == this.viewLogB) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new LogForm(MainForm.this.user.getUsername()).setVisible(true);
                }
            });
        }
        if (e.getSource() == this.showPasswordB) {
            if (this.showPasswordTF.getText().equals("")) {
                this.showPasswordTF.setText(this.passwordF.getText());
                this.showPasswordB.setText("Hide Password");
            } else {
                this.showPasswordTF.setText("");
                this.showPasswordB.setText("Show Password");
            }
        }
        if (e.getSource() == this.addNewPassB) {
            if (this.addNewPassB.getText().equals("Add New")) {
                this.descriptionTF.setText("");
                this.usernameTF.setText("");
                this.passwordF.setText("");
                this.showPasswordTF.setText("");
                this.createDateTimeTF.setText("");
                this.lastUpdateDateTimeTF.setText("");
                this.addNewPassB.setText("Save");
            } else if (this.addNewPassB.getText().equals("Save")) {
                if (!(this.descriptionTF.getText().trim().equals("") || this.usernameTF.getText().trim().equals("") || this.passwordF.getText().trim().equals(""))) {
                    String username = this.usernameTF.getText().trim();
                    String password = this.passwordF.getText().trim();
                    String description = this.descriptionTF.getText().trim();
                    this.cal.setTimeInMillis(System.currentTimeMillis());
                    String date2 = this.cal.get(5) + " " + this.cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + this.cal.get(1);
                    String time2 = this.cal.get(11) + ":" + this.cal.get(12) + ":" + this.cal.get(13);
                    Control.addMyPassword(new MyPassword(this.descriptionList.getModel().getSize(), username, password, description, date2, time2, date2, time2), this.user.getFilePath());
                    Control.addLog(new Log(this.user.getUsername(), date2, time2, description + " Password Added"));
                    this.addNewPassB.setText("Add New");
                    this.refreshDescriptionList();
                } else {
                    JOptionPane.showMessageDialog(this, "Please fill username,password and description");
                }
            }
        }
        if (e.getSource() == this.deletePassB) {
            if (this.descriptionList.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select description from list first!");
            } else {
                desc = (String)this.descriptionList.getSelectedValue();
                for (int i = 0; i < this.mypasswords.size(); ++i) {
                    if (!this.mypasswords.get(i).getDescription().equals(desc) || !(this.mypasswords.get(i).getCreateDate() + " " + this.mypasswords.get(i).getCreateTime()).equals(this.createDateTimeTF.getText())) continue;
                    Control.deleteMyPassword(this.mypasswords.get(i), this.user.getFilePath());
                    this.cal.setTimeInMillis(System.currentTimeMillis());
                    date = this.cal.get(5) + " " + this.cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + this.cal.get(1);
                    time = this.cal.get(11) + ":" + this.cal.get(12) + ":" + this.cal.get(13);
                    Control.addLog(new Log(this.user.getUsername(), date, time, desc + " Password Deleted"));
                    this.refreshDescriptionList();
                    break;
                }
            }
        }
        if (e.getSource() == this.updatePassB) {
            if (this.descriptionList.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select description from list first!");
            } else {
                desc = (String)this.descriptionList.getSelectedValue();
                for (int i = 0; i < this.mypasswords.size(); ++i) {
                    if (!this.mypasswords.get(i).getDescription().equals(desc) || !(this.mypasswords.get(i).getCreateDate() + " " + this.mypasswords.get(i).getCreateTime()).equals(this.createDateTimeTF.getText())) continue;
                    this.cal.setTimeInMillis(System.currentTimeMillis());
                    date = this.cal.get(5) + " " + this.cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + this.cal.get(1);
                    time = this.cal.get(11) + ":" + this.cal.get(12) + ":" + this.cal.get(13);
                    MyPassword mypassword = new MyPassword(this.descriptionList.getModel().getSize(), this.usernameTF.getText(), this.passwordF.getText(), this.descriptionTF.getText(), null, null, date, time);
                    Control.updateMyPassword(this.mypasswords.get(i), mypassword, this.user.getFilePath());
                    Control.addLog(new Log(this.user.getUsername(), date, time, desc + " Detail Updated"));
                    JOptionPane.showMessageDialog(this, "Updated successfully!");
                    this.refreshDescriptionList();
                    break;
                }
            }
        }
        if (e.getSource() == this.settingsB) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Settings(MainForm.this.user).setVisible(true);
                }
            });
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int si = this.descriptionList.getSelectedIndex();
        for (int i = 0; i < this.mypasswords.size(); ++i) {
            if (this.mypasswords.get(i).getId() != si) continue;
            this.descriptionTF.setText(this.mypasswords.get(i).getDescription());
            this.usernameTF.setText(this.mypasswords.get(i).getUsername());
            this.passwordF.setText(this.mypasswords.get(i).getPassword());
            this.createDateTimeTF.setText(this.mypasswords.get(i).getCreateDate() + " " + this.mypasswords.get(i).getCreateTime());
            this.lastUpdateDateTimeTF.setText(this.mypasswords.get(i).getLastChangeDate() + " " + this.mypasswords.get(i).getLastChangeTime());
            break;
        }
    }
}

