/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package passwordlocker;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.ImageIcon;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author Rajesh
 */
public class MainForm extends javax.swing.JFrame implements ActionListener, ListSelectionListener {

    User user;
    Calendar cal = Calendar.getInstance();
    ArrayList<MyPassword> mypasswords;

    /**
     * Creates new form MainForm
     */
    public MainForm(User user, String lld, String llt) {
        initComponents();
        this.user = user;
        lldL.setText(lld);
        lltL.setText(llt);
        nameL.setText(user.getName());
        refreshDescriptionList();
        addListeners();
        startTimer();
        descriptionList.setSelectedIndex(0);

    }

    final void refreshDescriptionList() {
        mypasswords = Control.getMyPasswords(user.getFilePath());
        String[] descriptions = new String[mypasswords.size()];
        for (int i = 0; i < mypasswords.size(); i++) {
            descriptions[i] = new String();
            descriptions[i] = mypasswords.get(i).getDescription();
        }
        descriptionList.removeAll();
        descriptionList.setListData(descriptions);
    }

    final void addListeners() {
        viewLogB.addActionListener(this);
        addNewPassB.addActionListener(this);
        deletePassB.addActionListener(this);
        updatePassB.addActionListener(this);
        showPasswordB.addActionListener(this);
        descriptionList.addListSelectionListener(this);
        settingsB.addActionListener(this);
    }

    final void startTimer() {
        new Thread() {
            @Override
            public void run() {
                while (this.isAlive()) {
                    cal.setTimeInMillis(System.currentTimeMillis());
                    String date = cal.get(Calendar.DAY_OF_MONTH) + " " + cal.getDisplayName(Calendar.MONTH, Calendar.SHORT, Locale.ENGLISH) + ", " + cal.get(Calendar.YEAR);
                    String time = cal.get(Calendar.HOUR_OF_DAY) + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);
                    cdL.setText(date);
                    ctL.setText(time);
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException ex) {
                        Logger.getLogger(MainForm.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }.start();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainContainer = new javax.swing.JPanel();
        bottomContainer = new javax.swing.JPanel();
        showPasswordTF = new javax.swing.JTextField();
        showPasswordB = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        updatePassB = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        addNewPassB = new javax.swing.JButton();
        passwordF = new javax.swing.JPasswordField();
        usernameTF = new javax.swing.JTextField();
        jScrollPane2 = new javax.swing.JScrollPane();
        descriptionList = new javax.swing.JList();
        jLabel3 = new javax.swing.JLabel();
        deletePassB = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        descriptionTF = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        createDateTimeTF = new javax.swing.JTextField();
        lastUpdateDateTimeTF = new javax.swing.JTextField();
        topContainer = new javax.swing.JPanel();
        lltL = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        ctL = new javax.swing.JLabel();
        cdL = new javax.swing.JLabel();
        nameL = new javax.swing.JLabel();
        lldL = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        viewLogB = new javax.swing.JButton();
        settingsB = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Password Locker");
        setIconImage(new ImageIcon(getClass().getResource("/img/passwordlocker.png")).getImage());
        setResizable(false);

        bottomContainer.setBackground(new java.awt.Color(255, 255, 255));

        showPasswordTF.setEditable(false);

        showPasswordB.setText("Show Passwod");

        jLabel5.setText("Show Password:");

        updatePassB.setText("Update");
        updatePassB.setToolTipText("Update Selected Description");

        jLabel1.setText("Descriptions:");
        jLabel1.setToolTipText("Select Below Description to know password");

        addNewPassB.setText("Add New");

        jScrollPane2.setViewportView(descriptionList);

        jLabel3.setText("Password:");

        deletePassB.setText("Delete");
        deletePassB.setToolTipText("Delete Selected Description");

        jLabel2.setText("Username:");

        jLabel4.setText("Description:");

        jLabel13.setText("Create Date/Time:");

        jLabel14.setText("Last Update Date/Time:");

        createDateTimeTF.setEditable(false);

        lastUpdateDateTimeTF.setEditable(false);

        javax.swing.GroupLayout bottomContainerLayout = new javax.swing.GroupLayout(bottomContainer);
        bottomContainer.setLayout(bottomContainerLayout);
        bottomContainerLayout.setHorizontalGroup(
            bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(bottomContainerLayout.createSequentialGroup()
                .addGap(15, 15, 15)
                .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addGroup(bottomContainerLayout.createSequentialGroup()
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(bottomContainerLayout.createSequentialGroup()
                                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 252, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(jLabel4)
                                    .addComponent(jLabel2)
                                    .addComponent(jLabel3)
                                    .addComponent(jLabel5)
                                    .addComponent(jLabel13)
                                    .addComponent(jLabel14)))
                            .addGroup(bottomContainerLayout.createSequentialGroup()
                                .addComponent(addNewPassB)
                                .addGap(18, 18, 18)
                                .addComponent(deletePassB)
                                .addGap(18, 18, 18)
                                .addComponent(updatePassB)))
                        .addGap(18, 18, 18)
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(descriptionTF, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(usernameTF, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(passwordF, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(showPasswordB)
                            .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(lastUpdateDateTimeTF, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 150, Short.MAX_VALUE)
                                .addComponent(createDateTimeTF, javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(showPasswordTF, javax.swing.GroupLayout.Alignment.LEADING)))))
                .addContainerGap(16, Short.MAX_VALUE))
        );
        bottomContainerLayout.setVerticalGroup(
            bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(bottomContainerLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(bottomContainerLayout.createSequentialGroup()
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel4)
                            .addComponent(descriptionTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel2)
                            .addComponent(usernameTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(passwordF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(showPasswordTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel5))
                        .addGap(18, 18, 18)
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel13)
                            .addComponent(createDateTimeTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel14)
                            .addComponent(lastUpdateDateTimeTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addComponent(showPasswordB))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 278, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(bottomContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(addNewPassB)
                    .addComponent(deletePassB)
                    .addComponent(updatePassB))
                .addContainerGap())
        );

        topContainer.setBackground(new java.awt.Color(153, 0, 255));

        lltL.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lltL.setText("10:12");
        lltL.setToolTipText("Last login time");

        jLabel11.setText("Welcome,");

        jLabel8.setText("Your last login:");

        ctL.setFont(new java.awt.Font("Tahoma", 2, 11)); // NOI18N
        ctL.setText("14:11:22");

        cdL.setFont(new java.awt.Font("Tahoma", 2, 11)); // NOI18N
        cdL.setText("12 Dec, 2013");

        nameL.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        nameL.setText("Rajesh Kumar");

        lldL.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        lldL.setText("11 Dec, 2013");
        lldL.setToolTipText("Last login date");

        jLabel6.setText("Current Login:");

        viewLogB.setBackground(new java.awt.Color(0, 102, 102));
        viewLogB.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        viewLogB.setForeground(new java.awt.Color(204, 204, 255));
        viewLogB.setText("View Log");
        viewLogB.setBorder(null);
        viewLogB.setContentAreaFilled(false);
        viewLogB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));

        settingsB.setBackground(new java.awt.Color(0, 102, 102));
        settingsB.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        settingsB.setForeground(new java.awt.Color(204, 204, 255));
        settingsB.setText("Settings");
        settingsB.setToolTipText("Show Settings");
        settingsB.setContentAreaFilled(false);

        javax.swing.GroupLayout topContainerLayout = new javax.swing.GroupLayout(topContainer);
        topContainer.setLayout(topContainerLayout);
        topContainerLayout.setHorizontalGroup(
            topContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(topContainerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(topContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(topContainerLayout.createSequentialGroup()
                        .addComponent(jLabel11)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(nameL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cdL, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(topContainerLayout.createSequentialGroup()
                        .addComponent(jLabel8)
                        .addGap(14, 14, 14)
                        .addComponent(lldL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(lltL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(settingsB)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(topContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(ctL, javax.swing.GroupLayout.PREFERRED_SIZE, 52, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(viewLogB))
                .addGap(21, 21, 21))
        );
        topContainerLayout.setVerticalGroup(
            topContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(topContainerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(topContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cdL)
                    .addComponent(ctL)
                    .addComponent(jLabel11)
                    .addComponent(nameL)
                    .addComponent(jLabel6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(topContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel8)
                    .addComponent(lldL)
                    .addComponent(lltL)
                    .addComponent(viewLogB)
                    .addComponent(settingsB))
                .addContainerGap())
        );

        javax.swing.GroupLayout mainContainerLayout = new javax.swing.GroupLayout(mainContainer);
        mainContainer.setLayout(mainContainerLayout);
        mainContainerLayout.setHorizontalGroup(
            mainContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainContainerLayout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addGroup(mainContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(bottomContainer, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(topContainer, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );
        mainContainerLayout.setVerticalGroup(
            mainContainerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainContainerLayout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addComponent(topContainer, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(0, 0, 0)
                .addComponent(bottomContainer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(mainContainer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, 0))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(mainContainer, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents
    /**
     * @param args the command line arguments
     */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addNewPassB;
    private javax.swing.JPanel bottomContainer;
    private javax.swing.JLabel cdL;
    private javax.swing.JTextField createDateTimeTF;
    private javax.swing.JLabel ctL;
    private javax.swing.JButton deletePassB;
    private javax.swing.JList descriptionList;
    private javax.swing.JTextField descriptionTF;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextField lastUpdateDateTimeTF;
    private javax.swing.JLabel lldL;
    private javax.swing.JLabel lltL;
    private javax.swing.JPanel mainContainer;
    private javax.swing.JLabel nameL;
    private javax.swing.JPasswordField passwordF;
    private javax.swing.JButton settingsB;
    private javax.swing.JButton showPasswordB;
    private javax.swing.JTextField showPasswordTF;
    private javax.swing.JPanel topContainer;
    private javax.swing.JButton updatePassB;
    private javax.swing.JTextField usernameTF;
    private javax.swing.JButton viewLogB;
    // End of variables declaration//GEN-END:variables

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == viewLogB) {
            EventQueue.invokeLater(new Runnable() {
                @Override
                public void run() {
                    new LogForm(user.getUsername()).setVisible(true);
                }
            });
        }

        if (e.getSource() == showPasswordB) {
            if (showPasswordTF.getText().equals("")) {
                showPasswordTF.setText(passwordF.getText());
                showPasswordB.setText("Hide Password");
            } else {
                showPasswordTF.setText("");
                showPasswordB.setText("Show Password");
            }
        }

        if (e.getSource() == addNewPassB) {
            if (addNewPassB.getText().equals("Add New")) {
                descriptionTF.setText("");
                usernameTF.setText("");
                passwordF.setText("");
                showPasswordTF.setText("");
                createDateTimeTF.setText("");
                lastUpdateDateTimeTF.setText("");
                addNewPassB.setText("Save");
            } else if (addNewPassB.getText().equals("Save")) {
                if (!descriptionTF.getText().trim().equals("") && !usernameTF.getText().trim().equals("") && !passwordF.getText().trim().equals("")) {
                    String username = usernameTF.getText().trim();
                    String password = passwordF.getText().trim();
                    String description = descriptionTF.getText().trim();
                    cal.setTimeInMillis(System.currentTimeMillis());
                    String date = cal.get(Calendar.DAY_OF_MONTH) + " " + cal.getDisplayName(Calendar.MONTH, Calendar.SHORT, Locale.ENGLISH) + ", " + cal.get(Calendar.YEAR);
                    String time = cal.get(Calendar.HOUR_OF_DAY) + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);
                    Control.addMyPassword(new MyPassword(descriptionList.getModel().getSize(), username, password, description, date, time, date, time), user.getFilePath());
                    Control.addLog(new Log(user.getUsername(), date, time, description + " Password Added"));
                    addNewPassB.setText("Add New");
                    refreshDescriptionList();
                } else {
                    JOptionPane.showMessageDialog(this, "Please fill username,password and description");
                }
            }

        }

        if (e.getSource() == deletePassB) {
            if (descriptionList.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select description from list first!");
            } else {
                String desc = (String) descriptionList.getSelectedValue();
                for (int i = 0; i < mypasswords.size(); i++) {
                    if (mypasswords.get(i).getDescription().equals(desc) && (mypasswords.get(i).getCreateDate() + " " + mypasswords.get(i).getCreateTime()).equals(createDateTimeTF.getText())) {
                        Control.deleteMyPassword(mypasswords.get(i), user.getFilePath());
                        cal.setTimeInMillis(System.currentTimeMillis());
                        String date = cal.get(Calendar.DAY_OF_MONTH) + " " + cal.getDisplayName(Calendar.MONTH, Calendar.SHORT, Locale.ENGLISH) + ", " + cal.get(Calendar.YEAR);
                        String time = cal.get(Calendar.HOUR_OF_DAY) + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);
                        Control.addLog(new Log(user.getUsername(), date, time, desc + " Password Deleted"));
                        refreshDescriptionList();
                        break;
                    }
                }
            }
        }

        if (e.getSource() == updatePassB) {
            if (descriptionList.isSelectionEmpty()) {
                JOptionPane.showMessageDialog(this, "Please select description from list first!");
            } else {
                String desc = (String) descriptionList.getSelectedValue();
                for (int i = 0; i < mypasswords.size(); i++) {
                    if (mypasswords.get(i).getDescription().equals(desc) && (mypasswords.get(i).getCreateDate() + " " + mypasswords.get(i).getCreateTime()).equals(createDateTimeTF.getText())) {
                        cal.setTimeInMillis(System.currentTimeMillis());
                        String date = cal.get(Calendar.DAY_OF_MONTH) + " " + cal.getDisplayName(Calendar.MONTH, Calendar.SHORT, Locale.ENGLISH) + ", " + cal.get(Calendar.YEAR);
                        String time = cal.get(Calendar.HOUR_OF_DAY) + ":" + cal.get(Calendar.MINUTE) + ":" + cal.get(Calendar.SECOND);
                        MyPassword mypassword = new MyPassword(descriptionList.getModel().getSize(),usernameTF.getText(), passwordF.getText(), descriptionTF.getText(), null, null, date, time);
                        Control.updateMyPassword(mypasswords.get(i), mypassword, user.getFilePath());
                        Control.addLog(new Log(user.getUsername(), date, time, desc + " Detail Updated"));
                        JOptionPane.showMessageDialog(this, "Updated successfully!");
                        refreshDescriptionList();
                        break;
                    }
                }
            }
        }

        if (e.getSource() == settingsB) {
            EventQueue.invokeLater(new Runnable() {
                @Override
                public void run() {
                    new Settings(user).setVisible(true);
                }
            });
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int si = descriptionList.getSelectedIndex();
        for (int i = 0; i < mypasswords.size(); i++) {
            if (mypasswords.get(i).getId() == si) {
                descriptionTF.setText(mypasswords.get(i).getDescription());
                usernameTF.setText(mypasswords.get(i).getUsername());
                passwordF.setText(mypasswords.get(i).getPassword());
                createDateTimeTF.setText(mypasswords.get(i).getCreateDate() + " " + mypasswords.get(i).getCreateTime());
                lastUpdateDateTimeTF.setText(mypasswords.get(i).getLastChangeDate() + " " + mypasswords.get(i).getLastChangeTime());
                break;
            }
        }
    }
}
