/*
 * Decompiled with CFR 0.152.
 */
package passwordlocker;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import passwordlocker.Control;
import passwordlocker.Log;

public class LogForm
extends JFrame
implements KeyListener {
    ArrayList<Log> userlogs;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable logTable;
    private JTextField searchTF;

    public LogForm(String username) {
        this.initComponents();
        this.initLogTable(username);
        this.searchTF.addKeyListener(this);
    }

    final void initLogTable(String username) {
        this.userlogs = Control.getLogs(username);
        TableModel tm = this.getCustomModel(this.logTable.getModel(), this.userlogs.size());
        for (int i = 0; i < this.userlogs.size(); ++i) {
            tm.setValueAt(this.userlogs.get(i).getDate(), i, 0);
            tm.setValueAt(this.userlogs.get(i).getTime(), i, 1);
            tm.setValueAt(this.userlogs.get(i).getDescription(), i, 2);
        }
        this.logTable.setModel(tm);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.logTable = new JTable();
        this.jLabel1 = new JLabel();
        this.searchTF = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Log");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/passwordlocker.png")).getImage());
        this.setResizable(false);
        this.logTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Date", "Time", "Description"}));
        this.jScrollPane1.setViewportView(this.logTable);
        this.jLabel1.setText("Search:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 580, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchTF, -2, 200, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.searchTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 328, Short.MAX_VALUE)));
        this.pack();
    }

    public TableModel getCustomModel(TableModel tm, int row) {
        Object[] columns = new String[tm.getColumnCount()];
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            columns[i] = tm.getColumnName(i);
        }
        DefaultTableModel dtm = new DefaultTableModel(columns, row);
        return dtm;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        String searchvalue = this.searchTF.getText();
        ArrayList<Object> logs = new ArrayList();
        if (!searchvalue.equals("")) {
            for (int i = 0; i < this.userlogs.size(); ++i) {
                if (!this.userlogs.get(i).getDate().contains(searchvalue) && !this.userlogs.get(i).getTime().contains(searchvalue) && !this.userlogs.get(i).getDescription().contains(searchvalue)) continue;
                logs.add(this.userlogs.get(i));
            }
        } else {
            logs = this.userlogs;
        }
        TableModel tm = this.getCustomModel(this.logTable.getModel(), logs.size());
        for (int i = 0; i < logs.size(); ++i) {
            tm.setValueAt(((Log)logs.get(i)).getDate(), i, 0);
            tm.setValueAt(((Log)logs.get(i)).getTime(), i, 1);
            tm.setValueAt(((Log)logs.get(i)).getDescription(), i, 2);
        }
        this.logTable.setModel(tm);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

