/*
 * Decompiled with CFR 0.152.
 */
package passwordlocker;

import java.awt.HeadlessException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import passwordlocker.Log;
import passwordlocker.MyPassword;
import passwordlocker.User;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class Control {
    static ArrayList<User> users = new ArrayList();
    static ArrayList<MyPassword> mypasswords = new ArrayList();
    static ArrayList<Log> logs = new ArrayList();
    static DocumentBuilder db;
    static Document doc;
    static String path;

    public static void addUser(User user) {
        users.add(user);
        Control.storeUsers();
    }

    public static void updateUser(User user) {
        for (int i = 0; i < users.size(); ++i) {
            User usr = users.get(i);
            if (!usr.equals(user)) continue;
            usr.setName(user.getName());
            usr.setLastLoginDate(user.getLastLoginDate());
            usr.setLastLoginTime(user.getLastLoginTime());
            usr.setPassword(user.getPassword());
            usr.setFilePath(user.getFilePath());
        }
        Control.storeUsers();
    }

    public static ArrayList<User> getUsers() {
        return users;
    }

    public static void addLog(Log log) {
        logs.add(log);
        Control.storeLogs();
    }

    public static ArrayList<Log> getLogs(String username) {
        ArrayList<Log> userLogs = new ArrayList<Log>();
        for (int i = 0; i < logs.size(); ++i) {
            if (!logs.get(i).getUsername().equals(username)) continue;
            userLogs.add(logs.get(i));
        }
        return userLogs;
    }

    public static void addMyPassword(MyPassword mypassword, String path) {
        if (!mypasswords.contains(mypassword)) {
            mypasswords.add(mypassword);
            Control.storeMyPasswords(path);
        } else {
            JOptionPane.showMessageDialog(null, "Already exist");
        }
    }

    public static void deleteMyPassword(MyPassword mypassword, String path) {
        for (int i = 0; i < mypasswords.size(); ++i) {
            MyPassword tr = mypasswords.get(i);
            if (!tr.getUsername().equals(mypassword.getUsername()) || !tr.getPassword().equals(mypassword.getPassword()) || !tr.getDescription().equals(mypassword.getDescription())) continue;
            mypasswords.remove(i);
            break;
        }
        Control.storeMyPasswords(path);
    }

    public static void updateMyPassword(MyPassword oldmypassword, MyPassword newmypassword, String path) {
        for (int i = 0; i < mypasswords.size(); ++i) {
            MyPassword mp = mypasswords.get(i);
            if (!mp.getUsername().equals(oldmypassword.getUsername()) || !mp.getPassword().equals(oldmypassword.getPassword()) || !mp.getDescription().equals(oldmypassword.getDescription())) continue;
            mypasswords.get(i).setDescription(newmypassword.getDescription());
            mypasswords.get(i).setLastChangeDate(newmypassword.getLastChangeDate());
            mypasswords.get(i).setLastChangeTime(newmypassword.getLastChangeTime());
            mypasswords.get(i).setPassword(newmypassword.getPassword());
            mypasswords.get(i).setUsername(newmypassword.getUsername());
            break;
        }
        Control.storeMyPasswords(path);
    }

    public static ArrayList<MyPassword> getMyPasswords(String path) {
        Control.fetchMyPasswords(path);
        return mypasswords;
    }

    private static void storeUsers() {
        File file = new File(path + "\\users.xml");
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = db.newDocument();
            Element rootEle = doc.createElement("users");
            for (int i = 0; i < users.size(); ++i) {
                Element subroot = doc.createElement("user");
                Element name = doc.createElement("name");
                Element username = doc.createElement("username");
                Element password = doc.createElement("password");
                Element lastLoginDate = doc.createElement("lastlogindate");
                Element lastLoginTime = doc.createElement("lastlogintime");
                Element filePath = doc.createElement("filepath");
                name.appendChild(doc.createTextNode(Control.encrypt(users.get(i).getName())));
                username.appendChild(doc.createTextNode(Control.encrypt(users.get(i).getUsername())));
                password.appendChild(doc.createTextNode(Control.encrypt(users.get(i).getPassword())));
                lastLoginDate.appendChild(doc.createTextNode(Control.encrypt(users.get(i).getLastLoginDate())));
                lastLoginTime.appendChild(doc.createTextNode(Control.encrypt(users.get(i).getLastLoginTime())));
                filePath.appendChild(doc.createTextNode(Control.encrypt(users.get(i).getFilePath())));
                subroot.appendChild(name);
                subroot.appendChild(username);
                subroot.appendChild(password);
                subroot.appendChild(lastLoginDate);
                subroot.appendChild(lastLoginTime);
                subroot.appendChild(filePath);
                rootEle.appendChild(subroot);
            }
            doc.appendChild(rootEle);
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                tr.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(file)));
            }
            catch (IOException | TransformerException te) {
                JOptionPane.showMessageDialog(null, te);
            }
        }
        catch (ParserConfigurationException pce) {
            JOptionPane.showMessageDialog(null, pce);
        }
    }

    private static void storeLogs() {
        File file = new File(path + "\\logs.xml");
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = db.newDocument();
            Element rootEle = doc.createElement("logs");
            for (int i = 0; i < logs.size(); ++i) {
                Element subroot = doc.createElement("log");
                Element username = doc.createElement("username");
                Element date = doc.createElement("date");
                Element time = doc.createElement("time");
                Element description = doc.createElement("description");
                username.appendChild(doc.createTextNode(Control.encrypt(logs.get(i).getUsername())));
                date.appendChild(doc.createTextNode(Control.encrypt(logs.get(i).getDate())));
                time.appendChild(doc.createTextNode(Control.encrypt(logs.get(i).getTime())));
                description.appendChild(doc.createTextNode(Control.encrypt(logs.get(i).getDescription())));
                subroot.appendChild(username);
                subroot.appendChild(date);
                subroot.appendChild(time);
                subroot.appendChild(description);
                rootEle.appendChild(subroot);
            }
            doc.appendChild(rootEle);
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                tr.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(file)));
            }
            catch (IOException | TransformerException te) {
                JOptionPane.showMessageDialog(null, te);
            }
        }
        catch (ParserConfigurationException pce) {
            JOptionPane.showMessageDialog(null, pce);
        }
    }

    private static void storeMyPasswords(String path) {
        File file = new File(path + ".xml");
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = db.newDocument();
            Element rootEle = doc.createElement("mypasswords");
            for (int i = 0; i < mypasswords.size(); ++i) {
                Element subroot = doc.createElement("mypassword");
                Element id = doc.createElement("id");
                Element username = doc.createElement("username");
                Element password = doc.createElement("password");
                Element description = doc.createElement("description");
                Element createDate = doc.createElement("createdate");
                Element createTime = doc.createElement("createtime");
                Element lastChangeDate = doc.createElement("lastchangedate");
                Element lastChangeTime = doc.createElement("lastchangetime");
                id.appendChild(doc.createTextNode("" + mypasswords.get(i).getId()));
                username.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getUsername())));
                password.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getPassword())));
                description.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getDescription())));
                createDate.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getCreateDate())));
                createTime.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getCreateTime())));
                lastChangeDate.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getLastChangeDate())));
                lastChangeTime.appendChild(doc.createTextNode(Control.encrypt(mypasswords.get(i).getLastChangeTime())));
                subroot.appendChild(id);
                subroot.appendChild(username);
                subroot.appendChild(password);
                subroot.appendChild(description);
                subroot.appendChild(createDate);
                subroot.appendChild(createTime);
                subroot.appendChild(lastChangeDate);
                subroot.appendChild(lastChangeTime);
                rootEle.appendChild(subroot);
            }
            doc.appendChild(rootEle);
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("indent", "yes");
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", "UTF-8");
                tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                tr.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(file)));
            }
            catch (IOException | TransformerException te) {
                JOptionPane.showMessageDialog(null, te);
            }
        }
        catch (ParserConfigurationException pce) {
            JOptionPane.showMessageDialog(null, pce);
        }
    }

    private static void fetchUsers() {
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = db.parse(path + "\\users.xml");
            NodeList userList = doc.getElementsByTagName("user");
            for (int i = 0; i < userList.getLength(); ++i) {
                User user = new User();
                Node userNode = userList.item(i);
                if (userNode.getNodeType() != 1) continue;
                Element userele = (Element)userNode;
                user.setName(Control.decrypt(userele.getElementsByTagName("name").item(0).getChildNodes().item(0).getNodeValue()));
                user.setUsername(Control.decrypt(userele.getElementsByTagName("username").item(0).getChildNodes().item(0).getNodeValue()));
                user.setPassword(Control.decrypt(userele.getElementsByTagName("password").item(0).getChildNodes().item(0).getNodeValue()));
                user.setLastLoginDate(Control.decrypt(userele.getElementsByTagName("lastlogindate").item(0).getChildNodes().item(0).getNodeValue()));
                user.setLastLoginTime(Control.decrypt(userele.getElementsByTagName("lastlogintime").item(0).getChildNodes().item(0).getNodeValue()));
                user.setFilePath(Control.decrypt(userele.getElementsByTagName("filepath").item(0).getChildNodes().item(0).getNodeValue()));
                users.add(user);
            }
        }
        catch (IllegalArgumentException | ParserConfigurationException | SAXException userList) {
        }
        catch (IOException e) {
            try {
                new File(path).mkdir();
                new FileOutputStream(path + "\\users.xml").close();
            }
            catch (HeadlessException | IOException e2) {
                JOptionPane.showMessageDialog(null, e2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
        }
    }

    private static void fetchLogs() {
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = db.parse(path + "\\logs.xml");
            NodeList logList = doc.getElementsByTagName("log");
            for (int i = 0; i < logList.getLength(); ++i) {
                Log log = new Log();
                Node logNode = logList.item(i);
                if (logNode.getNodeType() != 1) continue;
                Element logele = (Element)logNode;
                log.setUsername(Control.decrypt(logele.getElementsByTagName("username").item(0).getChildNodes().item(0).getNodeValue()));
                log.setDate(Control.decrypt(logele.getElementsByTagName("date").item(0).getChildNodes().item(0).getNodeValue()));
                log.setTime(Control.decrypt(logele.getElementsByTagName("time").item(0).getChildNodes().item(0).getNodeValue()));
                log.setDescription(Control.decrypt(logele.getElementsByTagName("description").item(0).getChildNodes().item(0).getNodeValue()));
                logs.add(log);
            }
        }
        catch (IllegalArgumentException | ParserConfigurationException | SAXException logList) {
        }
        catch (IOException e) {
            try {
                new File(path).mkdir();
                new FileOutputStream(path + "\\logs.xml").close();
            }
            catch (HeadlessException | IOException e2) {
                JOptionPane.showMessageDialog(null, e2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
        }
    }

    private static void fetchMyPasswords(String path) {
        mypasswords.clear();
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = db.parse(path + ".xml");
            NodeList mypasswordList = doc.getElementsByTagName("mypassword");
            for (int i = 0; i < mypasswordList.getLength(); ++i) {
                MyPassword mypassword = new MyPassword();
                Node mypasswordNode = mypasswordList.item(i);
                if (mypasswordNode.getNodeType() != 1) continue;
                Element mypasswordele = (Element)mypasswordNode;
                mypassword.setId(Integer.parseInt(mypasswordele.getElementsByTagName("id").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setUsername(Control.decrypt(mypasswordele.getElementsByTagName("username").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setPassword(Control.decrypt(mypasswordele.getElementsByTagName("password").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setDescription(Control.decrypt(mypasswordele.getElementsByTagName("description").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setCreateDate(Control.decrypt(mypasswordele.getElementsByTagName("createdate").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setCreateTime(Control.decrypt(mypasswordele.getElementsByTagName("createtime").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setLastChangeDate(Control.decrypt(mypasswordele.getElementsByTagName("lastchangedate").item(0).getChildNodes().item(0).getNodeValue()));
                mypassword.setLastChangeTime(Control.decrypt(mypasswordele.getElementsByTagName("lastchangetime").item(0).getChildNodes().item(0).getNodeValue()));
                mypasswords.add(mypassword);
            }
        }
        catch (IllegalArgumentException | ParserConfigurationException | SAXException mypasswordList) {
        }
        catch (IOException e) {
            try {
                new FileOutputStream(path + ".xml").close();
            }
            catch (HeadlessException | IOException e2) {
                JOptionPane.showMessageDialog(null, e2);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e);
        }
    }

    public static String encrypt(String str) {
        String encrypted = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec key = new SecretKeySpec("MySecretKeyIsKey".getBytes(), "AES");
            cipher.init(1, key);
            byte[] encVal = cipher.doFinal(str.getBytes());
            encrypted = new BASE64Encoder().encode(encVal);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            System.out.println(ex);
        }
        return encrypted;
    }

    public static String decrypt(String str) {
        String decrypted = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            SecretKeySpec key = new SecretKeySpec("MySecretKeyIsKey".getBytes(), "AES");
            cipher.init(2, key);
            byte[] decodedValue = new BASE64Decoder().decodeBuffer(str);
            byte[] decVal = cipher.doFinal(decodedValue);
            decrypted = new String(decVal);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            System.out.println(ex);
        }
        return decrypted;
    }

    static {
        path = System.getProperty("user.home") + "\\PasswordLocker";
        Control.fetchUsers();
        Control.fetchLogs();
    }
}

