/*
 * Decompiled with CFR 0.152.
 */
package passwordlocker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import passwordlocker.Control;
import passwordlocker.Log;
import passwordlocker.User;

public class Settings
extends JFrame
implements ActionListener {
    User user;
    private JButton changePathB;
    private JTextField fileNameTF;
    private JTextField filePathTF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField nameTF;
    private JPasswordField passwordF;
    private JButton showPasswordB;
    private JLabel showPasswordL;
    private JButton updateB;
    private JTextField usernameTF;

    public Settings(User user) {
        this.initComponents();
        this.user = user;
        this.initValues();
        this.addListeners();
    }

    final void addListeners() {
        this.showPasswordB.addActionListener(this);
        this.changePathB.addActionListener(this);
        this.updateB.addActionListener(this);
    }

    final void initValues() {
        this.nameTF.setText(this.user.getName());
        this.usernameTF.setText(this.user.getUsername());
        this.passwordF.setText(this.user.getPassword());
        String path = this.user.getFilePath().substring(0, this.user.getFilePath().lastIndexOf("\\"));
        String file = this.user.getFilePath().substring(this.user.getFilePath().lastIndexOf("\\") + 1);
        this.filePathTF.setText(path);
        this.fileNameTF.setText(file);
        this.showPasswordL.setText("");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.nameTF = new JTextField();
        this.usernameTF = new JTextField();
        this.passwordF = new JPasswordField();
        this.filePathTF = new JTextField();
        this.jLabel5 = new JLabel();
        this.fileNameTF = new JTextField();
        this.changePathB = new JButton();
        this.updateB = new JButton();
        this.showPasswordL = new JLabel();
        this.showPasswordB = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Settings");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/passwordlocker.png")).getImage());
        this.setResizable(false);
        this.jLabel1.setText("Name:");
        this.jLabel2.setText("Username:");
        this.jLabel3.setText("Password:");
        this.jLabel4.setText("File Path:");
        this.usernameTF.setEditable(false);
        this.passwordF.setToolTipText("Type Password to change");
        this.filePathTF.setEditable(false);
        this.jLabel5.setText("File Name:");
        this.changePathB.setText("Change Path");
        this.updateB.setText("Update");
        this.showPasswordL.setText("123456789");
        this.showPasswordB.setText("Show Password");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel4))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.updateB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPasswordB)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameTF).addComponent(this.usernameTF, -1, 150, Short.MAX_VALUE).addComponent(this.passwordF)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showPasswordL)).addGroup(layout.createSequentialGroup().addComponent(this.fileNameTF, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.changePathB)).addComponent(this.filePathTF))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.usernameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.passwordF, -2, -1, -2).addComponent(this.showPasswordL)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.filePathTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.fileNameTF, -2, -1, -2).addComponent(this.changePathB)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateB).addComponent(this.showPasswordB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changePathB) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            int response = chooser.showDialog(this, "Select");
            if (response == 0) {
                this.filePathTF.setText(chooser.getSelectedFile().getPath());
            }
        }
        if (e.getSource() == this.showPasswordB) {
            if (this.showPasswordB.getText().equals("Show Password")) {
                this.showPasswordL.setText(this.passwordF.getText());
                this.showPasswordB.setText("Hide Password");
            } else {
                this.showPasswordL.setText("");
                this.showPasswordB.setText("Show Password");
            }
        }
        if (e.getSource() == this.updateB) {
            String name = this.nameTF.getText();
            String username = this.usernameTF.getText();
            String password = this.passwordF.getText();
            String filePath = this.filePathTF.getText();
            String fileName = this.fileNameTF.getText();
            if (!(name.equals("") || password.equals("") || filePath.equals("") || fileName.equals(""))) {
                Control.updateUser(new User(name, username, password, this.user.getLastLoginDate(), this.user.getLastLoginTime(), filePath + "\\" + fileName));
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                String date = cal.get(5) + " " + cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + cal.get(1);
                String time = cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
                Control.addLog(new Log(this.user.getUsername(), date, time, "User Detail Updated"));
                JOptionPane.showMessageDialog(this, "Details Updated!");
            }
        }
    }
}

