/*
 * Decompiled with CFR 0.152.
 */
package passwordlocker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import passwordlocker.Control;
import passwordlocker.Log;
import passwordlocker.User;

public class NewUserForm
extends JFrame
implements ActionListener {
    String path = null;
    private JButton closeB;
    private JPasswordField cpasswordPF;
    private JButton createUserB;
    private JTextField filenameTF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JButton locationB;
    private JTextField nameTF;
    private JPasswordField passwordPF;
    private JTextField usernameTF;

    public NewUserForm() {
        this.initComponents();
        this.locationB.addActionListener(this);
        this.createUserB.addActionListener(this);
        this.closeB.addActionListener(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTF = new JTextField();
        this.jLabel2 = new JLabel();
        this.usernameTF = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.passwordPF = new JPasswordField();
        this.cpasswordPF = new JPasswordField();
        this.jLabel5 = new JLabel();
        this.filenameTF = new JTextField();
        this.locationB = new JButton();
        this.createUserB = new JButton();
        this.closeB = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("New User Registration");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/passwordlocker.png")).getImage());
        this.jLabel1.setText("Name:");
        this.jLabel2.setText("Username:");
        this.jLabel3.setText("Password:");
        this.jLabel4.setText("Confirm Password:");
        this.jLabel5.setText("File Name:");
        this.filenameTF.setToolTipText("File Name in which you want to store passwords");
        this.locationB.setText("Location");
        this.locationB.setToolTipText("Location where you want to store your password file");
        this.createUserB.setText("Create User");
        this.createUserB.setToolTipText("Create New User");
        this.closeB.setText("Close");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addGap(40, 40, 40)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addGap(40, 40, 40)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGap(59, 59, 59)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addGap(38, 38, 38))).addGap(49, 49, 49).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.createUserB).addGap(18, 18, 18).addComponent(this.closeB).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.filenameTF, -1, 130, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.locationB, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.usernameTF).addComponent(this.nameTF).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.cpasswordPF, GroupLayout.Alignment.LEADING, -1, 150, Short.MAX_VALUE).addComponent(this.passwordPF, GroupLayout.Alignment.LEADING)).addGap(0, 0, Short.MAX_VALUE))).addGap(1, 1, 1))).addGap(32, 32, 32)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addComponent(this.nameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addComponent(this.usernameTF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE)).addComponent(this.passwordPF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE)).addComponent(this.cpasswordPF, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.filenameTF)).addComponent(this.locationB)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createUserB).addComponent(this.closeB)).addContainerGap()));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createUserB) {
            String name = this.nameTF.getText().trim();
            String username = this.usernameTF.getText().trim();
            String pass = this.passwordPF.getText().trim();
            String cpass = this.cpasswordPF.getText().trim();
            String filename = this.filenameTF.getText().trim();
            if (!(name.equals("") || username.equals("") || !pass.equals(cpass) || filename.equals("") || this.path.equals(""))) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                String date = cal.get(5) + " " + cal.getDisplayName(2, 1, Locale.ENGLISH) + ", " + cal.get(1);
                String time = cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13);
                User user = new User(name, username, pass, date, time, this.path + "\\" + filename);
                if (!Control.getUsers().contains(user)) {
                    Control.addLog(new Log(username, date, time, "Register"));
                    Control.addUser(user);
                    JOptionPane.showMessageDialog(this, "User has been created!");
                    this.nameTF.setText("");
                    this.usernameTF.setText("");
                    this.passwordPF.setText("");
                    this.cpasswordPF.setText("");
                    this.filenameTF.setText("");
                } else {
                    JOptionPane.showMessageDialog(this, "User already exist try another username!");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please fill all the fields!");
            }
        }
        if (e.getSource() == this.locationB) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            int response = chooser.showDialog(this, "Select");
            if (response == 0) {
                this.path = chooser.getSelectedFile().getPath();
            }
        }
        if (e.getSource() == this.closeB) {
            this.dispose();
        }
    }
}

