<?php

/** This code can be placed in another php file * */
$sys['theme'] = "theme1";//this value can be fetched from database

function getThemeData($file, $headers = array("name" => "Name")) {
    $file_data = file_get_contents($file);

    foreach ($headers as $field => $regex) {
        if (preg_match('/^[ \t\/*#@]*' . preg_quote($regex, '/') . ':(.*)$/mi', $file_data, $match) && $match[1]) {
            $headers[$field] = $match[1];
        } else {
            $headers[$field] = '';
        }
    }

    return $headers;
}

function getThemes() {
    global $sys;
    $themes = array();
    $dirs = glob('themes/*', GLOB_ONLYDIR);
    foreach ($dirs as $dir) {
        $screenshot = file_exists($dir . "/screenshot.png") ? $dir . "/screenshot.png" : "http://via.placeholder.com/400x400?text=No%20Screenshot";
        $theme = array(
            'path' => $dir,
            'folder' => basename($dir),
            'screenshot' => $screenshot,
            'name' => basename($dir)
        );
        if (file_exists($dir . "/theme-info")) {
            $theme_info = getThemeData($dir . "/theme-info", array("name" => "Name", "author" => "Author", "description" => "Description", "version" => "Version"));
            $theme['name'] = $theme_info['name'];
            $theme['author'] = $theme_info['author'];
            $theme['description'] = $theme_info['description'];
            $theme['version'] = $theme_info['version'];
        }

        $themes[] = $theme;
    }
    return $themes;
}
/** This code can be placed in another php file * */

$msg = "";
if (isset($_REQUEST['activate']) && trim($_REQUEST['activate'])) {
    $current_theme = filter_var(trim($_REQUEST['activate']), FILTER_SANITIZE_STRING);
    /*
     * Code to save active theme to database goes here     
     */
    $sys['theme'] = $current_theme;
    $msg = '<div class="alert alert-success">' . $current_theme . ' Theme Activated</div>';
}
$themes = getThemes();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Themes - Admin</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
    </head>
    <body>
        <div class="container">
            <div class="">
                <section class="">
                    <h1>
                        Themes
                    </h1>

                </section>
                <section class="">
                    <?= $msg ?>
                    <div class="row themes" id="themes">
                        <?php foreach ($themes as $theme) { ?>
                            <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                <div class="panel">
                                    <div class="panel-body">
                                        <img src="<?= $theme['screenshot'] ?>" class="img-responsive"/>
                                    </div>
                                    <div class="panel-footer">
                                        <b><?= $theme['name'] ?></b>
                                        <?php if ($sys['theme'] != $theme['folder']) { ?>
                                            <a href="themes.php?activate=<?= $theme['folder'] ?>" class="btn btn-default btn-xs pull-right">Activate</a>
                                            <?php
                                        } else {
                                            echo '<span class="pull-right">Activated</span>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                </section>
            </div>

        </div>

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
    </body>
</html>
