package com.zatackcoder.recyclerviewtest;

import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class MainActivity extends AppCompatActivity {

    private RecyclerView mRecyclerView;
    private RecyclerView.Adapter mAdapter;
    private RecyclerView.LayoutManager mLayoutManager;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mRecyclerView = (RecyclerView) findViewById(R.id.recycler_view);
        mRecyclerView.setHasFixedSize(true);
        mLayoutManager = new LinearLayoutManager(this);
        mRecyclerView.setLayoutManager(mLayoutManager);
        ArrayList items = new ArrayList<Item>();
        items.add(new Item("Title 1", "Description 1"));
        items.add(new Item("Title 2", "Description 2"));
        items.add(new Item("Title 3", "Description 3"));
        items.add(new Item("Title 4", "Description 4"));
        items.add(new Item("Title 5", "Description 5"));
        items.add(new Item("Title 6", "Description 6"));
        items.add(new Item("Title 7", "Description 7"));
        items.add(new Item("Title 8", "Description 8"));
        items.add(new Item("Title 9", "Description 9"));
        items.add(new Item("Title 10", "Description 10"));
        items.add(new Item("Title 11", "Description 11"));
        items.add(new Item("Title 12", "Description 12"));
        items.add(new Item("Title 13", "Description 13"));
        items.add(new Item("Title 14", "Description 14"));
        items.add(new Item("Title 15", "Description 15"));
        mAdapter = new MyAdapter(getApplicationContext(), items);
        mRecyclerView.setAdapter(mAdapter);
    }
}
