package com.zatackcoder.searchviewsuggestionsovernetwork;

import android.content.Context;
import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.cursoradapter.widget.CursorAdapter;

public class SuggestionAdapter extends CursorAdapter {

    public SuggestionAdapter(Context context, Cursor c, boolean autoRequery) {
        super(context, c, autoRequery);
    }

    @Override
    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        return LayoutInflater.from(context).inflate(R.layout.search_view_suggestion, parent, false);
    }

    @Override
    public void bindView(View view, final Context context, Cursor cursor) {
        TextView nameTV = view.findViewById(R.id.nameTV);
        TextView descTV = view.findViewById(R.id.descTV);

        if(cursor.getColumnIndex("name") != -1 && cursor.getString(cursor.getColumnIndex("name")) != null) {
            final String name = cursor.getString(cursor.getColumnIndex("name"));
            String color = cursor.getString(cursor.getColumnIndex("color"));
            String size = cursor.getString(cursor.getColumnIndex("size"));
            String price = cursor.getString(cursor.getColumnIndex("price"));

            nameTV.setText(name);
            descTV.setText(String.format("color:%s size%s price:%s", color, size, price));

            view.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Toast.makeText(context, "You Just Clicked " + name, Toast.LENGTH_LONG).show();
                }
            });
        }
    }
}
