<?php

require 'config.php';

header('Content-Type: text/plain;charset=UTF-8');

$url = isset($_REQUEST['url']) ? urldecode(trim($_REQUEST['url'])) : '';
if (!preg_match('/[a-zA-Z0-9]+\.[a-zA-Z0-9]+$/', $url)) {
    die('Error');
}
//add http if not already in url
if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {
    $url = "http://" . $url;
}

function nextLetter(&$str) {
    $str = ('z' == $str ? 'a' : ++$str);
}

function getNextSlug($s) {
    $a = str_split($s);
    $c = count($a);
    if (preg_match('/^z*$/', $s)) { // string consists entirely of `z`
        return str_repeat('a', $c + 1);
    }
    while ('z' == $a[--$c]) {
        nextLetter($a[$c]);
    }
    nextLetter($a[$c]);
    return implode($a);
}

$db = new mysqli(MYSQL_HOST, MYSQL_USER, MYSQL_PASSWORD, MYSQL_DATABASE);

$url = $db->real_escape_string($url);

$result = $db->query("SELECT slug FROM links WHERE url = '{$url}' LIMIT 1");
if ($result && $result->num_rows > 0) { // If there’s already a short URL for this URL
    die(SITE_URL . $result->fetch_object()->slug);
} else {
    $result = $db->query('SELECT slug, url FROM links ORDER BY id DESC, slug DESC LIMIT 1');
    $slug = ($result && $result->num_rows > 0) ? getNextSlug($result->fetch_object()->slug) : 'a';
    if ($db->query("INSERT INTO links (slug, url, created, hits) VALUES ('{$slug}', '{$url}', NOW(), '0')")) {
        header('HTTP/1.1 201 Created');
        echo SITE_URL . $slug;
        $db->query('OPTIMIZE TABLE `links`');
    }
}
?>