package com.zatackcoder.databasehandler;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;

import java.util.ArrayList;

public class RecordsViewActivity extends AppCompatActivity {

    TableLayout recordsTL;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_records_view);
        setTitle("Records");

        recordsTL = (TableLayout) findViewById(R.id.recordsTL);
        SQLiteHelper sqLiteHelper = new SQLiteHelper(this);
        ArrayList<Record> records = sqLiteHelper.getAllRecords();
        for (Record record : records) {
            TableRow tr = new TableRow(this);

            TableRow.LayoutParams params = new TableRow.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT, 1.0f);

            TextView idTV = new TextView(this);
            idTV.setText(String.valueOf(record.getId()));
            idTV.setPadding(5, 5, 5, 5);

            TextView nameTV = new TextView(this);
            nameTV.setText(record.getName());
            nameTV.setPadding(5, 5, 5, 5);
            nameTV.setLayoutParams(params);

            TextView phoneTV = new TextView(this);
            phoneTV.setText(record.getPhone());
            phoneTV.setPadding(5, 5, 5, 5);
            phoneTV.setLayoutParams(params);

            TextView emailTV = new TextView(this);
            emailTV.setText(record.getEmail());
            emailTV.setPadding(5, 5, 5, 5);
            emailTV.setLayoutParams(params);

            tr.addView(idTV, 0);
            tr.addView(nameTV, 1);
            tr.addView(phoneTV, 2);
            tr.addView(emailTV, 3);

            recordsTL.addView(tr);
        }

    }
}
