package com.zatackcoder.databasehandler;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import java.util.ArrayList;

/**
 * Created by rajesh on 18/11/17.
 */

public class SQLiteHelper extends SQLiteOpenHelper {

    private static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "databasehandler.db";

    public static final String RECORD_TABLE = "records";
    public static final String C_ID = "id";
    public static final String C_NAME = "name";
    public static final String C_PHONE = "phone";
    public static final String C_EMAIL = "source";

    public SQLiteHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table " + RECORD_TABLE + " ( " +
                C_ID + " INTEGER PRIMARY KEY AUTOINCREMENT," +
                C_NAME + " VARCHAR, " +
                C_PHONE + " VARCHAR, " +
                C_EMAIL + " VARCHAR" +
                ");");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int i, int i1) {
        db.execSQL("DROP TABLE IF EXISTS " + RECORD_TABLE);
        onCreate(db);
    }

    public void addRecord(Record record) {
        SQLiteDatabase db = this.getReadableDatabase();
        ContentValues contentValues = new ContentValues();
        //contentValues.put(C_ID, record.getId());
        contentValues.put(C_NAME, record.getName());
        contentValues.put(C_PHONE, record.getPhone());
        contentValues.put(C_EMAIL, record.getEmail());
        db.insert(RECORD_TABLE, null, contentValues);
        db.close();
    }

    public void updateRecord(Record record) {
        SQLiteDatabase db = this.getReadableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put(C_NAME, record.getName());
        contentValues.put(C_PHONE, record.getPhone());
        contentValues.put(C_EMAIL, record.getEmail());

        db.update(RECORD_TABLE, contentValues, C_ID + " = ?", new String[]{String.valueOf(record.getId())});
        db.close();
    }

    public void deleteRecord(Record record) {
        SQLiteDatabase db = this.getReadableDatabase();
        db.delete(RECORD_TABLE, C_ID + " = ?", new String[]{String.valueOf(record.getId())});
        db.close();
    }

    public Record getRecord(long id) {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query(RECORD_TABLE, null, C_ID + " = ?", new String[]{String.valueOf(id)}, null, null, null);
        cursor.moveToNext();
        Record record = new Record(cursor.getLong(0), cursor.getString(1), cursor.getString(2), cursor.getString(3));
        cursor.close();
        db.close();
        return record;
    }

    public ArrayList<Record> getAllRecords() {
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = db.query(RECORD_TABLE, null, null, null, null, null, null);
        ArrayList<Record> records = new ArrayList<Record>();
        Record record;
        if (cursor.getCount() > 0) {
            for (int i = 0; i < cursor.getCount(); i++) {
                cursor.moveToNext();
                record = new Record(cursor.getLong(0));
                record.setName(cursor.getString(1));
                record.setPhone(cursor.getString(2));
                record.setEmail(cursor.getString(3));

                records.add(record);
            }
        }
        cursor.close();
        db.close();
        return records;
    }

}
