package com.zatackcoder.databasehandler;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class RecordAddActivity extends AppCompatActivity {

    EditText nameET;
    EditText phoneET;
    EditText emailET;
    Button saveB;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_record_add);
        setTitle("Add Record");

        final SQLiteHelper sqLiteHelper = new SQLiteHelper(this);

        nameET = (EditText)findViewById(R.id.nameET);
        phoneET = (EditText)findViewById(R.id.phoneET);
        emailET = (EditText)findViewById(R.id.emailET);

        saveB =  (Button) findViewById(R.id.updateB);
        saveB.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View view) {
                if(nameET.getText().toString().isEmpty() || phoneET.getText().toString().isEmpty()) {
                    Toast.makeText(getApplicationContext(), "Name and Phone cannot be blank", Toast.LENGTH_LONG).show();
                } else {
                    sqLiteHelper.addRecord(new Record(0L, nameET.getText().toString(), phoneET.getText().toString(), emailET.getText().toString()));
                    Toast.makeText(getApplicationContext(), "Record Added Successfully", Toast.LENGTH_LONG).show();
                    nameET.setText("");
                    phoneET.setText("");
                    emailET.setText("");
                }
            }
        });

    }
}
