package com.zatackcoder.databasehandler;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import java.util.ArrayList;

public class RecordUpdateDeleteActivity extends AppCompatActivity {

    SQLiteHelper sqLiteHelper;
    ArrayList<Record> records;

    Spinner idS;
    EditText nameET;
    EditText phoneET;
    EditText emailET;
    Button updateB;
    Button deleteB;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_record_update_delete);
        setTitle("Update/Delete Record");

        idS = (Spinner) findViewById(R.id.idS);
        nameET = (EditText) findViewById(R.id.nameET);
        phoneET = (EditText) findViewById(R.id.phoneET);
        emailET = (EditText) findViewById(R.id.emailET);

        updateB = (Button) findViewById(R.id.updateB);
        deleteB = (Button) findViewById(R.id.deleteB);

        sqLiteHelper = new SQLiteHelper(this);
        records = sqLiteHelper.getAllRecords();
        final ArrayAdapter<Record> ids = new ArrayAdapter<>(this, android.R.layout.simple_spinner_item, records);
        idS.setAdapter(ids);

        idS.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                Record record = (Record) idS.getSelectedItem();
                nameET.setText(record.getName());
                phoneET.setText(record.getPhone());
                emailET.setText(record.getEmail());
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });

        updateB.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if(nameET.getText().toString().isEmpty() || phoneET.getText().toString().isEmpty()) {
                    Toast.makeText(getApplicationContext(), "Name and Phone cannot be blank", Toast.LENGTH_LONG).show();
                    return;
                }
                Record record = (Record) idS.getSelectedItem();
                record.setName(nameET.getText().toString());
                record.setPhone(phoneET.getText().toString());
                record.setEmail(emailET.getText().toString());
                sqLiteHelper.updateRecord(record);
                Toast.makeText(getApplicationContext(), "Record Updated Successfully", Toast.LENGTH_LONG).show();
            }
        });

        deleteB.setOnClickListener(new View.OnClickListener(){
            @Override
            public void onClick(View view) {
                Record record = (Record) idS.getSelectedItem();
                sqLiteHelper.deleteRecord(record);
                Toast.makeText(getApplicationContext(), "Record Deleted Successfully", Toast.LENGTH_LONG).show();
            }
        });
    }
}
