/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * @author Rajesh Kumar Sahanee
 *
 * Created on Aug 12, 2012, 9:16:46 PM
 */
package jeditor;

import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

/**
 *
 * @author Rajesh
 */
public class Editor extends javax.swing.JFrame implements WindowListener {

    /**
     * Creates new form Editor
     */
    public Editor() {
        setIconImage(new ImageIcon(getClass().getResource("/img/logo.png")).getImage());
        initComponents();
        area = new Area();
        addTab("Untitled", area);
        addWindowListener(this);
        output.setVisible(false);
        startCounter();
    }

    private void startCounter(){
        new Thread(){
            @Override
            public void run(){
                String text="";
                int lastp = 0;
                while(running){
                    if(area!=null){
                        try{
                        text  = "Total Line: "+ area.getArea().getText().split("\n").length+" | ";
                        text += "Line: "+area.getArea().getText(0, area.getArea().getCaretPosition()).split("\n").length+" | ";
                            if (area.getArea().getText().lastIndexOf("\n", area.getArea().getCaretPosition()) > 0) {
                               lastp = area.getArea().getText(0, area.getArea().getCaretPosition()).lastIndexOf("\n");
                                text += "Character: " + (area.getArea().getCaretPosition() - lastp);
                            } else {
                                text += "Character: " + (area.getArea().getCaretPosition()+1);
                            }
                        linecurL.setText(text);
                        Thread.sleep(10);
                        }catch(Exception e){}
                    }
                }
            }
        }.start();
    }
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        topToolbar = new javax.swing.JToolBar();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0));
        newB = new javax.swing.JButton();
        filler2 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(32767, 0));
        openB = new javax.swing.JButton();
        saveB = new javax.swing.JButton();
        cutB = new javax.swing.JButton();
        copyB = new javax.swing.JButton();
        pasteB = new javax.swing.JButton();
        compileB = new javax.swing.JButton();
        runB = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        fontSizeC = new javax.swing.JComboBox();
        jSeparator2 = new javax.swing.JToolBar.Separator();
        fontStyleC = new javax.swing.JComboBox();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        langB = new javax.swing.JButton();
        hmapB = new javax.swing.JButton();
        jSeparator4 = new javax.swing.JToolBar.Separator();
        findT = new javax.swing.JTextField();
        jSeparator5 = new javax.swing.JToolBar.Separator();
        findPB = new javax.swing.JButton();
        findNB = new javax.swing.JButton();
        jSeparator8 = new javax.swing.JToolBar.Separator();
        showReplace = new javax.swing.JButton();
        jSeparator6 = new javax.swing.JToolBar.Separator();
        readUrlB = new javax.swing.JButton();
        pbar = new javax.swing.JProgressBar();
        jSeparator9 = new javax.swing.JToolBar.Separator();
        aboutB = new javax.swing.JButton();
        jSeparator10 = new javax.swing.JToolBar.Separator();
        showOutputB = new javax.swing.JButton();
        jSeparator7 = new javax.swing.JToolBar.Separator();
        closeB = new javax.swing.JButton();
        workArea = new javax.swing.JTabbedPane();
        bottomContainer = new javax.swing.JPanel();
        jToolBar2 = new javax.swing.JToolBar();
        jLabel2 = new javax.swing.JLabel();
        replaceWhatT = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        replaceWithT = new javax.swing.JTextField();
        replaceB = new javax.swing.JButton();
        replaceAllB = new javax.swing.JButton();
        output = new javax.swing.JToolBar();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jScrollPane2 = new javax.swing.JScrollPane();
        outputT = new javax.swing.JTextArea();
        linecurL = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("My Editor");
        setBounds(new java.awt.Rectangle(0, 0, 600, 0));
        setIconImage(new ImageIcon(getClass().getResource("/img/logo.png")).getImage());
        setMinimumSize(new java.awt.Dimension(600, 450));

        topToolbar.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(204, 204, 255), null));
        topToolbar.setFloatable(false);
        topToolbar.setRollover(true);
        topToolbar.add(filler1);

        newB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/newb.png"))); // NOI18N
        newB.setMnemonic('N');
        newB.setToolTipText("Create new file (Alt+N)");
        newB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        newB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        newB.setFocusable(false);
        newB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        newB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        newB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newBActionPerformed(evt);
            }
        });
        topToolbar.add(newB);
        topToolbar.add(filler2);

        openB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/openb.png"))); // NOI18N
        openB.setMnemonic('O');
        openB.setToolTipText("Open file (Alt+O)");
        openB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        openB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        openB.setFocusable(false);
        openB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        openB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        openB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openBActionPerformed(evt);
            }
        });
        topToolbar.add(openB);

        saveB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/saveb.png"))); // NOI18N
        saveB.setMnemonic('S');
        saveB.setToolTipText("Save file (Alt+S)");
        saveB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        saveB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        saveB.setFocusable(false);
        saveB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        saveB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        saveB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveBActionPerformed(evt);
            }
        });
        topToolbar.add(saveB);

        cutB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/cutb.png"))); // NOI18N
        cutB.setMnemonic('X');
        cutB.setToolTipText("Cut (Alt+X)");
        cutB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        cutB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        cutB.setFocusable(false);
        cutB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        cutB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        cutB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cutBActionPerformed(evt);
            }
        });
        topToolbar.add(cutB);

        copyB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/copyb.png"))); // NOI18N
        copyB.setMnemonic('C');
        copyB.setToolTipText("Copy (Alt+C)");
        copyB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        copyB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        copyB.setFocusable(false);
        copyB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        copyB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        copyB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                copyBActionPerformed(evt);
            }
        });
        topToolbar.add(copyB);

        pasteB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/pasteb.png"))); // NOI18N
        pasteB.setMnemonic('P');
        pasteB.setToolTipText("Paste (Alt+P)");
        pasteB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        pasteB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        pasteB.setFocusable(false);
        pasteB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        pasteB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        pasteB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pasteBActionPerformed(evt);
            }
        });
        topToolbar.add(pasteB);

        compileB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/compileb.png"))); // NOI18N
        compileB.setToolTipText("Compile");
        compileB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        compileB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        compileB.setFocusable(false);
        compileB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        compileB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        compileB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                compileBActionPerformed(evt);
            }
        });
        topToolbar.add(compileB);

        runB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/runb.png"))); // NOI18N
        runB.setToolTipText("Run");
        runB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        runB.setFocusable(false);
        runB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        runB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        runB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                runBActionPerformed(evt);
            }
        });
        topToolbar.add(runB);
        topToolbar.add(jSeparator1);

        fontSizeC.setEditable(true);
        fontSizeC.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "3", "7", "12", "16", "24", "28", "32", "36" }));
        fontSizeC.setSelectedItem(12);
        fontSizeC.setToolTipText("Font Size");
        fontSizeC.setMaximumSize(new java.awt.Dimension(32767, 28));
        fontSizeC.setMinimumSize(new java.awt.Dimension(93, 28));
        fontSizeC.setPreferredSize(new java.awt.Dimension(98, 28));
        fontSizeC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontSizeCActionPerformed(evt);
            }
        });
        topToolbar.add(fontSizeC);
        topToolbar.add(jSeparator2);

        fontStyleC.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Plain", "Bold", "Italic" }));
        fontStyleC.setToolTipText("Font Style");
        fontStyleC.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        fontStyleC.setFocusable(false);
        fontStyleC.setMaximumSize(new java.awt.Dimension(32767, 28));
        fontStyleC.setMinimumSize(new java.awt.Dimension(93, 28));
        fontStyleC.setPreferredSize(new java.awt.Dimension(98, 28));
        fontStyleC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fontStyleCActionPerformed(evt);
            }
        });
        topToolbar.add(fontStyleC);
        topToolbar.add(jSeparator3);

        langB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/abc.png"))); // NOI18N
        langB.setToolTipText("English");
        langB.setFocusable(false);
        langB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        langB.setMaximumSize(new java.awt.Dimension(29, 29));
        langB.setMinimumSize(new java.awt.Dimension(29, 29));
        langB.setPreferredSize(new java.awt.Dimension(29, 29));
        langB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                langBActionPerformed(evt);
            }
        });
        topToolbar.add(langB);

        hmapB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/map.png"))); // NOI18N
        hmapB.setToolTipText("Hindi Map");
        hmapB.setEnabled(false);
        hmapB.setFocusable(false);
        hmapB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        hmapB.setMaximumSize(new java.awt.Dimension(29, 29));
        hmapB.setMinimumSize(new java.awt.Dimension(29, 29));
        hmapB.setPreferredSize(new java.awt.Dimension(29, 29));
        hmapB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        hmapB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hmapBActionPerformed(evt);
            }
        });
        topToolbar.add(hmapB);
        topToolbar.add(jSeparator4);

        findT.setColumns(25);
        findT.setFont(new java.awt.Font("Nyala", 0, 18)); // NOI18N
        findT.setToolTipText("Find Text");
        findT.setCursor(new java.awt.Cursor(java.awt.Cursor.TEXT_CURSOR));
        findT.setMaximumSize(new java.awt.Dimension(2147483647, 28));
        findT.setMinimumSize(new java.awt.Dimension(6, 28));
        findT.setPreferredSize(new java.awt.Dimension(331, 28));
        findT.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                findTKeyReleased(evt);
            }
        });
        topToolbar.add(findT);
        topToolbar.add(jSeparator5);

        findPB.setFont(new java.awt.Font("Segoe Script", 1, 24)); // NOI18N
        findPB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/fprevious.png"))); // NOI18N
        findPB.setToolTipText("Find Backward");
        findPB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        findPB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        findPB.setFocusable(false);
        findPB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        findPB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        findPB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findPBActionPerformed(evt);
            }
        });
        topToolbar.add(findPB);

        findNB.setFont(new java.awt.Font("Segoe Script", 1, 24)); // NOI18N
        findNB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/fnext.png"))); // NOI18N
        findNB.setToolTipText("Find Forward");
        findNB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        findNB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        findNB.setFocusable(false);
        findNB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        findNB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        findNB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findNBActionPerformed(evt);
            }
        });
        topToolbar.add(findNB);
        topToolbar.add(jSeparator8);

        showReplace.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/findreplaceb.png"))); // NOI18N
        showReplace.setMnemonic('H');
        showReplace.setToolTipText("Replace (Alt+H)");
        showReplace.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        showReplace.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        showReplace.setFocusable(false);
        showReplace.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        showReplace.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        showReplace.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showReplaceActionPerformed(evt);
            }
        });
        topToolbar.add(showReplace);
        topToolbar.add(jSeparator6);

        readUrlB.setFont(new java.awt.Font("Tahoma", 3, 12)); // NOI18N
        readUrlB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/urlreaderb.png"))); // NOI18N
        readUrlB.setMnemonic('U');
        readUrlB.setToolTipText("Read Url (Alt+U)");
        readUrlB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        readUrlB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        readUrlB.setFocusable(false);
        readUrlB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        readUrlB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        readUrlB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                readUrlBActionPerformed(evt);
            }
        });
        topToolbar.add(readUrlB);

        pbar.setValue(100);
        pbar.setMaximumSize(new java.awt.Dimension(50, 22));
        pbar.setMinimumSize(new java.awt.Dimension(50, 22));
        pbar.setPreferredSize(new java.awt.Dimension(50, 22));
        pbar.setString("Reading");
        topToolbar.add(pbar);
        topToolbar.add(jSeparator9);

        aboutB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/aboutb.png"))); // NOI18N
        aboutB.setToolTipText("About");
        aboutB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        aboutB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        aboutB.setFocusable(false);
        aboutB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        aboutB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        aboutB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutBActionPerformed(evt);
            }
        });
        topToolbar.add(aboutB);
        topToolbar.add(jSeparator10);

        showOutputB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/showhide.png"))); // NOI18N
        showOutputB.setToolTipText("Show/Hide Output");
        showOutputB.setFocusable(false);
        showOutputB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        showOutputB.setMaximumSize(new java.awt.Dimension(29, 29));
        showOutputB.setMinimumSize(new java.awt.Dimension(29, 29));
        showOutputB.setPreferredSize(new java.awt.Dimension(29, 29));
        showOutputB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        showOutputB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showOutputBActionPerformed(evt);
            }
        });
        topToolbar.add(showOutputB);
        topToolbar.add(jSeparator7);

        closeB.setFont(new java.awt.Font("Ebrima", 1, 22)); // NOI18N
        closeB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/closeb.png"))); // NOI18N
        closeB.setMnemonic('E');
        closeB.setToolTipText("Close (Alt+E)");
        closeB.setBorder(javax.swing.BorderFactory.createEmptyBorder(2, 2, 2, 2));
        closeB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        closeB.setFocusable(false);
        closeB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        closeB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        closeB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeBActionPerformed(evt);
            }
        });
        topToolbar.add(closeB);

        getContentPane().add(topToolbar, java.awt.BorderLayout.NORTH);

        workArea.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        workArea.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                workAreaMouseClicked(evt);
            }
        });
        getContentPane().add(workArea, java.awt.BorderLayout.CENTER);

        bottomContainer.setLayout(new java.awt.BorderLayout());

        jToolBar2.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(204, 204, 255), null));
        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);
        jToolBar2.setPreferredSize(new java.awt.Dimension(227, 23));

        jLabel2.setText(" What: ");
        jToolBar2.add(jLabel2);

        replaceWhatT.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        replaceWhatT.setMinimumSize(new java.awt.Dimension(6, 26));
        replaceWhatT.setPreferredSize(new java.awt.Dimension(6, 10));
        jToolBar2.add(replaceWhatT);

        jLabel1.setText(" Replace with: ");
        jToolBar2.add(jLabel1);

        replaceWithT.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        replaceWithT.setMinimumSize(new java.awt.Dimension(6, 26));
        jToolBar2.add(replaceWithT);

        replaceB.setText("Replace");
        replaceB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        replaceB.setFocusable(false);
        replaceB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        replaceB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        replaceB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                replaceBActionPerformed(evt);
            }
        });
        jToolBar2.add(replaceB);

        replaceAllB.setText("Replace All");
        replaceAllB.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        replaceAllB.setFocusable(false);
        replaceAllB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        replaceAllB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        replaceAllB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                replaceAllBActionPerformed(evt);
            }
        });
        jToolBar2.add(replaceAllB);

        bottomContainer.add(jToolBar2, java.awt.BorderLayout.NORTH);
        jToolBar2.setVisible(false);

        output.setFloatable(false);
        output.setRollover(true);
        output.setToolTipText("Output");
        output.setMaximumSize(new java.awt.Dimension(32780, 100));
        output.setName("Output"); // NOI18N
        output.setPreferredSize(new java.awt.Dimension(113, 100));

        outputT.setColumns(20);
        outputT.setRows(5);
        jScrollPane2.setViewportView(outputT);

        jTabbedPane1.addTab("Output", jScrollPane2);

        output.add(jTabbedPane1);

        bottomContainer.add(output, java.awt.BorderLayout.CENTER);

        linecurL.setText("Total Line: 50; Current Line: 25; Character: 10;");
        bottomContainer.add(linecurL, java.awt.BorderLayout.PAGE_END);

        getContentPane().add(bottomContainer, java.awt.BorderLayout.PAGE_END);

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void openBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openBActionPerformed
    JFileChooser jfc = new JFileChooser();
    int response = jfc.showOpenDialog(this);
    if (response == JFileChooser.APPROVE_OPTION) {
        try {
            file = jfc.getSelectedFile();//future check
            FileInputStream fis = new FileInputStream(file);
            byte b[] = new byte[fis.available()];
            fis.read(b);
            String str = new String(b);
            area = new Area();
            area.setFont("Aerial", fontStyleC.getSelectedIndex(), Integer.parseInt(String.valueOf(fontSizeC.getSelectedItem())));
            area.getArea().setText(str);
            String name = file.toString();
            addTab(name, area);
            area.setEdited(false);
            area.setSaved(true);
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "File Cannot Open");
        }
    }
}//GEN-LAST:event_openBActionPerformed

private void newBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newBActionPerformed
    area = new Area();
    area.setFont("Aerial", fontStyleC.getSelectedIndex(), Integer.parseInt(String.valueOf(fontSizeC.getSelectedItem())));
    addTab("Untitled", area);
}//GEN-LAST:event_newBActionPerformed

private void aboutBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutBActionPerformed
    visible = !visible;
    aboutWin.setLocation(-aboutWin.getWidth() / 2 + this.getWidth() / 2, this.getY() - aboutWin.getHeight() / 2 + this.getHeight() / 2);
    aboutWin.setVisible(visible);
}//GEN-LAST:event_aboutBActionPerformed

private void saveBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveBActionPerformed
    save();
}//GEN-LAST:event_saveBActionPerformed

private void closeBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeBActionPerformed
    area = (Area) workArea.getSelectedComponent();
    if (area != null) {
        if (area.isEdited()) {
            int response = JOptionPane.showConfirmDialog(rootPane, "Do you want to Save Changes");
            if (JOptionPane.YES_OPTION == response) {
                save();
                workArea.removeTabAt(workArea.getSelectedIndex());
            } else if (JOptionPane.NO_OPTION == response) {
                workArea.removeTabAt(workArea.getSelectedIndex());
            }
        } else {
            workArea.removeTabAt(workArea.getSelectedIndex());
        }
    } else {
        JOptionPane.showMessageDialog(rootPane, "There is no any opened document!");
    }
}//GEN-LAST:event_closeBActionPerformed

private void cutBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cutBActionPerformed
    area = (Area) workArea.getSelectedComponent();
    area.getArea().cut();
}//GEN-LAST:event_cutBActionPerformed

private void copyBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyBActionPerformed
    area = (Area) workArea.getSelectedComponent();
    area.getArea().copy();
}//GEN-LAST:event_copyBActionPerformed

private void pasteBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pasteBActionPerformed
    area = (Area) workArea.getSelectedComponent();
    area.getArea().paste();
}//GEN-LAST:event_pasteBActionPerformed

private void findNBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findNBActionPerformed
    find(findT.getText(), pos, 1);
}//GEN-LAST:event_findNBActionPerformed

private void findPBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findPBActionPerformed
    find(findT.getText(), pos, -1);
}//GEN-LAST:event_findPBActionPerformed

private void workAreaMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_workAreaMouseClicked
    area = (Area) workArea.getSelectedComponent();
    String size = String.valueOf(area.getFont().getSize());
    fontStyleC.setSelectedIndex(area.getFont().getStyle());
    fontSizeC.setSelectedItem(size);
}//GEN-LAST:event_workAreaMouseClicked

private void findTKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_findTKeyReleased
    if (area.isHindi()) {
        area.getArea().getHighlighter().removeAllHighlights();
        findAll(Translator.toHindi(findT.getText()), 0);
    } else {
        area.getArea().getHighlighter().removeAllHighlights();
        findAll(findT.getText(), 0);
    }
}//GEN-LAST:event_findTKeyReleased

private void readUrlBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_readUrlBActionPerformed
    new Thread() {
        @Override
        public void run() {
            try {
                String path = JOptionPane.showInputDialog("Enter Url");
                if (!path.startsWith("http://")) {
                    path = "http://" + path;
                }
                new Thread() {
                    @Override
                    public void run() {
                        int i = 0;
                        pbar.setStringPainted(true);
                        while (!taskDone) {
                            if (i == 100) {
                                i = 0;
                            }
                            pbar.setValue(i);
                            i += 5;
                            try {
                                Thread.sleep(50);
                            } catch (InterruptedException e) {
                            }
                        }
                        pbar.setValue(100);
                        pbar.setStringPainted(false);
                        taskDone = false;
                    }
                }.start();
                URL url = new URL(path);
                BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
                String read = null;
                String content = "";
                while ((read = br.readLine()) != null) {
                    content = content + read + "\n";
                }
                br.close();
                area = new Area();
                area.getArea().setText(content);
                workArea.addTab(url.toString(), area);
                workArea.setSelectedIndex(workArea.getTabCount() - 1);
                taskDone = true;
            } catch (Exception ex) {
                taskDone = true;
                JOptionPane.showMessageDialog(null, ex);
            }
        }
    }.start();
}//GEN-LAST:event_readUrlBActionPerformed

private void showReplaceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showReplaceActionPerformed
    visible = !visible;
    jToolBar2.setVisible(visible);
    replaceWhatT.setText(findT.getText());
}//GEN-LAST:event_showReplaceActionPerformed

private void replaceBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceBActionPerformed
    String string = area.getArea().getText();
    string = string.replaceFirst(replaceWhatT.getText(), replaceWithT.getText());
    area.getArea().setText(string);
}//GEN-LAST:event_replaceBActionPerformed

private void replaceAllBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_replaceAllBActionPerformed
    String string = area.getArea().getText();
    string = string.replaceAll(replaceWhatT.getText(), replaceWithT.getText());
    area.getArea().setText(string);
}//GEN-LAST:event_replaceAllBActionPerformed

private void fontSizeCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontSizeCActionPerformed
    try {
        int size = Integer.parseInt(String.valueOf(fontSizeC.getSelectedItem()));
        int style = fontStyleC.getSelectedIndex();
        area.setFont("Aerial", style, size);
    } catch (Exception e) {
        fontSizeC.setSelectedIndex(2);
    }
}//GEN-LAST:event_fontSizeCActionPerformed

private void fontStyleCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fontStyleCActionPerformed
    int size = Integer.parseInt((String.valueOf(fontSizeC.getSelectedItem())));
    int style = fontStyleC.getSelectedIndex();
    area.setFont("Aerial", style, size);

}//GEN-LAST:event_fontStyleCActionPerformed

    private void compileBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_compileBActionPerformed
        try {
            save();
            if (area.isSaved()) {
                if(workArea.getTitleAt(workArea.getSelectedIndex()).lastIndexOf(".java")>0){
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("javac " + workArea.getTitleAt(workArea.getSelectedIndex()));
                outputT.setText("Compiled Successfully");
                }else{
                    outputT.setText("File Should be of .java extension");
                }
            } else {
                outputT.setText("Cannot compile unsaved file");
            }
        } catch (Exception ex) {
            outputT.setText("Error in Compilation! " + ex);

        }
    }//GEN-LAST:event_compileBActionPerformed

    private void runBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_runBActionPerformed
        save();
        new Thread() {
            @Override
            public void run() {
                try {
                    Runtime rt = Runtime.getRuntime();
                    String location = workArea.getTitleAt(workArea.getSelectedIndex());
                    String fl = location.substring(location.lastIndexOf("\\") + 1, location.lastIndexOf("."));
                    location = location.substring(0, location.lastIndexOf("\\"));
                    Process pr = rt.exec("java -classpath \"" + location + "\" " + fl);
                    BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                    String line;
                    outputT.setText("");
                    while ((line = br.readLine()) != null) {
                        outputT.setText(outputT.getText() + line + "\n");
                    }

                } catch (IOException ex) {
                    outputT.setText(ex.toString());
                }
            }
        }.start();

    }//GEN-LAST:event_runBActionPerformed

    private void langBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_langBActionPerformed

        if (area.isHindi()) {
            langB.setToolTipText("English");
            area.setHindi(false);
            hmapB.setEnabled(false);
            langB.setIcon(new ImageIcon(getClass().getResource("/img/abc.png")));
        } else {
            langB.setToolTipText("Hindi");
            area.setHindi(true);
            hmapB.setEnabled(true);
            langB.setIcon(new ImageIcon(getClass().getResource("/img/a.png")));
        }
    }//GEN-LAST:event_langBActionPerformed

    private void hmapBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hmapBActionPerformed
        if (hMap == null) {
            hMap = new HindiMap();
        }
        if (hMap.isVisible()) {
            hMap.setVisible(false);
        } else {
            hMap.setVisible(true);
        }
    }//GEN-LAST:event_hmapBActionPerformed

    private void showOutputBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showOutputBActionPerformed
        if (output.isVisible()) {
            output.setVisible(false);
        } else {
            output.setVisible(true);
        }
    }//GEN-LAST:event_showOutputBActionPerformed

    public void find(String search, int pos, int d) {
        area.getArea().getHighlighter().removeAllHighlights();
        if (d == 1) {
            pos = area.getArea().getText().replaceAll("\n", "").indexOf(search, pos);
        }//replaceAll to remove new lines character
        if (d == -1) {
            pos = area.getArea().getText().replaceAll("\n", "").lastIndexOf(search, pos);
        }
        if (pos >= 0) {
            try {
                Highlighter h = area.getArea().getHighlighter();
                h.addHighlight(pos, pos + search.length(), new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN));
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(area.getArea(), ex);
            }
            if (d == -1) {
                this.pos = pos - search.length();
            }
            if (d == 1) {
                this.pos = pos + search.length();
            }
        }
    }

    public void findAll(String search, int pos) {
        pos = area.getArea().getText().replaceAll("\n", "").indexOf(search, pos);//replaceAll to remove new lines character        
        if (pos >= 0 && search.length() > 0) {
            try {
                Highlighter h = area.getArea().getHighlighter();
                h.addHighlight(pos, pos + search.length(), new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN));
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(area.getArea(), ex);
            }
            pos += search.length();
            if (pos < area.getArea().getText().length()) {
                findAll(search, pos);
            }//recursion
        }
    }

    public void save() {

        JFileChooser jfc = new JFileChooser();
        area = (Area) workArea.getSelectedComponent();
        if (!area.isSaved()) {
            int response = jfc.showSaveDialog(this);
            if (response == JFileChooser.APPROVE_OPTION) {
                file = jfc.getSelectedFile();
                if (file.exists()) {
                    response = JOptionPane.showConfirmDialog(this, "File allready exists, Dou you want to overrite");
                    if (response == JOptionPane.YES_OPTION) {
                        write(area);
                    } else if (response == JOptionPane.NO_OPTION) {
                        save();

                    }
                } else if (!file.exists()) {
                    write(area);
                }
                area.setSaved(true);
            }

        } else {
            write(area);
        }


    }

    private void write(Area area) {
        try {
            String str = area.getArea().getText();
            pw = new PrintWriter(new FileOutputStream(file));
            pw.write(str);
            pw.flush();
            String name = file.toString();
            //name = name.substring(name.lastIndexOf("\\") + 1, name.length());
            workArea.setTitleAt(workArea.getSelectedIndex(), name);
            area.setEdited(false);
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot Save");
        }
    }

    private void addTab(String title, Area area) {
        workArea.addTab(title, area);
        workArea.setSelectedIndex(workArea.getTabCount() - 1);
    }
    
    boolean taskDone = false;
    boolean running = true;
    private HindiMap hMap;
    private PrintWriter pw;
    private File file;
    private Area area;
    private int pos;
    private boolean visible;
    private About aboutWin = new About();
    boolean closeAll = false;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton aboutB;
    private javax.swing.JPanel bottomContainer;
    private javax.swing.JButton closeB;
    private javax.swing.JButton compileB;
    private javax.swing.JButton copyB;
    private javax.swing.JButton cutB;
    private javax.swing.Box.Filler filler1;
    private javax.swing.Box.Filler filler2;
    private javax.swing.JButton findNB;
    private javax.swing.JButton findPB;
    private javax.swing.JTextField findT;
    private javax.swing.JComboBox fontSizeC;
    private javax.swing.JComboBox fontStyleC;
    private javax.swing.JButton hmapB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator10;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JToolBar.Separator jSeparator4;
    private javax.swing.JToolBar.Separator jSeparator5;
    private javax.swing.JToolBar.Separator jSeparator6;
    private javax.swing.JToolBar.Separator jSeparator7;
    private javax.swing.JToolBar.Separator jSeparator8;
    private javax.swing.JToolBar.Separator jSeparator9;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JToolBar jToolBar2;
    private javax.swing.JButton langB;
    private javax.swing.JLabel linecurL;
    private javax.swing.JButton newB;
    private javax.swing.JButton openB;
    private javax.swing.JToolBar output;
    private javax.swing.JTextArea outputT;
    private javax.swing.JButton pasteB;
    private javax.swing.JProgressBar pbar;
    private javax.swing.JButton readUrlB;
    private javax.swing.JButton replaceAllB;
    private javax.swing.JButton replaceB;
    private javax.swing.JTextField replaceWhatT;
    private javax.swing.JTextField replaceWithT;
    private javax.swing.JButton runB;
    private javax.swing.JButton saveB;
    private javax.swing.JButton showOutputB;
    private javax.swing.JButton showReplace;
    private javax.swing.JToolBar topToolbar;
    private javax.swing.JTabbedPane workArea;
    // End of variables declaration//GEN-END:variables

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        closeAll = true;
        running = false;
    }

    @Override
    public void windowClosed(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}