/*
 * Decompiled with CFR 0.152.
 */
package zatackcoder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import zatackcoder.Help;
import zatackcoder.Timer;

public class Game
extends JFrame
implements ActionListener {
    private JButton swapB;
    private JButton[] buttons;
    private ImageIcon[] icon;
    private Image img;
    private Timer timer;
    private JLabel closeJL;
    private JPanel controlPanel;
    private JPanel gamePanelJP;
    private JLabel helpJL;
    private JButton loadJB;
    private JButton playPauseJB;
    private JButton shuffleJB;
    private JButton startStopJB;
    private JTextField timeJL;
    private JPanel timerPanel;

    public Game() {
        this.initComponents();
        this.gamePanelJP.setVisible(false);
    }

    private void initComponents() {
        this.controlPanel = new JPanel();
        this.startStopJB = new JButton();
        this.playPauseJB = new JButton();
        this.shuffleJB = new JButton();
        this.loadJB = new JButton();
        this.gamePanelJP = new JPanel();
        this.timerPanel = new JPanel();
        this.closeJL = new JLabel();
        this.timeJL = new JTextField();
        this.helpJL = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(204, 204, 255));
        this.setIconImage(new ImageIcon(this.getClass().getResource("/img/logo.png")).getImage());
        this.setLocationByPlatform(true);
        this.setUndecorated(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.controlPanel.setBackground(new Color(204, 204, 255));
        this.controlPanel.setFocusable(false);
        this.controlPanel.setOpaque(false);
        this.controlPanel.setPreferredSize(new Dimension(300, 40));
        this.controlPanel.setLayout(new GridLayout(1, 3));
        this.startStopJB.setFont(new Font("Tahoma", 1, 12));
        this.startStopJB.setForeground(new Color(0, 153, 153));
        this.startStopJB.setText("START");
        this.startStopJB.setToolTipText("Start or Stop");
        this.startStopJB.setBorder(null);
        this.startStopJB.setBorderPainted(false);
        this.startStopJB.setCursor(new Cursor(12));
        this.startStopJB.setFocusable(false);
        this.startStopJB.setMaximumSize(new Dimension(85, 31));
        this.startStopJB.setMinimumSize(new Dimension(85, 31));
        this.startStopJB.setPreferredSize(new Dimension(85, 31));
        this.startStopJB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Game.this.startStopJBActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.startStopJB);
        this.playPauseJB.setFont(new Font("Tahoma", 1, 12));
        this.playPauseJB.setForeground(new Color(0, 153, 153));
        this.playPauseJB.setText("PLAY");
        this.playPauseJB.setToolTipText("Play or Pause");
        this.playPauseJB.setBorder(null);
        this.playPauseJB.setCursor(new Cursor(12));
        this.playPauseJB.setFocusable(false);
        this.playPauseJB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Game.this.playPauseJBActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.playPauseJB);
        this.shuffleJB.setFont(new Font("Tahoma", 1, 12));
        this.shuffleJB.setForeground(new Color(0, 153, 153));
        this.shuffleJB.setText("SHUFFLE");
        this.shuffleJB.setToolTipText("Shuffle Tiles");
        this.shuffleJB.setBorder(null);
        this.shuffleJB.setCursor(new Cursor(12));
        this.shuffleJB.setFocusable(false);
        this.shuffleJB.setOpaque(false);
        this.shuffleJB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Game.this.shuffleJBActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.shuffleJB);
        this.loadJB.setFont(new Font("Tahoma", 1, 12));
        this.loadJB.setForeground(new Color(0, 153, 153));
        this.loadJB.setText("LOAD");
        this.loadJB.setToolTipText("Load Image");
        this.loadJB.setCursor(new Cursor(12));
        this.loadJB.setFocusable(false);
        this.loadJB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Game.this.loadJBActionPerformed(evt);
            }
        });
        this.controlPanel.add(this.loadJB);
        this.getContentPane().add((Component)this.controlPanel, "South");
        this.gamePanelJP.setBackground(new Color(204, 204, 255));
        this.gamePanelJP.setFocusable(false);
        this.gamePanelJP.setMaximumSize(new Dimension(240, 200));
        this.gamePanelJP.setMinimumSize(new Dimension(240, 200));
        this.gamePanelJP.setPreferredSize(new Dimension(240, 200));
        this.gamePanelJP.setRequestFocusEnabled(false);
        this.gamePanelJP.setLayout(new GridLayout(4, 4));
        this.getContentPane().add((Component)this.gamePanelJP, "Center");
        this.timerPanel.setBackground(new Color(204, 204, 255));
        this.timerPanel.setFocusCycleRoot(true);
        this.timerPanel.setPreferredSize(new Dimension(300, 25));
        this.timerPanel.setLayout(new BorderLayout());
        this.closeJL.setFont(new Font("Tahoma", 1, 18));
        this.closeJL.setHorizontalAlignment(0);
        this.closeJL.setText("X");
        this.closeJL.setToolTipText("Close");
        this.closeJL.setCursor(new Cursor(12));
        this.closeJL.setFocusable(false);
        this.closeJL.setMaximumSize(new Dimension(10, 10));
        this.closeJL.setMinimumSize(new Dimension(20, 20));
        this.closeJL.setPreferredSize(new Dimension(25, 25));
        this.closeJL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Game.this.closeJLMouseClicked(evt);
            }
        });
        this.timerPanel.add((Component)this.closeJL, "East");
        this.timeJL.setEditable(false);
        this.timeJL.setBackground(new Color(0, 102, 102));
        this.timeJL.setFont(new Font("Tahoma", 1, 11));
        this.timeJL.setForeground(new Color(255, 255, 255));
        this.timeJL.setHorizontalAlignment(0);
        this.timeJL.setText("0:0");
        this.timeJL.setToolTipText("");
        this.timeJL.setBorder(null);
        this.timeJL.setCursor(new Cursor(13));
        this.timeJL.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                Game.this.timeJLMouseDragged(evt);
            }
        });
        this.timeJL.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Game.this.timeJLKeyPressed(evt);
            }
        });
        this.timerPanel.add((Component)this.timeJL, "Center");
        this.helpJL.setFont(new Font("Tahoma", 1, 24));
        this.helpJL.setForeground(new Color(0, 153, 153));
        this.helpJL.setHorizontalAlignment(0);
        this.helpJL.setText("?");
        this.helpJL.setToolTipText("Left Click to see Image and Right Click to Hide Controls");
        this.helpJL.setCursor(new Cursor(12));
        this.helpJL.setFocusable(false);
        this.helpJL.setHorizontalTextPosition(0);
        this.helpJL.setPreferredSize(new Dimension(25, 25));
        this.helpJL.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Game.this.helpJLMouseClicked(evt);
            }
        });
        this.timerPanel.add((Component)this.helpJL, "Before");
        this.getContentPane().add((Component)this.timerPanel, "First");
        this.pack();
    }

    private void initGame() {
        this.buttons = new JButton[15];
        this.img = new ImageIcon(this.getClass().getResource("/img/C15.jpg")).getImage();
        this.icon = this.splitImage(this.img);
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new JButton();
            this.buttons[i].setFocusable(false);
            this.buttons[i].setSize(60, 50);
            this.buttons[i].addActionListener(this);
            this.buttons[i].setIcon(this.icon[i]);
            this.gamePanelJP.add(this.buttons[i]);
        }
        this.swapB = new JButton();
        this.swapB.setIcon(new ImageIcon(this.getClass().getResource("/img/blank.png")));
        this.gamePanelJP.add(this.swapB);
        this.gamePanelJP.setVisible(true);
        this.gamePanelJP.updateUI();
    }

    private void changeImage() {
        this.gamePanelJP.removeAll();
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].setIcon(this.icon[i]);
            this.gamePanelJP.add(this.buttons[i]);
        }
        this.swapB = new JButton();
        this.swapB.setIcon(new ImageIcon(this.getClass().getResource("/img/blank.png")));
        this.gamePanelJP.add(this.swapB);
        this.gamePanelJP.updateUI();
    }

    private void shuffleJBActionPerformed(ActionEvent evt) {
        this.shuffle();
    }

    private void closeJLMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            this.dispose();
            System.exit(1);
        }
    }

    private void timeJLKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 37) {
            this.setLocation(this.getLocation().x - 10, this.getLocation().y);
        }
        if (evt.getKeyCode() == 39) {
            this.setLocation(this.getLocation().x + 10, this.getLocation().y);
        }
        if (evt.getKeyCode() == 38) {
            this.setLocation(this.getLocation().x, this.getLocation().y - 10);
        }
        if (evt.getKeyCode() == 40) {
            this.setLocation(this.getLocation().x, this.getLocation().y + 10);
        }
    }

    private void loadJBActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = new JFileChooser();
        int response = filechooser.showOpenDialog(this.startStopJB);
        if (response == 0) {
            this.img = new ImageIcon(filechooser.getSelectedFile().toString()).getImage();
            this.icon = this.splitImage(this.img);
            this.changeImage();
        }
    }

    private void startStopJBActionPerformed(ActionEvent evt) {
        if (this.startStopJB.getText().equals("START")) {
            this.timer = new Timer(this.timeJL);
            this.timer.start();
            this.playPauseJB.setText("PAUSE");
            this.startStopJB.setText("STOP");
            this.gamePanelJP.removeAll();
            this.initGame();
        } else {
            this.timer.stopT();
            this.startStopJB.setText("START");
            this.playPauseJB.setText("PLAY");
            this.timeJL.setText("0:0");
            this.gamePanelJP.setVisible(false);
        }
    }

    private void playPauseJBActionPerformed(ActionEvent evt) {
        if (this.playPauseJB.getText().equals("PAUSE")) {
            this.playPauseJB.setText("PLAY");
            this.timer.pauseT();
        } else {
            this.playPauseJB.setText("PAUSE");
            this.timer.resumeT();
        }
    }

    private void helpJLMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1) {
            new Help(this.img, this.getX() + this.getWidth(), this.getY()).setVisible(true);
        }
        if (evt.getButton() == 3) {
            if (this.controlPanel.isVisible()) {
                this.setSize(this.getWidth(), this.getHeight() - 40);
                this.controlPanel.setVisible(false);
            } else {
                this.setSize(this.getWidth(), this.getHeight() + 40);
                this.controlPanel.setVisible(true);
            }
        }
    }

    private void timeJLMouseDragged(MouseEvent evt) {
        this.setLocation(evt.getXOnScreen() - 175, evt.getYOnScreen());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Game().setVisible(true);
            }
        });
    }

    public void shuffle() {
        this.gamePanelJP.removeAll();
        for (int i = 0; i < 100; ++i) {
            int x = (int)(Math.random() * 15.0);
            this.gamePanelJP.add(this.buttons[x]);
        }
        this.gamePanelJP.add(this.swapB);
        this.gamePanelJP.updateUI();
    }

    public void check() {
        boolean won = false;
        for (int i = 0; i < 15; ++i) {
            if (this.buttons[i] != this.gamePanelJP.getComponent(i)) {
                won = false;
                break;
            }
            won = true;
        }
        if (won) {
            this.timer.stopT();
            this.swapB.setIcon(this.icon[15]);
            JOptionPane.showMessageDialog(this.gamePanelJP, "You Won! " + this.timeJL.getText());
            this.startStopJB.setText("START");
            this.playPauseJB.setText("PLAY");
        }
    }

    public void move(JButton btn) {
        int btnIndex;
        int swapIndex;
        if (this.swapB == this.gamePanelJP.getComponentAt(btn.getX() + btn.getWidth(), btn.getY())) {
            swapIndex = this.gamePanelJP.getComponentZOrder(this.swapB);
            btnIndex = this.gamePanelJP.getComponentZOrder(btn);
            this.gamePanelJP.add((Component)btn, swapIndex);
            this.gamePanelJP.add((Component)this.swapB, btnIndex);
            this.gamePanelJP.updateUI();
        }
        if (this.swapB == this.gamePanelJP.getComponentAt(btn.getX() - btn.getWidth(), btn.getY())) {
            swapIndex = this.gamePanelJP.getComponentZOrder(this.swapB);
            btnIndex = this.gamePanelJP.getComponentZOrder(btn);
            this.gamePanelJP.add((Component)btn, swapIndex);
            this.gamePanelJP.add((Component)this.swapB, btnIndex);
            this.gamePanelJP.updateUI();
        }
        if (this.swapB == this.gamePanelJP.getComponentAt(btn.getX(), btn.getY() + btn.getHeight())) {
            swapIndex = this.gamePanelJP.getComponentZOrder(this.swapB);
            btnIndex = this.gamePanelJP.getComponentZOrder(btn);
            this.gamePanelJP.add((Component)btn, swapIndex);
            this.gamePanelJP.add((Component)this.swapB, btnIndex);
            this.gamePanelJP.updateUI();
        }
        if (this.swapB == this.gamePanelJP.getComponentAt(btn.getX(), btn.getY() - btn.getHeight())) {
            swapIndex = this.gamePanelJP.getComponentZOrder(this.swapB);
            btnIndex = this.gamePanelJP.getComponentZOrder(btn);
            this.gamePanelJP.add((Component)btn, swapIndex);
            this.gamePanelJP.add((Component)this.swapB, btnIndex);
            this.gamePanelJP.updateUI();
        }
    }

    public ImageIcon[] splitImage(Image img) {
        ImageIcon[] splittedIcons = new ImageIcon[16];
        BufferedImage bi = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        int width = bi.getWidth();
        int height = bi.getHeight();
        int pos = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                img = bi.getSubimage(j * (width / 4), i * (height / 4), width / 4, height / 4).getScaledInstance(85, 55, 2);
                splittedIcons[pos] = new ImageIcon();
                splittedIcons[pos].setImage(img);
                ++pos;
            }
        }
        return splittedIcons;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.move((JButton)e.getSource());
        this.check();
    }
}

