<?php

// load GCS library
require_once 'vendor/autoload.php';

use Google\Cloud\Storage\StorageClient;

// Please use your own private key (JSON file content) and copy it here
// your private key JSON structure should be similar like dummy value below.
// WARNING: this is only for QUICK TESTING to verify whether private key is valid (working) or not.  
// NOTE: to create private key JSON file: https://console.cloud.google.com/apis/credentials  
$privateKeyFileContent = '{
  "type": "service_account",
  "project_id": "zatackcoder",
  "private_key_id": "2e9eb9a5a425df0f5523b03c3e72298568ff85c5",
  "private_key": "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDMeM7mJsqMqa6w\nVxO2sLHMVa2wnMDuLFWjONFBeMlCAQKCDerbiwxUlbzRudSnC+/HE8gq4An3DWOu\nHTTG3pPUNn4jr2YCEDT12P8zX74spKhWCu9zUA773klo0pNxqbQcLLlZ5gEMStaU\n1UGzkYBroqXzq6q4L59OIHCckIqtkmDy9ssZB2XOvpRuRwqucI6Ai5SnBU+Q3qsE\nJAbbgl2flDuVUFUkR1I+az+gPYRevD3CfveMvPmWnsUzVmCxXw9XUfG3FwGd957X\n+3iCoCnzh1cjMbhhaxsCFvusP9y+d9Kzv1ibLz6XqoWmFbuM6ZTYXQJO9Y1kmXDP\n7DfqTMZvAgMBAAECggEATl5NOnQKtPACJs8xHJfLhZwfFq512bN/XTBVL6laReR6\nMBuidOPt5WuAs8dsRFw0WhJwaVJ2L0zf9Cd4h3JeqXr7TLUYvVi127aAVZHwI082\nv8ewL/uyyoFPlJAE+A8Jm7Tek6CurSXv6Zp09JyjYl20Clk09SQ3hCu1zaQuqshb\nyMjo4SEcxNX7NLb+9QL79JnRxyAlIpjLLVUOZtzs7FPIIjDmHhwmTOrc8mS+RBpQ\nHc7rKijuafy4rUDipYe8wioJAJWpMBiEGo3aYT63CJ9C8Lkf+M2PH1fDjph0dNxU\njYDzDVa6J2Dfqw7i16kBPd3bXtdimPfz4cXNi+4v4QKBgQD/9woiyozfhtzDkbug\n/ZGAghxZO7ts9Et6yW9rmpS5Gu7gEkplQBx8xagA06P1Eejh3FXzk+gB5uJBbYWf\nGtcArXesjOauzyu4ynHDx8Q/nYCvz55+EzNzv3UrXCo3cGbYfjciQQxKi+mo8Sd4\nHSnQtwyCRnWWrOMECYyEZb2voQKBgQDMf/dNDgqulEqwHRTXSYSZQJYB9CyLtvzJ\nbKhec2jU8P8urcg32DMVwALZEsXWAF3jJtoD0C+75dKDB2syb7Zmq3Ru34HqVdL5\niJkSFGhJrQY8MQo2uVEEIhDRSuwegFbJR85GR12d463qUYaHPxhzPCIEvLjWzxYz\n7a5p3C38DwKBgQD73TL9Dv/VRxfd3H2aqUfOArkwWOVRDYVj+egIIqArEERy+ax4\nusANSlTJE3emwwu7ixqMRkKp9G034jP0Xe2nvgkfIbov0qz79UBCXERQMIQa+xnC\nhtQ/FeqOUu87g/+/EVrg+s7EX634zep/d3rY4/WMDxbPv6jWJSs+b/pZYQKBgFee\nvKcXTRxgDWBIFZXouhevxJYxuKRkUws6sylE6bXTTIMDkrXavIilLJM1p+55WcDp\n9J+No+YuInRhyVxi4RQ8gja/LTrqaurfzDYi6EwpBnLj0CyCWmQa9Hm4UFMBSi4T\nxh32lfYAh5POOoXYUvGM4kaFVe0z7Z9yRzi0Tj+hAoGABhee7aesVUxg9wr6kggi\nqpfCGnSozSaglazC4zbXG9O6ceOjXgcfEeNzuS37jYifQ0BBjtdanIJSLLMDhdCr\nfbUn0luOZrVG9u3QzGff3Wik/eX+BNMYjrSiPgGzz2NODzpK/eLbk2RjfwQ5plZY\nTOekZJ531m3u4Iq+dk7AEyY=\n-----END PRIVATE KEY-----\n",
  "client_email": "gcp-storage-upload@zatackcoder.iam.gserviceaccount.com",
  "client_id": "108205626672065013377",
  "auth_uri": "https://accounts.google.com/o/oauth2/auth",
  "token_uri": "https://oauth2.googleapis.com/token",
  "auth_provider_x509_cert_url": "https://www.googleapis.com/oauth2/v1/certs",
  "client_x509_cert_url": "https://www.googleapis.com/robot/v1/metadata/x509/gcp-storage-upload%40zatackcoder.iam.gserviceaccount.com"
}';

/*
 * NOTE: if the server is a shared hosting by third party company then private key should not be stored as a file,
 * may be better to encrypt the private key value then store the 'encrypted private key' value as string in database,
 * so every time before use the private key we can get a user-input (from UI) to get password to decrypt it.
 */

function uploadFile($bucketName, $fileContent, $cloudPath) {
    $privateKeyFileContent = $GLOBALS['privateKeyFileContent'];
    // connect to Google Cloud Storage using private key as authentication
    try {
        $storage = new StorageClient([
            'keyFile' => json_decode($privateKeyFileContent, true)
        ]);
    } catch (Exception $e) {
        // maybe invalid private key ?
        print $e;
        return false;
    }

    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);

    // upload/replace file 
    $storageObject = $bucket->upload(
            $fileContent,
            ['name' => $cloudPath]
            // if $cloudPath is existed then will be overwrite without confirmation
            // NOTE: 
            // a. do not put prefix '/', '/' is a separate folder name  !!
            // b. private key MUST have 'storage.objects.delete' permission if want to replace file !
    );

    // is it succeed ?
    return $storageObject != null;
}

function getFileInfo($bucketName, $cloudPath) {
    $privateKeyFileContent = $GLOBALS['privateKeyFileContent'];
    // connect to Google Cloud Storage using private key as authentication
    try {
        $storage = new StorageClient([
            'keyFile' => json_decode($privateKeyFileContent, true)
        ]);
    } catch (Exception $e) {
        // maybe invalid private key ?
        print $e;
        return false;
    }

    // set which bucket to work in
    $bucket = $storage->bucket($bucketName);
    $object = $bucket->object($cloudPath);
    return $object->info();
}
//this (listFiles) method not used in this example but you may use according to your need 
function listFiles($bucket, $directory = null) {

    if ($directory == null) {
        // list all files
        $objects = $bucket->objects();
    } else {
        // list all files within a directory (sub-directory)
        $options = array('prefix' => $directory);
        $objects = $bucket->objects($options);
    }

    foreach ($objects as $object) {
        print $object->name() . PHP_EOL;
        // NOTE: if $object->name() ends with '/' then it is a 'folder'
    }
}
