/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package urlcheckingtool;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.SwingUtilities;

/**
 *
 * @author rajesh kumar sahanee
 */
public class MainForm extends javax.swing.JFrame {

    /**
     * Creates new form MainForm
     */
    public MainForm() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainSP = new javax.swing.JSplitPane();
        leftJP = new javax.swing.JPanel();
        urlsJL = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        urlsJTA = new javax.swing.JTextArea();
        processJB = new javax.swing.JButton();
        processJPB = new javax.swing.JProgressBar();
        jPanel1 = new javax.swing.JPanel();
        cb301CB = new javax.swing.JCheckBox();
        cb403CB = new javax.swing.JCheckBox();
        cb404CB = new javax.swing.JCheckBox();
        cb500CB = new javax.swing.JCheckBox();
        rightSP = new javax.swing.JSplitPane();
        jPanel2 = new javax.swing.JPanel();
        notFoundUrlsJL = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        notFoundUrlsJTA = new javax.swing.JTextArea();
        jPanel3 = new javax.swing.JPanel();
        workingUrlsJL = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        workingUrlsJTA = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Url Checking Tool");

        leftJP.setMinimumSize(new java.awt.Dimension(260, 0));
        leftJP.setPreferredSize(new java.awt.Dimension(200, 435));

        urlsJL.setText("Urls");

        urlsJTA.setColumns(20);
        urlsJTA.setRows(5);
        jScrollPane4.setViewportView(urlsJTA);

        processJB.setText("Process");
        processJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                processJBActionPerformed(evt);
            }
        });

        jPanel1.setAutoscrolls(true);

        cb301CB.setText("301");

        cb403CB.setText("403");

        cb404CB.setText("404");

        cb500CB.setText("500");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cb301CB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cb403CB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cb404CB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cb500CB)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cb301CB)
                    .addComponent(cb403CB)
                    .addComponent(cb404CB)
                    .addComponent(cb500CB))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout leftJPLayout = new javax.swing.GroupLayout(leftJP);
        leftJP.setLayout(leftJPLayout);
        leftJPLayout.setHorizontalGroup(
            leftJPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(leftJPLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(leftJPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane4)
                    .addGroup(leftJPLayout.createSequentialGroup()
                        .addComponent(processJB)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(processJPB, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                    .addGroup(leftJPLayout.createSequentialGroup()
                        .addComponent(urlsJL)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        leftJPLayout.setVerticalGroup(
            leftJPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, leftJPLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(urlsJL)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 354, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(leftJPLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(processJPB, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(processJB, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(6, 6, 6))
        );

        mainSP.setLeftComponent(leftJP);

        rightSP.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel2.setMinimumSize(new java.awt.Dimension(0, 200));
        jPanel2.setPreferredSize(new java.awt.Dimension(200, 200));

        notFoundUrlsJL.setText("Not Working Urls");

        notFoundUrlsJTA.setColumns(20);
        notFoundUrlsJTA.setRows(5);
        jScrollPane1.setViewportView(notFoundUrlsJTA);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(notFoundUrlsJL)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(notFoundUrlsJL)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 155, Short.MAX_VALUE)
                .addContainerGap())
        );

        rightSP.setLeftComponent(jPanel2);

        workingUrlsJL.setText("Working Urls");

        workingUrlsJTA.setColumns(20);
        workingUrlsJTA.setRows(5);
        jScrollPane2.setViewportView(workingUrlsJTA);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addComponent(workingUrlsJL)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(workingUrlsJL)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 212, Short.MAX_VALUE)
                .addContainerGap())
        );

        rightSP.setRightComponent(jPanel3);

        mainSP.setRightComponent(rightSP);

        getContentPane().add(mainSP, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void processJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_processJBActionPerformed
        if(processJB.getText().equals("Process")) {
            stop = false;
            processJB.setText("Stop");
        } else {
            stop = true;
            processJB.setText("Process");
            return;
        }
        String urls[] = urlsJTA.getText().split("\n");
        notFoundUrls = "";
        workingUrls = "";     
        
        processJPB.setValue(-1);
        processJPB.setIndeterminate(true);
        
        final ArrayList<String> errorCodes = new ArrayList();
        if(cb301CB.isSelected()) {
            errorCodes.add("301");
        }
        if(cb403CB.isSelected()) {
            errorCodes.add("403");
        }
        if(cb404CB.isSelected()) {
            errorCodes.add("404");
        }
        if(cb500CB.isSelected()) {
            errorCodes.add("500");
        }
        
        Thread worker = new Thread() {

            public void run() {        
                for(int i = 0; i < urls.length; i++) {
                    if(stop) {
                        break;
                    }
                    try {
                        if (errorCodes.contains(getResponseCode(urls[i]))) {
                            notFoundUrls += urls[i] + "\n";
                        } else {
                            workingUrls += urls[i] + "\n";
                        }                 
                        
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {                                
                                notFoundUrlsJTA.setText(notFoundUrls);
                                workingUrlsJTA.setText(workingUrls);
                            }
                        });
                        //Thread.sleep(500);
                    } catch (IOException e) {

                    }
                }
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {
                        processJPB.setIndeterminate(false);
                        processJPB.setValue(100);  
                        processJB.setText("Process");
                    }
                });
            }
        };

        worker.start(); // So we don't hold up the dispatch thread.
        
    }//GEN-LAST:event_processJBActionPerformed
 
    public static String getResponseCode(String urlString) throws MalformedURLException, IOException {
        if(!urlString.startsWith("http://") && !urlString.startsWith("https://")) {
            urlString = "http://" + urlString;
        }
        URL u = new URL(urlString);        
        if (u.getProtocol().equals("https")) {
            HttpsURLConnection huc = (HttpsURLConnection) u.openConnection();
            huc.setRequestMethod("GET");    
            huc.setConnectTimeout(10000);
            huc.connect();            
            return String.valueOf(huc.getResponseCode());
        } else {
            HttpURLConnection huc = (HttpURLConnection) u.openConnection();
            huc.setRequestMethod("GET");
            huc.setConnectTimeout(10000);
            huc.connect();                
            return String.valueOf(huc.getResponseCode());
        }
    }

    String notFoundUrls = new String();
    String workingUrls = new String();   
    boolean stop = false;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cb301CB;
    private javax.swing.JCheckBox cb403CB;
    private javax.swing.JCheckBox cb404CB;
    private javax.swing.JCheckBox cb500CB;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JPanel leftJP;
    private javax.swing.JSplitPane mainSP;
    private javax.swing.JLabel notFoundUrlsJL;
    private javax.swing.JTextArea notFoundUrlsJTA;
    private javax.swing.JButton processJB;
    private javax.swing.JProgressBar processJPB;
    private javax.swing.JSplitPane rightSP;
    private javax.swing.JLabel urlsJL;
    private javax.swing.JTextArea urlsJTA;
    private javax.swing.JLabel workingUrlsJL;
    private javax.swing.JTextArea workingUrlsJTA;
    // End of variables declaration//GEN-END:variables
}
