/*
 * Decompiled with CFR 0.152.
 */
package urlcheckingtool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class MainForm
extends JFrame {
    String notFoundUrls = new String();
    String workingUrls = new String();
    boolean stop = false;
    private JCheckBox cb301CB;
    private JCheckBox cb403CB;
    private JCheckBox cb404CB;
    private JCheckBox cb500CB;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JPanel leftJP;
    private JSplitPane mainSP;
    private JLabel notFoundUrlsJL;
    private JTextArea notFoundUrlsJTA;
    private JButton processJB;
    private JProgressBar processJPB;
    private JSplitPane rightSP;
    private JLabel urlsJL;
    private JTextArea urlsJTA;
    private JLabel workingUrlsJL;
    private JTextArea workingUrlsJTA;

    public MainForm() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainSP = new JSplitPane();
        this.leftJP = new JPanel();
        this.urlsJL = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.urlsJTA = new JTextArea();
        this.processJB = new JButton();
        this.processJPB = new JProgressBar();
        this.jPanel1 = new JPanel();
        this.cb301CB = new JCheckBox();
        this.cb403CB = new JCheckBox();
        this.cb404CB = new JCheckBox();
        this.cb500CB = new JCheckBox();
        this.rightSP = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.notFoundUrlsJL = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.notFoundUrlsJTA = new JTextArea();
        this.jPanel3 = new JPanel();
        this.workingUrlsJL = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.workingUrlsJTA = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.setTitle("Url Checking Tool");
        this.leftJP.setMinimumSize(new Dimension(260, 0));
        this.leftJP.setPreferredSize(new Dimension(200, 435));
        this.urlsJL.setText("Urls");
        this.urlsJTA.setColumns(20);
        this.urlsJTA.setRows(5);
        this.jScrollPane4.setViewportView(this.urlsJTA);
        this.processJB.setText("Process");
        this.processJB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainForm.this.processJBActionPerformed(evt);
            }
        });
        this.jPanel1.setAutoscrolls(true);
        this.cb301CB.setText("301");
        this.cb403CB.setText("403");
        this.cb404CB.setText("404");
        this.cb500CB.setText("500");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.cb301CB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cb403CB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cb404CB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cb500CB).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cb301CB).addComponent(this.cb403CB).addComponent(this.cb404CB).addComponent(this.cb500CB)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout leftJPLayout = new GroupLayout(this.leftJP);
        this.leftJP.setLayout(leftJPLayout);
        leftJPLayout.setHorizontalGroup(leftJPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftJPLayout.createSequentialGroup().addContainerGap().addGroup(leftJPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addGroup(leftJPLayout.createSequentialGroup().addComponent(this.processJB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processJPB, -2, 0, Short.MAX_VALUE)).addGroup(leftJPLayout.createSequentialGroup().addComponent(this.urlsJL).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        leftJPLayout.setVerticalGroup(leftJPLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftJPLayout.createSequentialGroup().addContainerGap().addComponent(this.urlsJL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 354, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(leftJPLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.processJPB, -1, -1, Short.MAX_VALUE).addComponent(this.processJB, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6)));
        this.mainSP.setLeftComponent(this.leftJP);
        this.rightSP.setOrientation(0);
        this.jPanel2.setMinimumSize(new Dimension(0, 200));
        this.jPanel2.setPreferredSize(new Dimension(200, 200));
        this.notFoundUrlsJL.setText("Not Working Urls");
        this.notFoundUrlsJTA.setColumns(20);
        this.notFoundUrlsJTA.setRows(5);
        this.jScrollPane1.setViewportView(this.notFoundUrlsJTA);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 286, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.notFoundUrlsJL).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.notFoundUrlsJL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 155, Short.MAX_VALUE).addContainerGap()));
        this.rightSP.setLeftComponent(this.jPanel2);
        this.workingUrlsJL.setText("Working Urls");
        this.workingUrlsJTA.setColumns(20);
        this.workingUrlsJTA.setRows(5);
        this.jScrollPane2.setViewportView(this.workingUrlsJTA);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 286, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.workingUrlsJL).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.workingUrlsJL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 212, Short.MAX_VALUE).addContainerGap()));
        this.rightSP.setRightComponent(this.jPanel3);
        this.mainSP.setRightComponent(this.rightSP);
        this.getContentPane().add((Component)this.mainSP, "Center");
        this.pack();
    }

    private void processJBActionPerformed(ActionEvent evt) {
        if (!this.processJB.getText().equals("Process")) {
            this.stop = true;
            this.processJB.setText("Process");
            return;
        }
        this.stop = false;
        this.processJB.setText("Stop");
        final String[] urls = this.urlsJTA.getText().split("\n");
        this.notFoundUrls = "";
        this.workingUrls = "";
        this.processJPB.setValue(-1);
        this.processJPB.setIndeterminate(true);
        final ArrayList<String> errorCodes = new ArrayList<String>();
        if (this.cb301CB.isSelected()) {
            errorCodes.add("301");
        }
        if (this.cb403CB.isSelected()) {
            errorCodes.add("403");
        }
        if (this.cb404CB.isSelected()) {
            errorCodes.add("404");
        }
        if (this.cb500CB.isSelected()) {
            errorCodes.add("500");
        }
        Thread worker = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < urls.length && !MainForm.this.stop; ++i) {
                    try {
                        if (errorCodes.contains(MainForm.getResponseCode(urls[i]))) {
                            MainForm.this.notFoundUrls = MainForm.this.notFoundUrls + urls[i] + "\n";
                        } else {
                            MainForm.this.workingUrls = MainForm.this.workingUrls + urls[i] + "\n";
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainForm.this.notFoundUrlsJTA.setText(MainForm.this.notFoundUrls);
                                MainForm.this.workingUrlsJTA.setText(MainForm.this.workingUrls);
                            }
                        });
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainForm.this.processJPB.setIndeterminate(false);
                        MainForm.this.processJPB.setValue(100);
                        MainForm.this.processJB.setText("Process");
                    }
                });
            }
        };
        worker.start();
    }

    public static String getResponseCode(String urlString) throws MalformedURLException, IOException {
        URL u;
        if (!urlString.startsWith("http://") && !urlString.startsWith("https://")) {
            urlString = "http://" + urlString;
        }
        if ((u = new URL(urlString)).getProtocol().equals("https")) {
            HttpsURLConnection huc = (HttpsURLConnection)u.openConnection();
            huc.setRequestMethod("GET");
            huc.setConnectTimeout(10000);
            huc.connect();
            return String.valueOf(huc.getResponseCode());
        }
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        huc.setRequestMethod("GET");
        huc.setConnectTimeout(10000);
        huc.connect();
        return String.valueOf(huc.getResponseCode());
    }
}

